/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegritySCM;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckoutTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 1240357991626897900L;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final IntegritySCM scm;
    private final IntegrityCMProject siProject;
    private final boolean cleanCopy;
    private final BuildListener listener;

    public IntegrityCheckoutTask(IntegritySCM scm, IntegrityCMProject siProject, boolean cleanCopy, BuildListener listener) {
        this.scm = scm;
        this.siProject = siProject;
        this.cleanCopy = cleanCopy;
        this.listener = listener;
        this.logger.info((Object)"Integrity Checkout Task Created!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean invoke(File workspaceFile, VirtualChannel channel) throws IOException {
        block14: {
            FilePath workspace = new FilePath(workspaceFile);
            APISession api = this.scm.createAPISession();
            if (null == api) {
                this.listener.getLogger().println("Failed to establish an API connection to the MKS Integrity Server!");
                return false;
            }
            try {
                if (this.cleanCopy) {
                    this.listener.getLogger().println("A clean copy is requested; deleting contents of " + workspace);
                    this.logger.info((Object)("Deleting contents of workspace " + workspace));
                    workspace.deleteContents();
                    this.listener.getLogger().println("Populating clean workspace...");
                    List<IntegrityCMMember> projectMembers = this.siProject.getProjectMembers();
                    for (IntegrityCMMember siMember : projectMembers) {
                        siMember.setWorkspaceDir("" + workspace);
                        this.logger.info((Object)("Attempting to checkout file: " + siMember.getTargetFilePath() + " at revision " + siMember.getRevision()));
                        siMember.checkout(api);
                    }
                    this.listener.getLogger().println("Successfully checked out " + projectMembers.size() + " files!");
                    break block14;
                }
                List<IntegrityCMMember> newMembersList = this.siProject.getAddedMembers();
                for (IntegrityCMMember siMember : newMembersList) {
                    siMember.setWorkspaceDir("" + workspace);
                    this.logger.info((Object)("Attempting to get new file: " + siMember.getTargetFilePath() + " at revision " + siMember.getRevision()));
                    siMember.checkout(api);
                }
                List<IntegrityCMMember> updatedMembersList = this.siProject.getUpdatedMembers();
                for (IntegrityCMMember siMember : updatedMembersList) {
                    siMember.setWorkspaceDir("" + workspace);
                    this.logger.info((Object)("Attempting to update file: " + siMember.getTargetFilePath() + " to revision " + siMember.getRevision()));
                    siMember.checkout(api);
                }
                List<IntegrityCMMember> memberDropList = this.siProject.getDroppedMembers();
                for (IntegrityCMMember siMember : memberDropList) {
                    siMember.setWorkspaceDir("" + workspace);
                    this.logger.info((Object)("Attempting to drop file: " + siMember.getTargetFilePath() + " was at revision " + siMember.getRevision()));
                    File dropFile = new File(siMember.getTargetFilePath());
                    if (!dropFile.exists() || dropFile.delete()) continue;
                    this.listener.getLogger().println("Failed to clean up workspace file " + dropFile.getAbsolutePath() + "!");
                    Boolean bl = false;
                    return bl;
                }
                this.listener.getLogger().println("Successfully updated workspace with " + (newMembersList.size() + updatedMembersList.size()) + " updates and cleaned up " + memberDropList.size() + " files!");
            }
            catch (APIException aex) {
                this.logger.error((Object)"API Exception caught...");
                this.listener.getLogger().println("An API Exception was caught!");
                ExceptionHandler eh = new ExceptionHandler(aex);
                this.logger.error((Object)eh.getMessage());
                this.listener.getLogger().println(eh.getMessage());
                this.logger.info((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                this.listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                aex.printStackTrace();
                Boolean bl = false;
                return bl;
            }
            catch (InterruptedException iex) {
                this.logger.error((Object)"Interrupted Exception caught...");
                this.listener.getLogger().println("An Interrupted Exception was caught!");
                this.logger.error((Object)iex.getMessage());
                this.listener.getLogger().println(iex.getMessage());
                this.listener.getLogger().println("Failed to clean up workspace (" + workspace + ") contents!");
                Boolean bl = false;
                return bl;
            }
            finally {
                api.Terminate();
            }
        }
        return true;
    }
}

