/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.MultiValue;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.util.Base64;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.ChangeLogParser;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegrityChangeLogParser;
import hudson.scm.IntegrityCheckoutTask;
import hudson.scm.IntegrityRepositoryBrowser;
import hudson.scm.IntegrityRevisionState;
import hudson.scm.IntegritySCM;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class IntegritySCM
extends SCM
implements Serializable {
    private static final long serialVersionUID = 7559894846609712683L;
    public static final String NL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final SimpleDateFormat SDF = new SimpleDateFormat("MMM dd, yyyy h:mm:ss a");
    private final Log logger = LogFactory.getLog(this.getClass());
    private String integrityURL;
    private IntegrityRepositoryBrowser browser;
    private String hostName;
    private int port;
    private boolean secure;
    private String configPath;
    private String userName;
    private String password;
    private boolean cleanCopy;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private transient IntegrityCMProject siProject;

    @DataBoundConstructor
    public IntegritySCM(IntegrityRepositoryBrowser browser, String hostName, int port, boolean secure, String configPath, String userName, String password, boolean cleanCopy, String lineTerminator, boolean restoreTimestamp) {
        this.logger.info((Object)"IntegritySCM constructor has been invoked!");
        this.browser = browser;
        this.hostName = hostName;
        this.port = port;
        this.secure = secure;
        this.configPath = configPath;
        this.userName = userName;
        this.password = Base64.encode((String)password);
        this.cleanCopy = cleanCopy;
        this.lineTerminator = lineTerminator;
        this.restoreTimestamp = restoreTimestamp;
        this.initIntegrityURL();
        this.logger.info((Object)("URL: " + this.integrityURL));
        this.logger.info((Object)("Host: " + this.hostName));
        this.logger.info((Object)("Port: " + this.port));
        this.logger.info((Object)("User: " + this.userName));
        this.logger.info((Object)("Password: " + this.password));
        this.logger.info((Object)("Secure: " + this.secure));
        this.logger.info((Object)("Project: " + this.configPath));
        this.logger.info((Object)("Line Terminator: " + this.lineTerminator));
        this.logger.info((Object)("Restore Timestamp: " + this.restoreTimestamp));
        this.logger.info((Object)("Clean: " + this.cleanCopy));
    }

    @Exported
    public IntegrityRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return Base64.decode((String)this.password);
    }

    public boolean getCleanCopy() {
        return this.cleanCopy;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public boolean getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.initIntegrityURL();
    }

    public void setPort(int port) {
        this.port = port;
        this.initIntegrityURL();
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.initIntegrityURL();
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = Base64.encode((String)password);
    }

    public void setCleanCopy(boolean cleanCopy) {
        this.cleanCopy = cleanCopy;
    }

    public void getLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    private void initIntegrityURL() {
        this.integrityURL = this.secure ? "https://" + this.hostName + ":" + String.valueOf(this.port) : "http://" + this.hostName + ":" + String.valueOf(this.port);
    }

    public APISession createAPISession() {
        try {
            this.logger.info((Object)"Creating MKS API Session...");
            return new APISession(this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
        }
        catch (APIException aex) {
            this.logger.error((Object)"API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            this.logger.error((Object)eh.getMessage());
            this.logger.info((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
            aex.printStackTrace();
            return null;
        }
    }

    public IntegrityCMProject getIntegrityProject() {
        return this.siProject;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        this.logger.info((Object)"buildEnvVars() invoked...!");
        env.put("MKSSI_PROJECT", this.configPath);
        env.put("MKSSI_HOST", this.hostName);
        env.put("MKSSI_PORT", String.valueOf(this.port));
        env.put("MKSSI_USER", this.userName);
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.logger.info((Object)"calcRevisionsFromBuild() invoked...!");
        Object obj = this.getIntegrityCMProjectState(build);
        if (obj instanceof IntegrityCMProject && null != obj) {
            IntegrityCMProject cmProject = (IntegrityCMProject)obj;
            return new IntegrityRevisionState(cmProject);
        }
        this.logger.info((Object)("Cannot construct project state for build " + build.getNumber() + "!"));
        return new IntegrityRevisionState(null);
    }

    private Response initializeCMProject(APISession api) throws APIException {
        Command siProjectInfoCmd = new Command("si", "projectinfo");
        siProjectInfoCmd.addOption(new Option("project", this.configPath));
        this.logger.info((Object)("Preparing to execute si projectinfo for " + this.configPath));
        Response infoRes = api.runCommand(siProjectInfoCmd);
        this.logger.info((Object)(infoRes.getCommandString() + " returned " + infoRes.getExitCode()));
        this.siProject = new IntegrityCMProject(infoRes.getWorkItems().next());
        this.siProject.setLineTerminator(this.lineTerminator);
        this.siProject.setRestoreTimestamp(this.restoreTimestamp);
        return infoRes;
    }

    private Response initializeCMProjectMembers(APISession api) throws APIException {
        Command siViewProjectCmd = new Command("si", "viewproject");
        siViewProjectCmd.addOption(new Option("recurse"));
        siViewProjectCmd.addOption(new Option("project", this.siProject.getConfigurationPath()));
        MultiValue mvFields = new MultiValue(",");
        mvFields.add("name");
        mvFields.add("context");
        mvFields.add("memberrev");
        mvFields.add("membertimestamp");
        mvFields.add("memberdescription");
        siViewProjectCmd.addOption(new Option("fields", mvFields));
        this.logger.info((Object)("Preparing to execute si viewproject for " + this.siProject.getConfigurationPath()));
        Response viewRes = api.runCommand(siViewProjectCmd);
        this.logger.info((Object)(viewRes.getCommandString() + " returned " + viewRes.getExitCode()));
        this.siProject.parseProject(viewRes.getWorkItems(), api);
        return viewRes;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIntegrityCMProjectState(AbstractBuild<?, ?> build) throws IOException {
        if (null != build) {
            File viewProjectFile = IntegritySCM.getViewProjectResponseFile(build);
            if (!viewProjectFile.exists()) {
                this.logger.info((Object)("Project state not found for build " + build.getNumber() + "!"));
                return null;
            }
            this.logger.info((Object)("Attempting to load up project state for build " + build.getNumber() + "..."));
            FileInputStream fis = new FileInputStream(viewProjectFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object obj = null;
            try {
                obj = ois.readObject();
                this.logger.info((Object)("Project state re-constructed successfully for build " + build.getNumber() + "!"));
            }
            catch (ClassNotFoundException cne) {
                this.logger.info((Object)("Caught Exception: " + cne.getMessage()));
                this.logger.info((Object)("Cannot construct project state for build" + build.getNumber() + "!"));
            }
            finally {
                ois.close();
                fis.close();
            }
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        block11: {
            this.logger.info((Object)"Start execution of checkout() routine...!");
            APISession api = this.createAPISession();
            if (null == api) {
                listener.getLogger().println("Failed to establish an API connection to the MKS Integrity Server!");
                return false;
            }
            PrintWriter writer = new PrintWriter(new FileWriter(changeLogFile));
            try {
                Object obj;
                listener.getLogger().println("Preparing to execute si projectinfo for " + this.configPath);
                this.initializeCMProject(api);
                listener.getLogger().println("Preparing to execute si viewproject for " + this.configPath);
                this.initializeCMProjectMembers(api);
                AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
                if (null == previousBuild) {
                    this.logger.info((Object)"Cannot find a previous build!");
                }
                for (AbstractBuild b = (AbstractBuild)build.getPreviousBuild(); null != b; b = (AbstractBuild)b.getPreviousBuild()) {
                    if (!IntegritySCM.getViewProjectResponseFile((AbstractBuild)b).exists()) continue;
                    this.logger.info((Object)("Found previous project state in build " + b.getNumber()));
                    previousBuild = b;
                    break;
                }
                if ((obj = this.getIntegrityCMProjectState(previousBuild)) instanceof IntegrityCMProject && null != obj) {
                    IntegrityCMProject oldProject = (IntegrityCMProject)obj;
                    this.siProject.compareBaseline(oldProject);
                } else {
                    this.logger.info((Object)"Cannot construct project state for any of the pevious builds!");
                }
                IntegrityCheckoutTask coTask = null;
                coTask = null == obj ? new IntegrityCheckoutTask(this, this.siProject, true, listener) : new IntegrityCheckoutTask(this, this.siProject, this.cleanCopy, listener);
                if (((Boolean)workspace.act((FilePath.FileCallable)coTask)).booleanValue()) {
                    listener.getLogger().println("Saving current MKS Integrity Project configuration...");
                    this.printViewProjectResponse(build, listener, this.siProject);
                    listener.getLogger().println("Writing build change log...");
                    writer.println(this.siProject.getChangeLog(String.valueOf(build.getNumber()), api));
                    listener.getLogger().println("Change log successfully generated: " + changeLogFile.getAbsolutePath());
                    break block11;
                }
                boolean bl = false;
                return bl;
            }
            catch (APIException aex) {
                this.logger.error((Object)"API Exception caught...");
                listener.getLogger().println("An API Exception was caught!");
                ExceptionHandler eh = new ExceptionHandler(aex);
                this.logger.error((Object)eh.getMessage());
                listener.getLogger().println(eh.getMessage());
                this.logger.info((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                aex.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                writer.close();
                api.Terminate();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printViewProjectResponse(AbstractBuild<?, ?> build, BuildListener listener, IntegrityCMProject pj) throws IOException {
        File viewProjectFile = new File(build.getRootDir(), "viewproject.dat");
        FileOutputStream fos = new FileOutputStream(viewProjectFile);
        ObjectOutputStream pjOut = new ObjectOutputStream(fos);
        try {
            pjOut.writeObject(pj);
            listener.getLogger().println("API Response for si viewproject successfully saved to file!");
        }
        finally {
            pjOut.close();
            fos.close();
        }
        listener.getLogger().println("Successfully saved current MKS Integrity Project configuration to " + viewProjectFile.getAbsolutePath());
    }

    public static File getViewProjectResponseFile(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "viewproject.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        this.logger.info((Object)"compareRemoteRevisionWith() invoked...!");
        if (_baseline instanceof IntegrityRevisionState) {
            IntegrityRevisionState baseline = (IntegrityRevisionState)_baseline;
            AbstractBuild lastSuccessfulBuild = (AbstractBuild)project.getLastSuccessfulBuild();
            if (null == lastSuccessfulBuild) {
                this.logger.info((Object)"No prior successful builds found!  Advice to build now!");
                return PollingResult.BUILD_NOW;
            }
            baseline = (IntegrityRevisionState)this.calcRevisionsFromBuild(lastSuccessfulBuild, launcher, listener);
            if (null != baseline && null != baseline.getSIProject()) {
                IntegrityCMProject oldProject = baseline.getSIProject();
                APISession api = this.createAPISession();
                if (null != api) {
                    try {
                        listener.getLogger().println("Preparing to execute si projectinfo for " + this.configPath);
                        this.initializeCMProject(api);
                        listener.getLogger().println("Preparing to execute si viewproject for " + this.configPath);
                        this.initializeCMProjectMembers(api);
                        this.siProject.compareBaseline(oldProject);
                        if (this.siProject.hasProjectChanged()) {
                            listener.getLogger().println("Project contains changes a total of " + this.siProject.getChangeCount() + " changes!");
                            PollingResult pollingResult = PollingResult.SIGNIFICANT;
                            return pollingResult;
                        }
                        listener.getLogger().println("No new changes detected in project!");
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    catch (APIException aex) {
                        this.logger.error((Object)"API Exception caught...");
                        listener.getLogger().println("An API Exception was caught!");
                        ExceptionHandler eh = new ExceptionHandler(aex);
                        this.logger.error((Object)eh.getMessage());
                        listener.getLogger().println(eh.getMessage());
                        this.logger.info((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                        listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                        aex.printStackTrace();
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    finally {
                        api.Terminate();
                    }
                }
                listener.getLogger().println("Failed to establish an API connection to the MKS Integrity Server!");
                return PollingResult.NO_CHANGES;
            }
            this.logger.info((Object)"No prior MKS Integrity Project state can be found!  Advice to build now!");
            return PollingResult.BUILD_NOW;
        }
        this.logger.error((Object)"This method was called with the wrong SCMRevisionState class!");
        return PollingResult.NO_CHANGES;
    }

    public ChangeLogParser createChangeLogParser() {
        this.logger.info((Object)"createChangeLogParser() invoked...!");
        return new IntegrityChangeLogParser(this.integrityURL);
    }

    public SCMDescriptor<IntegritySCM> getDescriptor() {
        this.logger.info((Object)"IntegritySCM.getDescriptor() invoked...!");
        return DescriptorImpl.INTEGRITY_DESCRIPTOR;
    }

    static /* synthetic */ IntegrityRepositoryBrowser access$002(IntegritySCM x0, IntegrityRepositoryBrowser x1) {
        x0.browser = x1;
        return x0.browser;
    }
}

