/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import hudson.scm.APISession;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegritySCM;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCMProject
implements Serializable {
    private static final long serialVersionUID = 6452315129657215760L;
    public static final String NORMAL_PROJECT = "Normal";
    public static final String VARIANT_PROJECT = "Variant";
    public static final String BUILD_PROJECT = "Build";
    private String projectName;
    private String projectType;
    private String projectRevision;
    private String fullConfigSyntax;
    private Date lastCheckpoint;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private boolean skipAuthorInfo = false;
    private List<String> dirList = new ArrayList<String>();
    private List<IntegrityCMMember> memberList = new ArrayList<IntegrityCMMember>();
    private List<IntegrityCMMember> newMemberList = new ArrayList<IntegrityCMMember>();
    private List<IntegrityCMMember> updatedMemberList = new ArrayList<IntegrityCMMember>();
    private List<IntegrityCMMember> deletedMemberList = new ArrayList<IntegrityCMMember>();
    private Document xmlDoc;
    private StringBuffer changeLog = new StringBuffer();
    public static final Comparator<IntegrityCMMember> FILES_ORDER = new Comparator<IntegrityCMMember>(){

        @Override
        public int compare(IntegrityCMMember cmm1, IntegrityCMMember cmm2) {
            return cmm1.getMemberName().compareToIgnoreCase(cmm2.getMemberName());
        }
    };
    private static final Log logger = LogFactory.getLog(IntegrityCMProject.class);

    public IntegrityCMProject(WorkItem wi) {
        this.initializeProject(wi);
    }

    public void initializeProject(WorkItem wi) {
        try {
            Field pjNameFld = wi.getField("projectName");
            Field pjTypeFld = wi.getField("projectType");
            Field pjCfgPathFld = wi.getField("fullConfigSyntax");
            Field pjChkptFld = wi.getField("lastCheckpoint");
            if (null != pjNameFld && null != pjNameFld.getValueAsString()) {
                this.projectName = pjNameFld.getValueAsString();
            } else {
                logger.warn((Object)"Project info did not provide a value for the 'projectName' field!");
                this.projectName = "";
            }
            if (null != pjTypeFld && null != pjTypeFld.getValueAsString()) {
                this.projectType = pjTypeFld.getValueAsString();
                if (this.isBuild()) {
                    Field pjRevFld = wi.getField("revision");
                    if (null != pjRevFld && null != pjRevFld.getItem()) {
                        this.projectRevision = pjRevFld.getItem().getId();
                    } else {
                        this.projectRevision = "";
                        logger.warn((Object)"Project info did not provide a vale for the 'revision' field!");
                    }
                }
            } else {
                logger.warn((Object)"Project info did not provide a value for the 'projectType' field!");
                this.projectType = "";
            }
            if (null != pjCfgPathFld && null != pjCfgPathFld.getValueAsString()) {
                this.fullConfigSyntax = pjCfgPathFld.getValueAsString();
            } else {
                logger.error((Object)"Project info did not provide a value for the 'fullConfigSyntax' field!");
                this.fullConfigSyntax = "";
            }
            if (null != pjChkptFld && null != pjChkptFld.getDateTime()) {
                this.lastCheckpoint = pjChkptFld.getDateTime();
            } else {
                logger.warn((Object)"Project info did not provide a value for the 'lastCheckpoint' field!");
                this.lastCheckpoint = Calendar.getInstance().getTime();
            }
        }
        catch (NoSuchElementException nsee) {
            logger.error((Object)("Project info did not provide a value for field " + nsee.getMessage()));
        }
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    public void setSkipAuthorInfo(boolean skipAuthorInfo) {
        this.skipAuthorInfo = skipAuthorInfo;
    }

    public void parseProject(WorkItemIterator wit, APISession api) throws APIException {
        this.memberList = new ArrayList<IntegrityCMMember>();
        Hashtable<String, String> pjConfigHash = new Hashtable<String, String>();
        pjConfigHash.put(this.projectName, this.fullConfigSyntax);
        String projectRoot = this.projectName.substring(0, this.projectName.lastIndexOf(47));
        while (wit.hasNext()) {
            WorkItem wi = wit.next();
            if (wi.getModelType().equals("si.Subproject")) {
                pjConfigHash.put(wi.getField("name").getValueAsString(), wi.getId());
                String pjDir = wi.getField("name").getValueAsString().substring(projectRoot.length());
                if (this.dirList.contains(pjDir = pjDir.substring(0, pjDir.lastIndexOf(47)))) continue;
                this.dirList.add(pjDir);
                continue;
            }
            if (wi.getModelType().equals("si.Member")) {
                String parentProject = wi.getField("parent").getValueAsString();
                IntegrityCMMember iCMMember = this.skipAuthorInfo ? new IntegrityCMMember(wi, (String)pjConfigHash.get(parentProject), projectRoot, null) : new IntegrityCMMember(wi, (String)pjConfigHash.get(parentProject), projectRoot, api);
                iCMMember.setLineTerminator(this.lineTerminator);
                iCMMember.setRestoreTimestamp(this.restoreTimestamp);
                this.memberList.add(iCMMember);
                continue;
            }
            logger.warn((Object)("View project output contains an invalid model type: " + wi.getModelType()));
        }
        Collections.sort(this.memberList, FILES_ORDER);
        logger.info((Object)("Parsing project " + this.fullConfigSyntax + " complete!"));
    }

    public void compareBaseline(IntegrityCMProject baselineProject) {
        List<IntegrityCMMember> oldMemberList = baselineProject.getProjectMembers();
        Hashtable<String, IntegrityCMMember> oldMemberHash = new Hashtable<String, IntegrityCMMember>();
        for (IntegrityCMMember iMember : oldMemberList) {
            oldMemberHash.put(iMember.getMemberName(), iMember);
        }
        for (IntegrityCMMember iMember : this.memberList) {
            IntegrityCMMember oldMember = (IntegrityCMMember)oldMemberHash.get(iMember.getMemberName());
            if (null != oldMember) {
                if (iMember.getTimestamp().after(oldMember.getTimestamp()) || iMember.getTimestamp().before(oldMember.getTimestamp())) {
                    iMember.setPriorRevision(oldMember.getRevision());
                    this.updatedMemberList.add(iMember);
                }
                oldMemberHash.remove(oldMember.getMemberName());
                continue;
            }
            this.newMemberList.add(iMember);
        }
        Enumeration deletedMembers = oldMemberHash.elements();
        while (deletedMembers.hasMoreElements()) {
            this.deletedMemberList.add((IntegrityCMMember)deletedMembers.nextElement());
        }
    }

    public String getChangeLog(String version, APISession api) throws APIException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xmlDoc = docBuilder.newDocument();
            this.changeLog = new StringBuffer();
            Element changeLogElem = this.xmlDoc.createElement("changelog");
            this.xmlDoc.appendChild(changeLogElem);
            if (this.hasProjectChanged()) {
                Element item;
                Element items = this.xmlDoc.createElement("items");
                items.setAttribute("version", version);
                changeLogElem.appendChild(items);
                Iterator<IntegrityCMMember> it = this.newMemberList.iterator();
                while (it.hasNext()) {
                    item = this.xmlDoc.createElement("item");
                    item.setAttribute("action", "add");
                    items.appendChild(this.writeChangeLog(item, it.next(), api));
                }
                it = this.updatedMemberList.iterator();
                while (it.hasNext()) {
                    item = this.xmlDoc.createElement("item");
                    item.setAttribute("action", "update");
                    items.appendChild(this.writeChangeLog(item, it.next(), api));
                }
                it = this.deletedMemberList.iterator();
                while (it.hasNext()) {
                    item = this.xmlDoc.createElement("item");
                    item.setAttribute("action", "delete");
                    items.appendChild(this.writeChangeLog(item, it.next(), api));
                }
            }
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter sw = new StringWriter();
            serializer.transform(new DOMSource(this.xmlDoc), new StreamResult(sw));
            this.changeLog.append(sw.toString());
            sw.close();
        }
        catch (ParserConfigurationException pce) {
            logger.warn((Object)"Caught Parser Configuration Exception while generating Change Log!");
            logger.warn((Object)pce.getMessage());
        }
        catch (TransformerException tfe) {
            logger.warn((Object)"Caught Transformer Exception while generating Change Log!");
            logger.warn((Object)tfe.getMessage());
        }
        catch (IOException ioe) {
            logger.warn((Object)"Caught IO Exception while generating Change Log!");
            logger.warn((Object)ioe.getMessage());
        }
        return this.changeLog.toString();
    }

    private Element writeChangeLog(Element item, IntegrityCMMember iMember, APISession api) throws APIException {
        Element file = this.xmlDoc.createElement("file");
        file.appendChild(this.xmlDoc.createTextNode(iMember.getMemberName()));
        item.appendChild(file);
        Element user = this.xmlDoc.createElement("user");
        user.appendChild(this.xmlDoc.createTextNode(iMember.getAuthor()));
        item.appendChild(user);
        Element revision = this.xmlDoc.createElement("revision");
        revision.appendChild(this.xmlDoc.createTextNode(iMember.getRevision()));
        item.appendChild(revision);
        Element date = this.xmlDoc.createElement("date");
        date.appendChild(this.xmlDoc.createTextNode(IntegritySCM.SDF.format(iMember.getTimestamp())));
        item.appendChild(date);
        try {
            Element annotation = this.xmlDoc.createElement("annotation");
            annotation.appendChild(this.xmlDoc.createCDATASection(iMember.getAnnotatedLink()));
            item.appendChild(annotation);
            Element differences = this.xmlDoc.createElement("differences");
            differences.appendChild(this.xmlDoc.createCDATASection(iMember.getDifferencesLink()));
            item.appendChild(differences);
        }
        catch (UnsupportedEncodingException uee) {
            logger.warn((Object)"Caught Unsupported Encoding Exception while generating MKS Integrity Source links!");
            logger.warn((Object)uee.getMessage());
        }
        Element msg = this.xmlDoc.createElement("msg");
        msg.appendChild(this.xmlDoc.createTextNode(iMember.getDescription()));
        item.appendChild(msg);
        return item;
    }

    public Response checkpoint(APISession api, String chkptLabel) throws APIException {
        Command siCheckpoint = new Command("si", "checkpoint");
        siCheckpoint.addOption(new Option("project", this.fullConfigSyntax));
        if (null != chkptLabel && chkptLabel.length() > 0) {
            siCheckpoint.addOption(new Option("label", chkptLabel));
            siCheckpoint.addOption(new Option("description", chkptLabel));
        }
        return api.runCommand(siCheckpoint);
    }

    public Response addProjectLabel(APISession api, String chkptLabel) throws APIException {
        Command siAddProjectLabel = new Command("si", "addprojectlabel");
        siAddProjectLabel.addOption(new Option("project", this.fullConfigSyntax));
        siAddProjectLabel.addOption(new Option("label", chkptLabel));
        siAddProjectLabel.addOption(new Option("moveLabel"));
        return api.runCommand(siAddProjectLabel);
    }

    public boolean hasProjectChanged() {
        return this.getChangeCount() > 0;
    }

    public int getChangeCount() {
        return this.newMemberList.size() + this.updatedMemberList.size() + this.deletedMemberList.size();
    }

    public List<String> getDirList() {
        return this.dirList;
    }

    public List<IntegrityCMMember> getProjectMembers() {
        return this.memberList;
    }

    public List<IntegrityCMMember> getAddedMembers() {
        return this.newMemberList;
    }

    public List<IntegrityCMMember> getUpdatedMembers() {
        return this.updatedMemberList;
    }

    public List<IntegrityCMMember> getDroppedMembers() {
        return this.deletedMemberList;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectRevision() {
        return this.projectRevision;
    }

    public boolean isNormal() {
        return this.projectType.equalsIgnoreCase(NORMAL_PROJECT);
    }

    public boolean isVariant() {
        return this.projectType.equalsIgnoreCase(VARIANT_PROJECT);
    }

    public boolean isBuild() {
        return this.projectType.equalsIgnoreCase(BUILD_PROJECT);
    }

    public String getConfigurationPath() {
        return this.fullConfigSyntax;
    }

    public Date getLastCheckpointDate() {
        return this.lastCheckpoint;
    }
}

