/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.CmdRunner;
import com.mks.api.Command;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class APISession {
    public static final String VERSION = IntegrationPointFactory.getAPIVersion().substring(0, IntegrationPointFactory.getAPIVersion().indexOf(32));
    public static final int MAJOR_VERSION = Integer.parseInt(VERSION.substring(0, VERSION.indexOf(46)));
    public static final int MINOR_VERSION = Integer.parseInt(VERSION.substring(VERSION.indexOf(46) + 1, VERSION.length()));
    private final Log logger = LogFactory.getLog(this.getClass());
    private String ipHostName;
    private int ipPort = 0;
    private String hostName;
    private int port;
    private String userName;
    private String password;
    private IntegrationPoint ip;
    private Session session;
    private boolean terminated = false;

    public APISession(String ipHost, int ipPortNum, String host, int portNum, String user, String paswd, boolean secure) throws APIException {
        this.ip = null != ipHost && ipHost.length() > 0 && ipPortNum > 0 ? IntegrationPointFactory.getInstance().createIntegrationPoint(ipHost, ipPortNum, secure, MAJOR_VERSION, MINOR_VERSION) : IntegrationPointFactory.getInstance().createIntegrationPoint(host, portNum, secure, MAJOR_VERSION, MINOR_VERSION);
        this.session = this.ip.createSession(user, paswd);
        Command ping = new Command("api", "ping");
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(host);
        cmdRunner.setDefaultPort(portNum);
        cmdRunner.setDefaultUsername(user);
        cmdRunner.setDefaultPassword(paswd);
        Response res = cmdRunner.execute(ping);
        this.logger.debug((Object)(res.getCommandString() + " returned exit code " + res.getExitCode()));
        this.ipHostName = ipHost;
        this.ipPort = ipPortNum;
        this.hostName = host;
        this.port = portNum;
        this.userName = user;
        this.password = paswd;
        cmdRunner.release();
        this.logger.debug((Object)("Successfully established connection " + this.userName + "@" + this.hostName + ":" + this.port));
    }

    public Response runCommand(Command cmd) throws APIException {
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        Response res = cmdRunner.execute(cmd);
        this.logger.debug((Object)(res.getCommandString() + " returned exit code " + res.getExitCode()));
        cmdRunner.release();
        return res;
    }

    public Response runCommandAs(Command cmd, String impersonateUser) throws APIException {
        CmdRunner cmdRunner = this.session.createCmdRunner();
        cmdRunner.setDefaultHostname(this.hostName);
        cmdRunner.setDefaultPort(this.port);
        cmdRunner.setDefaultUsername(this.userName);
        cmdRunner.setDefaultPassword(this.password);
        cmdRunner.setDefaultImpersonationUser(impersonateUser);
        Response res = cmdRunner.execute(cmd);
        this.logger.debug((Object)(res.getCommandString() + " returned exit code " + res.getExitCode()));
        cmdRunner.release();
        return res;
    }

    public void Terminate() {
        if (!this.terminated) {
            try {
                if (null != this.session) {
                    this.session.release();
                }
                if (null != this.ip) {
                    this.ip.release();
                }
                this.terminated = true;
                this.logger.debug((Object)("Successfully disconnected connection " + this.userName + "@" + this.hostName + ":" + this.port));
            }
            catch (APIException aex) {
                this.logger.debug((Object)"Caught API Exception when releasing session!");
                aex.printStackTrace();
            }
            catch (IOException ioe) {
                this.logger.debug((Object)"Caught IO Exception when releasing session!");
                ioe.printStackTrace();
            }
        }
    }

    public String getIPHostName() {
        return this.ipHostName;
    }

    public String getIPPort() {
        return String.valueOf(this.ipPort);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPort() {
        return String.valueOf(this.port);
    }

    public String getUserName() {
        return this.userName;
    }
}

