/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.IntegritySCM;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityChangeLogSet
extends ChangeLogSet<IntegrityChangeLog> {
    private List<IntegrityChangeLog> logs;
    private final String url;
    private String version;
    private String date;
    private String author;
    private String msg;

    public IntegrityChangeLogSet(AbstractBuild<?, ?> build, List<IntegrityChangeLog> logs, String integrityURL) {
        super(build);
        this.logs = Collections.unmodifiableList(logs);
        this.url = integrityURL;
        this.version = String.valueOf(build.getNumber());
        this.author = "user";
        this.date = IntegritySCM.SDF.format(new Date());
        this.msg = "MKS Integrity Change Log";
        for (IntegrityChangeLog log : logs) {
            log.setParent(this);
        }
    }

    public List<IntegrityChangeLog> getLogs() {
        return this.logs;
    }

    public String getKind() {
        return "integrity";
    }

    public String getIntegrityURL() {
        return this.url;
    }

    public Iterator<IntegrityChangeLog> iterator() {
        return this.logs.iterator();
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public void addEntry(Collection<String> affectedPaths, String user, String msg) {
        this.logs.add(this.addNewEntry(affectedPaths, user, msg));
    }

    public IntegrityChangeLog addNewEntry(Collection<String> affectedPaths, String user, String msg) {
        IntegrityChangeLog log = new IntegrityChangeLog(this, affectedPaths, user, msg);
        this.logs.add(log);
        return log;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean(defaultVisibility=999)
    public static class IntegrityChangeLog
    extends ChangeLogSet.Entry {
        private Collection<String> affectedPaths;
        private String action;
        private String file;
        private String author;
        private String rev;
        private String date;
        private String annotation;
        private String differences;
        private String msg;

        public IntegrityChangeLog() {
        }

        public IntegrityChangeLog(ChangeLogSet<IntegrityChangeLog> parent, Collection<String> affectedPaths, String author, String msg) {
            this.setParent(parent);
            this.affectedPaths = affectedPaths;
            this.author = author;
            this.msg = msg;
        }

        public IntegrityChangeLogSet getParent() {
            return (IntegrityChangeLogSet)super.getParent();
        }

        protected void setParent(ChangeLogSet changeLogSet) {
            super.setParent(changeLogSet);
        }

        public Collection<String> getAffectedPaths() {
            return this.affectedPaths;
        }

        @Exported
        public User getAuthor() {
            if (this.author == null) {
                return User.getUnknown();
            }
            return User.get((String)this.author);
        }

        @Exported
        public String getUser() {
            return this.author;
        }

        public void setUser(String user) {
            this.author = user;
        }

        @Exported
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Exported
        public String getRev() {
            return this.rev;
        }

        public void setRev(String rev) {
            this.rev = rev;
        }

        @Exported
        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        @Exported
        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        @Exported
        public EditType getEditType() {
            if (this.action.equalsIgnoreCase("delete")) {
                return EditType.DELETE;
            }
            if (this.action.equalsIgnoreCase("add")) {
                return EditType.ADD;
            }
            return EditType.EDIT;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public String getDifferences() {
            return this.differences;
        }

        public void setDifferences(String differences) {
            this.differences = differences;
        }
    }
}

