/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegritySCM;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckoutTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 1240357991626897900L;
    private static final int CHECKOUT_TRESHOLD = 500;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final IntegritySCM scm;
    private final IntegrityCMProject siProject;
    private final boolean cleanCopy;
    private final BuildListener listener;

    public IntegrityCheckoutTask(IntegritySCM scm, IntegrityCMProject siProject, boolean cleanCopy, BuildListener listener) {
        this.scm = scm;
        this.siProject = siProject;
        this.cleanCopy = cleanCopy;
        this.listener = listener;
        this.logger.debug((Object)"Integrity Checkout Task Created!");
    }

    private void createFolderStructure(FilePath workspace) {
        Iterator<String> folders = this.siProject.getDirList().iterator();
        while (folders.hasNext()) {
            File dir = new File(workspace + folders.next());
            if (dir.isDirectory()) continue;
            this.logger.debug((Object)("Creating folder: " + dir.getAbsolutePath()));
            dir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean invoke(File workspaceFile, VirtualChannel channel) throws IOException {
        block14: {
            File checkOutDir = null != this.scm.getAlternateWorkspace() && this.scm.getAlternateWorkspace().length() > 0 ? new File(this.scm.getAlternateWorkspace()) : workspaceFile;
            FilePath workspace = new FilePath(checkOutDir.isAbsolute() ? checkOutDir : new File(workspaceFile.getAbsolutePath() + IntegritySCM.FS + checkOutDir.getPath()));
            this.listener.getLogger().println("Checkout directory is " + workspace);
            APISession api = this.scm.createAPISession();
            if (null == api) {
                this.listener.getLogger().println("Failed to establish an API connection to the MKS Integrity Server!");
                return false;
            }
            try {
                int openFileHandles = 0;
                if (this.cleanCopy) {
                    this.listener.getLogger().println("A clean copy is requested; deleting contents of " + workspace);
                    this.logger.debug((Object)("Deleting contents of workspace " + workspace));
                    workspace.deleteContents();
                    this.listener.getLogger().println("Populating clean workspace...");
                    this.createFolderStructure(workspace);
                    List<IntegrityCMMember> projectMembers = this.siProject.getProjectMembers();
                    Iterator<IntegrityCMMember> it = projectMembers.iterator();
                    while (it.hasNext()) {
                        ++openFileHandles;
                        IntegrityCMMember siMember = it.next();
                        siMember.setWorkspaceDir("" + workspace);
                        this.logger.debug((Object)("Attempting to checkout file: " + siMember.getTargetFilePath() + " at revision " + siMember.getRevision()));
                        siMember.checkout(api);
                        if (openFileHandles % 500 != 0) continue;
                        api.Terminate();
                        api = this.scm.createAPISession();
                    }
                    this.listener.getLogger().println("Successfully checked out " + projectMembers.size() + " files!");
                    break block14;
                }
                this.createFolderStructure(workspace);
                List<IntegrityCMMember> newMembersList = this.siProject.getAddedMembers();
                Iterator<IntegrityCMMember> it = newMembersList.iterator();
                while (it.hasNext()) {
                    ++openFileHandles;
                    IntegrityCMMember siMember = it.next();
                    siMember.setWorkspaceDir("" + workspace);
                    this.logger.debug((Object)("Attempting to get new file: " + siMember.getTargetFilePath() + " at revision " + siMember.getRevision()));
                    siMember.checkout(api);
                    if (openFileHandles % 500 != 0) continue;
                    api.Terminate();
                    api = this.scm.createAPISession();
                }
                List<IntegrityCMMember> updatedMembersList = this.siProject.getUpdatedMembers();
                Iterator<IntegrityCMMember> it2 = updatedMembersList.iterator();
                while (it2.hasNext()) {
                    ++openFileHandles;
                    IntegrityCMMember siMember = it2.next();
                    siMember.setWorkspaceDir("" + workspace);
                    this.logger.debug((Object)("Attempting to update file: " + siMember.getTargetFilePath() + " to revision " + siMember.getRevision()));
                    siMember.checkout(api);
                    if (openFileHandles % 500 != 0) continue;
                    api.Terminate();
                    api = this.scm.createAPISession();
                }
                List<IntegrityCMMember> memberDropList = this.siProject.getDroppedMembers();
                for (IntegrityCMMember siMember : memberDropList) {
                    siMember.setWorkspaceDir("" + workspace);
                    this.logger.debug((Object)("Attempting to drop file: " + siMember.getTargetFilePath() + " was at revision " + siMember.getRevision()));
                    File dropFile = new File(siMember.getTargetFilePath());
                    if (!dropFile.exists() || dropFile.delete()) continue;
                    this.listener.getLogger().println("Failed to clean up workspace file " + dropFile.getAbsolutePath() + "!");
                    Boolean bl = false;
                    return bl;
                }
                this.listener.getLogger().println("Successfully updated workspace with " + (newMembersList.size() + updatedMembersList.size()) + " updates and cleaned up " + memberDropList.size() + " files!");
            }
            catch (APIException aex) {
                this.logger.error((Object)"API Exception caught...");
                this.listener.getLogger().println("An API Exception was caught!");
                ExceptionHandler eh = new ExceptionHandler(aex);
                this.logger.error((Object)eh.getMessage());
                this.listener.getLogger().println(eh.getMessage());
                this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                this.listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                aex.printStackTrace();
                Boolean bl = false;
                return bl;
            }
            catch (InterruptedException iex) {
                this.logger.error((Object)"Interrupted Exception caught...");
                this.listener.getLogger().println("An Interrupted Exception was caught!");
                this.logger.error((Object)iex.getMessage());
                this.listener.getLogger().println(iex.getMessage());
                this.listener.getLogger().println("Failed to clean up workspace (" + workspace + ") contents!");
                Boolean bl = false;
                return bl;
            }
            finally {
                api.Terminate();
            }
        }
        return true;
    }
}

