/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegritySCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckpointAction
extends Notifier {
    private String tagName;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Extension
    public static final IntegrityCheckpointDescriptorImpl CHECKPOINT_DESCRIPTOR = new IntegrityCheckpointDescriptorImpl();

    public String getTagName() {
        if (this.tagName == null || this.tagName.length() == 0) {
            return CHECKPOINT_DESCRIPTOR.getDefaultTagName();
        }
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    private AbstractProject<?, ?> getRootProject(AbstractProject<?, ?> abstractProject) {
        if (abstractProject.getParent() instanceof Hudson) {
            return abstractProject;
        }
        return this.getRootProject((AbstractProject)abstractProject.getParent());
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!Result.SUCCESS.equals(build.getResult())) {
            listener.getLogger().println("Build failed!  Skipping MKS Integrity Checkpoint step!");
            return true;
        }
        AbstractProject<?, ?> rootProject = this.getRootProject(build.getProject());
        if (!(rootProject.getScm() instanceof IntegritySCM)) {
            listener.getLogger().println("Integrity Checkpoint is being executed for an invalid context!  Current SCM is " + rootProject.getScm() + "!");
            return true;
        }
        IntegritySCM scm = (IntegritySCM)IntegritySCM.class.cast(rootProject.getScm());
        APISession api = scm.createAPISession();
        if (null != api) {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            String chkptLabel = CHECKPOINT_DESCRIPTOR.evalGroovyExpression((Map<String, String>)env, this.tagName);
            try {
                try {
                    IntegrityCMProject siProject = scm.getIntegrityProject();
                    if (!siProject.isBuild()) {
                        listener.getLogger().println("Preparing to execute si checkpoint for " + siProject.getConfigurationPath());
                        Response res = siProject.checkpoint(api, chkptLabel);
                        this.logger.debug((Object)(res.getCommandString() + " returned " + res.getExitCode()));
                        WorkItem wi = res.getWorkItem(siProject.getConfigurationPath());
                        String chkpt = wi.getResult().getField("resultant").getItem().getId();
                        listener.getLogger().println("Successfully checkpointed project " + scm.getConfigPath() + " with label '" + chkptLabel + "', new revision is " + chkpt);
                    }
                    if (scm.getCheckpointBeforeBuild()) {
                        listener.getLogger().println("Preparing to execute si addprojectlabel for " + siProject.getConfigurationPath());
                        Response res = siProject.addProjectLabel(api, chkptLabel);
                        this.logger.debug((Object)(res.getCommandString() + " returned " + res.getExitCode()));
                        listener.getLogger().println("Successfully added label '" + chkptLabel + "' to revision " + siProject.getProjectRevision());
                    }
                    listener.getLogger().println("Cannot checkpoint a build project configuration: " + scm.getConfigPath() + "!");
                }
                catch (APIException aex) {
                    this.logger.error((Object)"API Exception caught...");
                    ExceptionHandler eh = new ExceptionHandler(aex);
                    this.logger.error((Object)eh.getMessage());
                    this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                    throw new Exception(eh.getMessage());
                }
                finally {
                    api.Terminate();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
                this.logger.error((Object)("Exception caught!  " + e));
                return false;
            }
        } else {
            this.logger.error((Object)"An API Session could not be established!  Cannot perform checkpoint operation against MKS Integrity Server");
            listener.getLogger().println("An API Session could not be established!  Cannot perform checkpoint operation against MKS Integrity Server");
            return false;
        }
        return true;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return CHECKPOINT_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegrityCheckpointDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static Log desLogger = LogFactory.getLog(IntegrityCheckpointDescriptorImpl.class);
        private String defaultTagName = "${env['JOB_NAME']}-${env['BUILD_NUMBER']}-${new java.text.SimpleDateFormat(\"yyyy_MM_dd\").format(new Date())}";

        public IntegrityCheckpointDescriptorImpl() {
            super(IntegrityCheckpointAction.class);
            this.load();
            desLogger.debug((Object)"IntegrityCheckpointAction.IntegrityCheckpointDescriptorImpl() constructed!");
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            IntegrityCheckpointAction chkptAction = new IntegrityCheckpointAction();
            chkptAction.setTagName(formData.getString("tagName"));
            desLogger.debug((Object)"IntegrityCheckpointAction.IntegrityCheckpointDescriptorImpl.newInstance() executed!");
            return chkptAction;
        }

        public String getDisplayName() {
            return "MKS Integrity - CM Checkpoint";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.defaultTagName = req.getParameter("tagName");
            this.save();
            desLogger.debug((Object)"IntegrityCheckpointAction.IntegrityCheckpointDescriptorImpl.configure() executed!");
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            desLogger.debug((Object)"IntegrityCheckpointAction.IntegrityCheckpointDescriptorImpl.isApplicable executed!");
            return true;
        }

        public String getDefaultTagName() {
            return this.defaultTagName;
        }

        public void setDefaultTagName(String defaultTagName) {
            this.defaultTagName = defaultTagName;
        }

        public FormValidation doTagNameCheck(@QueryParameter(value="value") String tagName) throws IOException, ServletException {
            String errorMessage;
            if (tagName == null || tagName.length() == 0) {
                return FormValidation.error((String)"Please specify a label for this Checkpoint!");
            }
            String s = null;
            try {
                s = this.evalGroovyExpression(new HashMap<String, String>(), tagName);
            }
            catch (CompilationFailedException e) {
                return FormValidation.error((String)("Check if quotes, braces, or brackets are balanced. " + e.getMessage()));
            }
            if (null != s && null != (errorMessage = this.isInvalidTag(s))) {
                return FormValidation.error((String)errorMessage);
            }
            return FormValidation.ok();
        }

        private String isInvalidTag(String tagName) {
            if (tagName == null || tagName.length() == 0) {
                return "The label string is empty!";
            }
            char ch = tagName.charAt(0);
            if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z')) {
                return "The label must start with an alpha character!";
            }
            for (char invalid : "$,.:;/\\@".toCharArray()) {
                if (tagName.indexOf(invalid) < 0) continue;
                return "The label may cannot contain one of the following characters: $ , . : ; / \\ @";
            }
            return null;
        }

        public String evalGroovyExpression(Map<String, String> env, String expression) {
            Binding binding = new Binding();
            binding.setVariable("env", env);
            binding.setVariable("sys", (Object)System.getProperties());
            CompilerConfiguration config = new CompilerConfiguration();
            GroovyShell shell = new GroovyShell(binding, config);
            Object result = shell.evaluate("return \"" + expression + "\"");
            if (result == null) {
                return "";
            }
            return result.toString().trim();
        }
    }
}

