/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogSet;
import hudson.scm.IntegrityChangeLogSet;
import hudson.scm.IntegritySCM;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityChangeLogSet
extends ChangeLogSet<IntegrityChangeLog> {
    private List<IntegrityChangeLog> logs;
    private final String url;
    private String version;
    private String date;
    private String author;
    private String msg;

    public IntegrityChangeLogSet(AbstractBuild<?, ?> build, List<IntegrityChangeLog> logs, String integrityURL) {
        super(build);
        this.logs = Collections.unmodifiableList(logs);
        this.url = integrityURL;
        this.version = String.valueOf(build.getNumber());
        this.author = "user";
        this.date = IntegritySCM.SDF.format(new Date());
        this.msg = "Integrity Change Log";
        for (IntegrityChangeLog log : logs) {
            log.setParent((ChangeLogSet)this);
        }
    }

    public List<IntegrityChangeLog> getLogs() {
        return this.logs;
    }

    public String getKind() {
        return "integrity";
    }

    public String getIntegrityURL() {
        return this.url;
    }

    public Iterator<IntegrityChangeLog> iterator() {
        return this.logs.iterator();
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public void addEntry(Collection<String> affectedPaths, String user, String msg) {
        this.logs.add(this.addNewEntry(affectedPaths, user, msg));
    }

    public IntegrityChangeLog addNewEntry(Collection<String> affectedPaths, String user, String msg) {
        IntegrityChangeLog log = new IntegrityChangeLog((ChangeLogSet)this, affectedPaths, user, msg);
        this.logs.add(log);
        return log;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

