/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.MultiValue;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.util.Base64;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.ChangeLogParser;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegrityChangeLogParser;
import hudson.scm.IntegrityCheckoutTask;
import hudson.scm.IntegrityRepositoryBrowser;
import hudson.scm.IntegrityRevisionState;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegritySCM
extends SCM
implements Serializable {
    private static final long serialVersionUID = 7559894846609712683L;
    public static final String NL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final int MIN_PORT_VALUE = 1;
    public static final int MAX_PORT_VALUE = 65535;
    public static final SimpleDateFormat SDF = new SimpleDateFormat("MMM dd, yyyy h:mm:ss a");
    private final Log logger = LogFactory.getLog(this.getClass());
    private String ciServerURL;
    private String integrityURL;
    private IntegrityRepositoryBrowser browser;
    private String ipHostName;
    private String hostName;
    private int ipPort = 0;
    private int port;
    private boolean secure;
    private String configPath;
    private String userName;
    private String password;
    private boolean cleanCopy;
    private boolean skipAuthorInfo = false;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private boolean checkpointBeforeBuild = false;
    private String alternateWorkspace;
    private transient IntegrityCMProject siProject;

    @DataBoundConstructor
    public IntegritySCM(IntegrityRepositoryBrowser browser, String hostName, int port, boolean secure, String configPath, String userName, String password, String ipHostName, int ipPort, boolean cleanCopy, String lineTerminator, boolean restoreTimestamp, boolean skipAuthorInfo, boolean checkpointBeforeBuild, String alternateWorkspace) {
        this.logger.debug((Object)"IntegritySCM constructor has been invoked!");
        this.ciServerURL = Hudson.getInstance().getRootUrlFromRequest();
        this.browser = browser;
        this.ipHostName = ipHostName;
        this.hostName = hostName;
        this.ipPort = ipPort;
        this.port = port;
        this.secure = secure;
        this.configPath = configPath;
        this.userName = userName;
        this.password = Base64.encode((String)password);
        this.cleanCopy = cleanCopy;
        this.lineTerminator = lineTerminator;
        this.restoreTimestamp = restoreTimestamp;
        this.skipAuthorInfo = skipAuthorInfo;
        this.checkpointBeforeBuild = checkpointBeforeBuild;
        this.alternateWorkspace = alternateWorkspace;
        this.initIntegrityURL();
        this.logger.debug((Object)("CI Server URL: " + this.ciServerURL));
        this.logger.debug((Object)("URL: " + this.integrityURL));
        this.logger.debug((Object)("IP Host: " + this.ipHostName));
        this.logger.debug((Object)("Host: " + this.hostName));
        this.logger.debug((Object)("IP Port: " + this.ipPort));
        this.logger.debug((Object)("Port: " + this.port));
        this.logger.debug((Object)("User: " + this.userName));
        this.logger.debug((Object)("Password: " + this.password));
        this.logger.debug((Object)("Secure: " + this.secure));
        this.logger.debug((Object)("Project: " + this.configPath));
        this.logger.debug((Object)("Line Terminator: " + this.lineTerminator));
        this.logger.debug((Object)("Restore Timestamp: " + this.restoreTimestamp));
        this.logger.debug((Object)("Clean: " + this.cleanCopy));
        this.logger.debug((Object)("Skip Author Info: " + this.skipAuthorInfo));
        this.logger.debug((Object)("Checkpoint Before Build: " + this.checkpointBeforeBuild));
        this.logger.debug((Object)("Alternate Workspace Directory: " + this.alternateWorkspace));
    }

    @Exported
    public IntegrityRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getipHostName() {
        return this.ipHostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getipPort() {
        return this.ipPort;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return Base64.decode((String)this.password);
    }

    public boolean getCleanCopy() {
        return this.cleanCopy;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public boolean getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public boolean getSkipAuthorInfo() {
        return this.skipAuthorInfo;
    }

    public boolean getCheckpointBeforeBuild() {
        return this.checkpointBeforeBuild;
    }

    public String getAlternateWorkspace() {
        return this.alternateWorkspace;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.initIntegrityURL();
    }

    public void setipHostName(String ipHostName) {
        this.ipHostName = ipHostName;
    }

    public void setPort(int port) {
        this.port = port;
        this.initIntegrityURL();
    }

    public void setipPort(int ipPort) {
        this.ipPort = ipPort;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.initIntegrityURL();
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = Base64.encode((String)password);
    }

    public void setCleanCopy(boolean cleanCopy) {
        this.cleanCopy = cleanCopy;
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    public void setSkipAuthorInfo(boolean skipAuthorInfo) {
        this.skipAuthorInfo = skipAuthorInfo;
    }

    public void setCheckpointBeforeBuild(boolean checkpointBeforeBuild) {
        this.checkpointBeforeBuild = checkpointBeforeBuild;
    }

    public void setAlternateWorkspace(String alternateWorkspace) {
        this.alternateWorkspace = alternateWorkspace;
    }

    private void initIntegrityURL() {
        this.integrityURL = this.secure ? "https://" + this.hostName + ":" + String.valueOf(this.port) : "http://" + this.hostName + ":" + String.valueOf(this.port);
    }

    public APISession createAPISession() {
        try {
            this.logger.debug((Object)"Creating Integrity API Session...");
            return new APISession(this.ipHostName, this.ipPort, this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
        }
        catch (APIException aex) {
            this.logger.error((Object)"API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            this.logger.error((Object)eh.getMessage());
            this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
            aex.printStackTrace();
            return null;
        }
    }

    public IntegrityCMProject getIntegrityProject() {
        return this.siProject;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        this.logger.debug((Object)"buildEnvVars() invoked...!");
        env.put("MKSSI_PROJECT", this.configPath);
        env.put("MKSSI_HOST", this.hostName);
        env.put("MKSSI_PORT", String.valueOf(this.port));
        env.put("MKSSI_USER", this.userName);
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.logger.debug((Object)"calcRevisionsFromBuild() invoked...!");
        Object obj = this.getIntegrityCMProjectState(build);
        if (obj instanceof IntegrityCMProject && null != obj) {
            IntegrityCMProject cmProject = (IntegrityCMProject)obj;
            return new IntegrityRevisionState(cmProject);
        }
        this.logger.debug((Object)("Cannot construct project state for build " + build.getNumber() + "!"));
        return new IntegrityRevisionState(null);
    }

    private Response initializeCMProject(APISession api) throws APIException {
        Command siProjectInfoCmd = new Command("si", "projectinfo");
        siProjectInfoCmd.addOption(new Option("project", this.configPath));
        this.logger.debug((Object)("Preparing to execute si projectinfo for " + this.configPath));
        Response infoRes = api.runCommand(siProjectInfoCmd);
        this.logger.debug((Object)(infoRes.getCommandString() + " returned " + infoRes.getExitCode()));
        this.siProject = new IntegrityCMProject(infoRes.getWorkItems().next());
        this.siProject.setLineTerminator(this.lineTerminator);
        this.siProject.setRestoreTimestamp(this.restoreTimestamp);
        this.siProject.setSkipAuthorInfo(this.skipAuthorInfo);
        return infoRes;
    }

    private Response initializeCMProjectMembers(APISession api) throws APIException {
        Command siViewProjectCmd = new Command("si", "viewproject");
        siViewProjectCmd.addOption(new Option("recurse"));
        siViewProjectCmd.addOption(new Option("project", this.siProject.getConfigurationPath()));
        MultiValue mvFields = new MultiValue(",");
        mvFields.add("name");
        mvFields.add("context");
        mvFields.add("cpid");
        mvFields.add("memberrev");
        mvFields.add("membertimestamp");
        mvFields.add("memberdescription");
        siViewProjectCmd.addOption(new Option("fields", mvFields));
        this.logger.debug((Object)("Preparing to execute si viewproject for " + this.siProject.getConfigurationPath()));
        Response viewRes = api.runCommand(siViewProjectCmd);
        this.logger.debug((Object)(viewRes.getCommandString() + " returned " + viewRes.getExitCode()));
        this.siProject.parseProject(viewRes.getWorkItems(), api);
        return viewRes;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIntegrityCMProjectState(AbstractBuild<?, ?> build) throws IOException {
        if (null != build) {
            File viewProjectFile = IntegritySCM.getViewProjectResponseFile(build);
            if (!viewProjectFile.exists()) {
                this.logger.debug((Object)("Project state not found for build " + build.getNumber() + "!"));
                return null;
            }
            this.logger.debug((Object)("Attempting to load up project state for build " + build.getNumber() + "..."));
            FileInputStream fis = new FileInputStream(viewProjectFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object obj = null;
            try {
                obj = ois.readObject();
                this.logger.debug((Object)("Project state re-constructed successfully for build " + build.getNumber() + "!"));
            }
            catch (ClassNotFoundException cne) {
                this.logger.debug((Object)("Caught Exception: " + cne.getMessage()));
                this.logger.debug((Object)("Cannot construct project state for build" + build.getNumber() + "!"));
            }
            finally {
                ois.close();
                fis.close();
            }
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        block15: {
            this.logger.debug((Object)"Start execution of checkout() routine...!");
            listener.getLogger().println("Change Log: " + this.ciServerURL + build.getUrl() + "changes");
            listener.getLogger().println("Build Log: " + this.ciServerURL + build.getUrl() + "console");
            APISession api = this.createAPISession();
            if (null == api) {
                listener.getLogger().println("Failed to establish an API connection to the Integrity Server!");
                return false;
            }
            PrintWriter writer = new PrintWriter(new FileWriter(changeLogFile));
            try {
                Object obj;
                listener.getLogger().println("Preparing to execute si projectinfo for " + this.configPath);
                this.initializeCMProject(api);
                if (this.checkpointBeforeBuild) {
                    if (!this.siProject.isBuild()) {
                        listener.getLogger().println("Preparing to execute pre-build si checkpoint for " + this.siProject.getConfigurationPath());
                        Response res = this.siProject.checkpoint(api, "");
                        this.logger.debug((Object)(res.getCommandString() + " returned " + res.getExitCode()));
                        WorkItem wi = res.getWorkItem(this.siProject.getConfigurationPath());
                        String chkpt = wi.getResult().getField("resultant").getItem().getId();
                        listener.getLogger().println("Successfully executed pre-build checkpoint for project " + this.siProject.getConfigurationPath() + ", new revision is " + chkpt);
                        Command siProjectInfoCmd = new Command("si", "projectinfo");
                        siProjectInfoCmd.addOption(new Option("project", this.siProject.getProjectName()));
                        siProjectInfoCmd.addOption(new Option("projectRevision", chkpt));
                        Response infoRes = api.runCommand(siProjectInfoCmd);
                        this.siProject.initializeProject(infoRes.getWorkItems().next());
                    } else {
                        listener.getLogger().println("Cannot perform a pre-build checkpoint for build project configuration!");
                    }
                }
                listener.getLogger().println("Preparing to execute si viewproject for " + this.siProject.getConfigurationPath());
                this.initializeCMProjectMembers(api);
                AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
                for (AbstractBuild b = (AbstractBuild)build.getPreviousBuild(); null != b; b = (AbstractBuild)b.getPreviousBuild()) {
                    if (!IntegritySCM.getViewProjectResponseFile(b).exists()) continue;
                    this.logger.debug((Object)("Found previous project state in build " + b.getNumber()));
                    previousBuild = b;
                    break;
                }
                if ((obj = this.getIntegrityCMProjectState(previousBuild)) instanceof IntegrityCMProject && null != obj) {
                    IntegrityCMProject oldProject = (IntegrityCMProject)obj;
                    this.siProject.compareBaseline(oldProject, api);
                } else {
                    this.logger.debug((Object)"Cannot construct project state for any of the pevious builds!");
                    if (!this.skipAuthorInfo) {
                        List<IntegrityCMMember> memberList = this.siProject.getProjectMembers();
                        Iterator<IntegrityCMMember> it = memberList.iterator();
                        while (it.hasNext()) {
                            it.next().setAuthor(api);
                        }
                    }
                }
                IntegrityCheckoutTask coTask = null;
                coTask = null == obj ? new IntegrityCheckoutTask(this, this.siProject, true, listener) : new IntegrityCheckoutTask(this, this.siProject, this.cleanCopy, listener);
                if (((Boolean)workspace.act((FilePath.FileCallable)coTask)).booleanValue()) {
                    listener.getLogger().println("Saving current Integrity Project configuration...");
                    this.printViewProjectResponse(build, listener, this.siProject);
                    listener.getLogger().println("Writing build change log...");
                    writer.println(this.siProject.getChangeLog(String.valueOf(build.getNumber()), api));
                    listener.getLogger().println("Change log successfully generated: " + changeLogFile.getAbsolutePath());
                    break block15;
                }
                boolean bl = false;
                return bl;
            }
            catch (APIException aex) {
                this.logger.error((Object)"API Exception caught...");
                listener.getLogger().println("An API Exception was caught!");
                ExceptionHandler eh = new ExceptionHandler(aex);
                this.logger.error((Object)eh.getMessage());
                listener.getLogger().println(eh.getMessage());
                this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                aex.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                writer.close();
                api.Terminate();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printViewProjectResponse(AbstractBuild<?, ?> build, BuildListener listener, IntegrityCMProject pj) throws IOException {
        File viewProjectFile = new File(build.getRootDir(), "viewproject.dat");
        FileOutputStream fos = new FileOutputStream(viewProjectFile);
        ObjectOutputStream pjOut = new ObjectOutputStream(fos);
        try {
            pjOut.writeObject(pj);
            listener.getLogger().println("API Response for si viewproject successfully saved to file!");
        }
        finally {
            pjOut.close();
            fos.close();
        }
        listener.getLogger().println("Successfully saved current Integrity Project configuration to " + viewProjectFile.getAbsolutePath());
    }

    public static File getViewProjectResponseFile(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "viewproject.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        this.logger.debug((Object)"compareRemoteRevisionWith() invoked...!");
        if (_baseline instanceof IntegrityRevisionState) {
            IntegrityRevisionState baseline = (IntegrityRevisionState)_baseline;
            AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
            if (null == lastBuild) {
                this.logger.debug((Object)"No prior successful builds found!  Advice to build now!");
                return PollingResult.BUILD_NOW;
            }
            baseline = (IntegrityRevisionState)this.calcRevisionsFromBuild(lastBuild, launcher, listener);
            if (null != baseline && null != baseline.getSIProject()) {
                IntegrityCMProject oldProject = baseline.getSIProject();
                APISession api = this.createAPISession();
                if (null != api) {
                    try {
                        listener.getLogger().println("Preparing to execute si projectinfo for " + this.configPath);
                        this.initializeCMProject(api);
                        listener.getLogger().println("Preparing to execute si viewproject for " + this.configPath);
                        this.initializeCMProjectMembers(api);
                        this.siProject.compareBaseline(oldProject, api);
                        if (this.siProject.hasProjectChanged()) {
                            listener.getLogger().println("Project contains changes a total of " + this.siProject.getChangeCount() + " changes!");
                            PollingResult pollingResult = PollingResult.SIGNIFICANT;
                            return pollingResult;
                        }
                        listener.getLogger().println("No new changes detected in project!");
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    catch (APIException aex) {
                        this.logger.error((Object)"API Exception caught...");
                        listener.getLogger().println("An API Exception was caught!");
                        ExceptionHandler eh = new ExceptionHandler(aex);
                        this.logger.error((Object)eh.getMessage());
                        listener.getLogger().println(eh.getMessage());
                        this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                        listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                        aex.printStackTrace();
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    finally {
                        api.Terminate();
                    }
                }
                listener.getLogger().println("Failed to establish an API connection to the Integrity Server!");
                return PollingResult.NO_CHANGES;
            }
            this.logger.debug((Object)"No prior Integrity Project state can be found!  Advice to build now!");
            return PollingResult.BUILD_NOW;
        }
        this.logger.error((Object)"This method was called with the wrong SCMRevisionState class!");
        return PollingResult.NO_CHANGES;
    }

    public ChangeLogParser createChangeLogParser() {
        this.logger.debug((Object)"createChangeLogParser() invoked...!");
        return new IntegrityChangeLogParser(this.integrityURL);
    }

    public SCMDescriptor<IntegritySCM> getDescriptor() {
        this.logger.debug((Object)"IntegritySCM.getDescriptor() invoked...!");
        return DescriptorImpl.INTEGRITY_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<IntegritySCM> {
        private static Log desLogger = LogFactory.getLog(DescriptorImpl.class);
        @Extension
        public static final DescriptorImpl INTEGRITY_DESCRIPTOR = new DescriptorImpl();
        private String defaultHostName = Util.getHostName();
        private String defaultIPHostName = "";
        private int defaultPort = 7001;
        private int defaultIPPort = 0;
        private boolean defaultSecure = false;
        private String defaultUserName = "";
        private String defaultPassword = "";

        protected DescriptorImpl() {
            super(IntegritySCM.class, IntegrityRepositoryBrowser.class);
            this.load();
            desLogger.debug((Object)"IntegritySCM DescriptorImpl() constructed!");
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            IntegritySCM scm = (IntegritySCM)super.newInstance(req, formData);
            scm.browser = (IntegrityRepositoryBrowser)RepositoryBrowsers.createInstance(IntegrityRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser");
            return scm;
        }

        public String getDisplayName() {
            return "Integrity - CM";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            desLogger.debug((Object)"Request to configure IntegritySCM (SCMDescriptor) invoked...");
            desLogger.debug((Object)("mks.defaultHostName = " + req.getParameter("mks.defaultHostName")));
            this.defaultHostName = Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultHostName"));
            desLogger.debug((Object)("defaultHostName = " + this.defaultHostName));
            desLogger.debug((Object)("mks.defaultIPHostName = " + req.getParameter("mks.defaultIPHostName")));
            this.defaultIPHostName = Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultIPHostName"));
            desLogger.debug((Object)("defaultIPHostName = " + this.defaultIPHostName));
            desLogger.debug((Object)("mks.defaultPort = " + req.getParameter("mks.defaultPort")));
            this.defaultPort = Integer.parseInt(Util.fixNull((String)req.getParameter("mks.defaultPort")));
            desLogger.debug((Object)("defaultPort = " + this.defaultPort));
            desLogger.debug((Object)("mks.defaultIPPort = " + req.getParameter("mks.defaultIPPort")));
            this.defaultIPPort = Integer.parseInt(Util.fixNull((String)req.getParameter("mks.defaultIPPort")));
            desLogger.debug((Object)("defaultIPPort = " + this.defaultIPPort));
            desLogger.debug((Object)("mks.defaultSecure = " + req.getParameter("mks.defaultSecure")));
            this.defaultSecure = "on".equalsIgnoreCase(Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultSecure")));
            desLogger.debug((Object)("defaultSecure = " + this.defaultSecure));
            desLogger.debug((Object)("mks.defaultUserName = " + req.getParameter("mks.defaultUserName")));
            this.defaultUserName = Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultUserName"));
            desLogger.debug((Object)("defaultUserName = " + this.defaultUserName));
            this.defaultPassword = Base64.encode((String)Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultPassword")));
            desLogger.debug((Object)("defaultPassword = " + this.defaultPassword));
            this.save();
            return true;
        }

        public String getDefaultHostName() {
            return this.defaultHostName;
        }

        public String getDefaultIPHostName() {
            return this.defaultIPHostName;
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        public int getDefaultIPPort() {
            return this.defaultIPPort;
        }

        public boolean getDefaultSecure() {
            return this.defaultSecure;
        }

        public String getDefaultUserName() {
            return this.defaultUserName;
        }

        public String getDefaultPassword() {
            return Base64.decode((String)this.defaultPassword);
        }

        public void setDefaultHostName(String defaultHostName) {
            this.defaultHostName = defaultHostName;
        }

        public void setDefaultIPHostName(String defaultIPHostName) {
            this.defaultIPHostName = defaultIPHostName;
        }

        public void setDefaultPort(int defaultPort) {
            this.defaultPort = defaultPort;
        }

        public void setDefaultIPPort(int defaultIPPort) {
            this.defaultIPPort = defaultIPPort;
        }

        public void setDefaultSecure(boolean defaultSecure) {
            this.defaultSecure = defaultSecure;
        }

        public void setDefaultUserName(String defaultUserName) {
            this.defaultUserName = defaultUserName;
        }

        public void setDefaultPassword(String defaultPassword) {
            this.defaultPassword = Base64.encode((String)defaultPassword);
        }

        public FormValidation doValidPortCheck(@QueryParameter String value) {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue + 1 < 1 || intValue > 65535) {
                    return FormValidation.error((String)"Value must be between 1 and 65535!");
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)"Value must be numeric!");
            }
            return FormValidation.ok();
        }
    }
}

