/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.iphoneview;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPhoneJob<P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> {
    private final P project;
    private final List<B> changedBuilds;

    public IPhoneJob(P project) {
        this.project = project;
        this.changedBuilds = this.changedBuildsAll();
    }

    public List<B> getChangedBuilds(int size) {
        ArrayList<B> builds = new ArrayList<B>();
        int buildsSize = this.changedBuilds.size();
        for (int i = 0; i < Math.min(buildsSize, size); ++i) {
            builds.add(this.changedBuilds.get(i));
        }
        return Collections.unmodifiableList(builds);
    }

    public List<B> getChangedBuildsAll() {
        return this.changedBuilds;
    }

    private List<B> changedBuildsAll() {
        ArrayList<AbstractBuild> builds = new ArrayList<AbstractBuild>();
        for (AbstractBuild build : this.project.getBuilds()) {
            Iterator it = build.getChangeSet().iterator();
            if (!it.hasNext()) continue;
            builds.add(build);
        }
        return Collections.unmodifiableList(builds);
    }

    public P getJob() {
        return this.project;
    }
}

