/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.pircbot;

import java.io.File;
import java.net.Socket;
import org.jibble.pircbot.DccManager;
import org.jibble.pircbot.PircBot;

public class DccFileTransfer {
    public static final int BUFFER_SIZE = 1024;
    private PircBot _bot;
    private DccManager _manager;
    private String _nick;
    private String _login = null;
    private String _hostname = null;
    private String _type;
    private long _address;
    private int _port;
    private long _size;
    private boolean _received;
    private Socket _socket = null;
    private long _progress = 0L;
    private File _file = null;
    private int _timeout = 0;
    private boolean _incoming;
    private long _packetDelay = 0L;
    private long _startTime = 0L;

    DccFileTransfer(PircBot bot, DccManager manager, String nick, String login, String hostname, String type, String filename, long address, int port, long size) {
        this._bot = bot;
        this._manager = manager;
        this._nick = nick;
        this._login = login;
        this._hostname = hostname;
        this._type = type;
        this._file = new File(filename);
        this._address = address;
        this._port = port;
        this._size = size;
        this._received = false;
    }

    DccFileTransfer(PircBot bot, DccManager manager, File file, String nick, int timeout) {
        this._bot = bot;
        this._manager = manager;
        this._nick = nick;
        this._file = file;
        this._size = file.length();
        this._timeout = timeout;
        this._received = true;
    }

    public synchronized void receive(File file, boolean resume) {
        if (!this._received) {
            this._received = true;
            this._file = file;
            if (this._type.equals("SEND") && resume) {
                this._progress = file.length();
                if (this._progress == 0L) {
                    this.doReceive(file, false);
                } else {
                    this._bot.sendCTCPCommand(this._nick, "DCC RESUME file.ext " + this._port + " " + this._progress);
                    this._manager.addAwaitingResume(this);
                }
            } else {
                this._progress = file.length();
                this.doReceive(file, resume);
            }
        }
    }

    void doReceive(File file, boolean resume) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    void doSend(boolean allowResume) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    void setProgress(long progress) {
        this._progress = progress;
    }

    private void delay() {
        if (this._packetDelay > 0L) {
            try {
                Thread.sleep(this._packetDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getNick() {
        return this._nick;
    }

    public String getLogin() {
        return this._login;
    }

    public String getHostname() {
        return this._hostname;
    }

    public File getFile() {
        return this._file;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isIncoming() {
        return this._incoming;
    }

    public boolean isOutgoing() {
        return !this.isIncoming();
    }

    public void setPacketDelay(long millis) {
        this._packetDelay = millis;
    }

    public long getPacketDelay() {
        return this._packetDelay;
    }

    public long getSize() {
        return this._size;
    }

    public long getProgress() {
        return this._progress;
    }

    public double getProgressPercentage() {
        return 100.0 * ((double)this.getProgress() / (double)this.getSize());
    }

    public void close() {
        try {
            this._socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getTransferRate() {
        long time = (System.currentTimeMillis() - this._startTime) / 1000L;
        if (time <= 0L) {
            return 0L;
        }
        return this.getProgress() / time;
    }

    static /* synthetic */ long access$000(DccFileTransfer x0) {
        return x0._address;
    }

    static /* synthetic */ PircBot access$100(DccFileTransfer x0) {
        return x0._bot;
    }

    static /* synthetic */ Socket access$202(DccFileTransfer x0, Socket x1) {
        x0._socket = x1;
        return x0._socket;
    }

    static /* synthetic */ int access$300(DccFileTransfer x0) {
        return x0._port;
    }

    static /* synthetic */ Socket access$200(DccFileTransfer x0) {
        return x0._socket;
    }

    static /* synthetic */ long access$402(DccFileTransfer x0, long x1) {
        x0._startTime = x1;
        return x0._startTime;
    }

    static /* synthetic */ DccManager access$500(DccFileTransfer x0) {
        return x0._manager;
    }

    static /* synthetic */ long access$614(DccFileTransfer x0, long x1) {
        return x0._progress += x1;
    }

    static /* synthetic */ long access$600(DccFileTransfer x0) {
        return x0._progress;
    }

    static /* synthetic */ void access$700(DccFileTransfer x0) {
        x0.delay();
    }

    static /* synthetic */ int access$800(DccFileTransfer x0) {
        return x0._timeout;
    }

    static /* synthetic */ int access$302(DccFileTransfer x0, int x1) {
        x0._port = x1;
        return x0._port;
    }

    static /* synthetic */ File access$900(DccFileTransfer x0) {
        return x0._file;
    }

    static /* synthetic */ String access$1000(DccFileTransfer x0) {
        return x0._nick;
    }
}

