/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot;

import hudson.model.Build;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.ircbot.IrcPublisher;
import hudson.plugins.ircbot.IrcUserProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcPublisher
extends IMPublisher<IrcPublisher> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    public List<String> channels = new ArrayList();

    protected void reportFailure(Build build) {
        String status = "failed";
        String suspects = this.calculateSuspectsString(build.getChangeSet());
        IrcPublisher.DESCRIPTOR.bot.sendNotice(this.channelList(), ((Project)build.getProject()).getName() + " build " + status + " (" + Hudson.getInstance().getRootUrl() + build.getUrl() + ")" + (suspects == null ? "" : suspects));
    }

    protected void reportSuccess(Build build) {
        String status = "fixed";
        IrcPublisher.DESCRIPTOR.bot.sendNotice(this.channelList(), ((Project)build.getProject()).getName() + " build " + status + " (" + Hudson.getInstance().getRootUrl() + build.getUrl() + ")");
    }

    protected void reportUnstability(Build build) {
        String status = "unstable";
        String suspects = this.calculateSuspectsString(build.getChangeSet());
        IrcPublisher.DESCRIPTOR.bot.sendNotice(this.channelList(), ((Project)build.getProject()).getName() + " build " + status + " (" + Hudson.getInstance().getRootUrl() + build.getUrl() + ")" + (suspects == null ? "" : suspects));
    }

    private String calculateSuspectsString(ChangeLogSet<? extends ChangeLogSet.Entry> cs) {
        if (cs != null && !cs.isEmptySet()) {
            StringBuilder sb = new StringBuilder(" last commit(s): ");
            Iterator it = cs.iterator();
            while (it.hasNext()) {
                IrcUserProperty iup = (IrcUserProperty)((ChangeLogSet.Entry)it.next()).getAuthor().getProperties().get(IrcUserProperty.DESCRIPTOR);
                sb.append(iup.getNick());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    private List<String> channelList() {
        return this.channels == null || this.channels.isEmpty() ? IrcPublisher.DESCRIPTOR.channels : this.channels;
    }

    public String getChannels() {
        StringBuilder sb = new StringBuilder();
        if (this.channels != null) {
            for (String c : this.channels) {
                sb.append(c).append(" ");
            }
        }
        return sb.toString().trim();
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

