/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.Publisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IMPublisher<T extends IMPublisher<T>>
extends Publisher {
    public final boolean perform(Build build, Launcher launcher, BuildListener listener) {
        if (build.getPreviousBuild() != null) {
            if (!build.getResult().toString().equals(build.getPreviousBuild().getResult().toString())) {
                this.publish(build);
            }
        } else if (build.getResult() != Result.SUCCESS) {
            this.publish(build);
        }
        return true;
    }

    private final void publish(Build build) {
        if (build.getResult() == Result.SUCCESS) {
            this.reportSuccess(build);
        } else if (build.getResult() == Result.FAILURE) {
            this.reportFailure(build);
        } else if (build.getResult() == Result.UNSTABLE) {
            this.reportUnstability(build);
        }
    }

    protected abstract void reportSuccess(Build var1);

    protected abstract void reportFailure(Build var1);

    protected abstract void reportUnstability(Build var1);
}

