/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot;

import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.ircbot.IrcUserProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jibble.pircbot.IrcException;
import org.jibble.pircbot.NickAlreadyInUseException;
import org.jibble.pircbot.PircBot;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcPublisher
extends IMPublisher<IrcPublisher> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    public List<String> channels = new ArrayList<String>();

    @Override
    protected void reportFailure(Build build) {
        String status = "failed";
        String suspects = this.calculateSuspectsString((ChangeLogSet<? extends ChangeLogSet.Entry>)build.getChangeSet());
        IrcPublisher.DESCRIPTOR.bot.sendNotice(this.channelList(), build.getProject().getName() + " build " + status + " (" + Hudson.getInstance().getRootUrl() + build.getUrl() + ")" + (suspects == null ? "" : suspects));
    }

    @Override
    protected void reportSuccess(Build build) {
        String status = "fixed";
        IrcPublisher.DESCRIPTOR.bot.sendNotice(this.channelList(), build.getProject().getName() + " build " + status + " (" + Hudson.getInstance().getRootUrl() + build.getUrl() + ")");
    }

    @Override
    protected void reportUnstability(Build build) {
        String status = "unstable";
        String suspects = this.calculateSuspectsString((ChangeLogSet<? extends ChangeLogSet.Entry>)build.getChangeSet());
        IrcPublisher.DESCRIPTOR.bot.sendNotice(this.channelList(), build.getProject().getName() + " build " + status + " (" + Hudson.getInstance().getRootUrl() + build.getUrl() + ")" + (suspects == null ? "" : suspects));
    }

    private String calculateSuspectsString(ChangeLogSet<? extends ChangeLogSet.Entry> cs) {
        if (cs != null && !cs.isEmptySet()) {
            StringBuilder sb = new StringBuilder(" last commit(s): ");
            Iterator it = cs.iterator();
            while (it.hasNext()) {
                IrcUserProperty iup = (IrcUserProperty)((Object)((ChangeLogSet.Entry)it.next()).getAuthor().getProperties().get((Object)IrcUserProperty.DESCRIPTOR));
                sb.append(iup.getNick());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    private List<String> channelList() {
        return this.channels == null || this.channels.isEmpty() ? IrcPublisher.DESCRIPTOR.channels : this.channels;
    }

    public String getChannels() {
        StringBuilder sb = new StringBuilder();
        if (this.channels != null) {
            for (String c : this.channels) {
                sb.append(c).append(" ");
            }
        }
        return sb.toString().trim();
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        boolean enabled = false;
        String hostname = null;
        Integer port = 194;
        String password = null;
        String nick = null;
        List<String> channels;
        String commandPrefix = null;
        volatile transient IrcBot bot;

        DescriptorImpl() {
            super(IrcPublisher.class);
            this.load();
            try {
                this.initBot();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "IRC bot could not connect - please review connection details", e);
            }
        }

        public void initBot() throws NickAlreadyInUseException, IOException, IrcException {
            if (this.enabled) {
                this.bot = new IrcBot(this.nick);
                this.bot.connect(this.hostname, this.port, this.password);
                for (String channel : this.channels) {
                    this.bot.joinChannel(channel);
                }
                LOGGER.info("IRC bot connected and channels joined");
            }
        }

        public void stop() {
            if (this.bot != null && this.bot.isConnected()) {
                this.bot.quitServer("mama grounded me!");
                this.bot.dispose();
                this.bot = null;
                LOGGER.info("IRC bot stopped");
            }
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            boolean bl = this.enabled = "on".equals(req.getParameter("irc_publisher.enabled")) || "true".equals(req.getParameter("irc_publisher.enabled"));
            if (this.enabled) {
                this.hostname = req.getParameter("irc_publisher.hostname");
                this.password = req.getParameter("irc_publisher.password");
                this.nick = req.getParameter("irc_publisher.nick");
                try {
                    this.port = Integer.valueOf(req.getParameter("irc_publisher.port"));
                    if (this.port == null) {
                        this.port = 194;
                    }
                }
                catch (NumberFormatException e) {
                    throw new Descriptor.FormException("port field must be an Integer", "irc_publisher.port");
                }
                this.commandPrefix = req.getParameter("irc_publisher.commandPrefix");
                this.commandPrefix = this.commandPrefix == null || "".equals(this.commandPrefix.trim()) ? null : this.commandPrefix.trim() + " ";
                this.channels = Arrays.asList(req.getParameter("irc_publisher.channels").split(" "));
            }
            this.save();
            this.stop();
            try {
                this.initBot();
            }
            catch (NickAlreadyInUseException e) {
                throw new Descriptor.FormException("Nick <" + this.nick + "> already in use on this server", "irc_publisher.nick");
            }
            catch (IOException e) {
                throw new Descriptor.FormException("Impossible to connect to IRC server", (Throwable)e, null);
            }
            catch (IrcException e) {
                throw new Descriptor.FormException("Impossible to connect to IRC server", (Throwable)e, null);
            }
            return super.configure(req);
        }

        public String getDisplayName() {
            return "IRC Notification";
        }

        public String getChannels() {
            StringBuilder sb = new StringBuilder();
            if (this.channels != null) {
                for (String c : this.channels) {
                    sb.append(c).append(" ");
                }
            }
            return sb.toString().trim();
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            IrcPublisher result = new IrcPublisher();
            String channelParam = req.getParameter("channels");
            if (channelParam != null) {
                for (String c : Arrays.asList(channelParam.split(" "))) {
                    if (c.trim().length() <= 0) continue;
                    result.channels.add(c.trim());
                }
            }
            result.channels.removeAll(this.channels);
            LOGGER.info("project specific channel config: " + result.channels);
            return result;
        }

        public String getCommandPrefix() {
            return this.commandPrefix;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getNick() {
            return this.nick;
        }

        public String getPassword() {
            return this.password;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IrcBot
        extends PircBot {
            IrcBot(String name) {
                this.setName(name);
                this.setMessageDelay(5L);
            }

            protected void sendNotice(List<String> channels, String message) {
                for (String channel : channels) {
                    LOGGER.info("sending notice to channel " + channel);
                    this.sendNotice(channel, message);
                }
            }

            @Override
            protected void onMessage(String channel, String sender, String login, String hostname, String message) {
                if (DescriptorImpl.this.commandPrefix != null && message.startsWith(DescriptorImpl.this.commandPrefix)) {
                    String command = message.substring(DescriptorImpl.this.commandPrefix.length()).trim();
                    if ("status".equals(command)) {
                        List jobs = Hudson.getInstance().getAllItems(AbstractProject.class);
                        if (jobs.isEmpty()) {
                            this.sendNotice(sender, "No jobs configured");
                        } else {
                            for (AbstractProject job : jobs) {
                                if (job.isDisabled()) continue;
                                if (job.getLastBuild() != null) {
                                    this.sendNotice(sender, job.getName() + ": " + job.getLastBuild().getResult().toString() + " (" + Hudson.getInstance().getRootUrl() + job.getLastBuild().getUrl() + ")" + (job.isInQueue() ? ": BUILDING" : ""));
                                    continue;
                                }
                                this.sendNotice(sender, job.getName() + ": no build");
                            }
                        }
                    } else if (command.startsWith("build")) {
                        Project project;
                        String jobName = command.substring(5).trim();
                        if (jobName.length() == 0) {
                            this.sendNotice(sender, "You must specify a project name");
                        } else if (jobName.length() > 0 && (project = (Project)Hudson.getInstance().getItemByFullName(jobName, Project.class)) != null) {
                            if (project.isInQueue()) {
                                this.sendNotice(sender, jobName + " is already in build queue");
                            } else if (project.isDisabled()) {
                                this.sendNotice(sender, jobName + " is disabled");
                            } else {
                                project.scheduleBuild();
                                this.sendNotice(sender, jobName + " build scheduled");
                            }
                        }
                    }
                }
            }

            @Override
            protected void onPrivateMessage(String sender, String login, String hostname, String message) {
                if (DescriptorImpl.this.commandPrefix == null) {
                    this.sendNotice(sender, "the property <commandPrefix> must be set on the Hudson configuration screen");
                } else {
                    this.onMessage(null, sender, login, hostname, message);
                }
            }
        }
    }
}

