/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot;

import hudson.model.User;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.ircbot.IrcPublisher;
import hudson.plugins.ircbot.IrcUserProperty;
import hudson.plugins.ircbot.v2.IRCConnectionProvider;
import hudson.plugins.ircbot.v2.IRCMessageTargetConverter;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcPublisher
extends IMPublisher {
    private static final Logger LOGGER = Logger.getLogger(IrcPublisher.class.getName());
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final IMMessageTargetConverter CONVERTER = new IRCMessageTargetConverter();
    public List<String> channels = new ArrayList();

    public IrcPublisher(String targetsAsString, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters) throws IMMessageTargetConversionException {
        super(targetsAsString, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected String getConfiguredIMId(User user) {
        IrcUserProperty ircUserProperty = (IrcUserProperty)user.getProperties().get(IrcUserProperty.DESCRIPTOR);
        if (ircUserProperty != null) {
            return ircUserProperty.getNick();
        }
        return null;
    }

    protected IMConnection getIMConnection() throws IMException {
        return IRCConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "IRC notifier plugin";
    }

    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    protected List<IMMessageTarget> getNotificationTargets() {
        List perJobTargets = super.getNotificationTargets();
        if (perJobTargets == null || perJobTargets.isEmpty()) {
            List descChannels = IrcPublisher.DESCRIPTOR.channels;
            ArrayList<IMMessageTarget> result = new ArrayList<IMMessageTarget>(descChannels.size());
            for (String s : descChannels) {
                try {
                    IMMessageTarget target = this.getIMMessageTargetConverter().fromString(s);
                    if (target == null) continue;
                    result.add(target);
                }
                catch (IMMessageTargetConversionException e) {}
            }
            return result;
        }
        return perJobTargets;
    }

    private Object readResolve() {
        if (this.getNotificationTargets() == null) {
            if (this.channels != null) {
                StringBuilder targets = new StringBuilder();
                for (String channel : this.channels) {
                    targets.append(channel).append(" ");
                }
                try {
                    this.setTargets(targets.toString().trim());
                }
                catch (IMMessageTargetConversionException e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                try {
                    this.setTargets("");
                }
                catch (IMMessageTargetConversionException e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            }
        }
        if (this.getNotificationStrategy() == null) {
            this.setNotificationStrategy(NotificationStrategy.STATECHANGE_ONLY);
        }
        return this;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

