/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.ircbot.v2.PircConnection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.jibble.pircbot.PircBot;

/*
 * Exception performing whole class analysis ignored.
 */
public class PircConnection
extends PircBot {
    private static final Logger LOGGER = Logger.getLogger(PircConnection.class.getName());
    private final List<IMConnectionListener> listeners = new CopyOnWriteArrayList();
    private final List<MessageListener> msgListeners = new CopyOnWriteArrayList();
    private final List<JoinListener> joinListeners = new CopyOnWriteArrayList();
    private final boolean useNotice;
    private volatile boolean explicitDisconnect = false;

    public PircConnection(String name, boolean useNotice) {
        this.useNotice = useNotice;
        this.setName(name);
    }

    public void sendIMMessage(String target, String message) {
        String[] lines;
        for (String line : lines = message.split("\\r?\\n|\\r")) {
            if (this.useNotice) {
                this.sendNotice(target, line);
                continue;
            }
            this.sendMessage(target, line);
        }
    }

    protected void onMessage(String channel, String sender, String login, String hostname, String message) {
        for (MessageListener l : this.msgListeners) {
            if (!MessageListener.access$000((MessageListener)l).equals(channel)) continue;
            MessageListener.access$100((MessageListener)l).onMessage(new IMMessage(sender, channel, message));
        }
    }

    protected void onPrivateMessage(String sender, String login, String hostname, String message) {
        for (MessageListener l : this.msgListeners) {
            if (!this.getName().equals(MessageListener.access$000((MessageListener)l))) continue;
            MessageListener.access$100((MessageListener)l).onMessage(new IMMessage(sender, this.getNick(), message));
        }
    }

    protected void onJoin(String channel, String sender, String login, String hostname) {
        for (JoinListener l : this.joinListeners) {
            if (!this.getName().equals(sender)) continue;
            l.channelJoined(channel);
        }
    }

    protected void onServerResponse(int code, String response) {
        if (code >= 400 && code <= 599) {
            LOGGER.warning("IRC server responded error " + code + " Message:\n" + response);
        }
    }

    public final void closeConnection() {
        this.explicitDisconnect = true;
        super.disconnect();
    }

    protected void onDisconnect() {
        if (!this.explicitDisconnect) {
            for (IMConnectionListener l : this.listeners) {
                l.connectionBroken(null);
            }
        }
        this.explicitDisconnect = false;
        super.onDisconnect();
    }

    public void addConnectionListener(IMConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(IMConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void addMessageListener(String target, IMMessageListener listener) {
        this.msgListeners.add(new MessageListener(target, listener));
    }

    public void removeMessageListener(String target, IMMessageListener listener) {
        this.msgListeners.remove(new MessageListener(target, listener));
    }

    public void addJoinListener(JoinListener listener) {
        this.joinListeners.add(listener);
    }

    public void removeJoinListener(JoinListener listener) {
        this.joinListeners.remove(listener);
    }
}

