/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.ircbot.IrcUserProperty;
import hudson.plugins.ircbot.v2.IRCConnectionProvider;
import hudson.plugins.ircbot.v2.IRCMessageTargetConverter;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcPublisher
extends IMPublisher {
    private static final Logger LOGGER = Logger.getLogger(IrcPublisher.class.getName());
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final IMMessageTargetConverter CONVERTER = new IRCMessageTargetConverter();
    public List<String> channels = new ArrayList<String>();

    public IrcPublisher(String targetsAsString, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters) throws IMMessageTargetConversionException {
        super(targetsAsString, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected String getConfiguredIMId(User user) {
        IrcUserProperty ircUserProperty = (IrcUserProperty)((Object)user.getProperties().get((Object)IrcUserProperty.DESCRIPTOR));
        if (ircUserProperty != null) {
            return ircUserProperty.getNick();
        }
        return null;
    }

    protected IMConnection getIMConnection() throws IMException {
        return IRCConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "IRC notifier plugin";
    }

    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    protected List<IMMessageTarget> getNotificationTargets() {
        List perJobTargets = super.getNotificationTargets();
        if (perJobTargets == null || perJobTargets.isEmpty()) {
            List<String> descChannels = IrcPublisher.DESCRIPTOR.channels;
            ArrayList<IMMessageTarget> result = new ArrayList<IMMessageTarget>(descChannels.size());
            for (String s : descChannels) {
                try {
                    IMMessageTarget target = this.getIMMessageTargetConverter().fromString(s);
                    if (target == null) continue;
                    result.add(target);
                }
                catch (IMMessageTargetConversionException e) {}
            }
            return result;
        }
        return perJobTargets;
    }

    private Object readResolve() {
        if (this.getNotificationTargets() == null) {
            if (this.channels != null) {
                StringBuilder targets = new StringBuilder();
                for (String channel : this.channels) {
                    targets.append(channel).append(" ");
                }
                try {
                    this.setTargets(targets.toString().trim());
                }
                catch (IMMessageTargetConversionException e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                try {
                    this.setTargets("");
                }
                catch (IMMessageTargetConversionException e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            }
        }
        if (this.getNotificationStrategy() == null) {
            this.setNotificationStrategy(NotificationStrategy.STATECHANGE_ONLY);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements IMPublisherDescriptor {
        private static final String PREFIX = "irc_publisher.";
        public static final String PARAMETERNAME_TARGETS = "irc_publisher.targets";
        public static final String PARAMETERNAME_STRATEGY = "irc_publisher.strategy";
        public static final String PARAMETERNAME_NOTIFY_START = "irc_publisher.notifyStart";
        public static final String PARAMETERNAME_NOTIFY_SUSPECTS = "irc_publisher.notifySuspects";
        public static final String PARAMETERNAME_NOTIFY_CULPRITS = "irc_publisher.notifyCulprits";
        public static final String PARAMETERNAME_NOTIFY_FIXERS = "irc_publisher.notifyFixers";
        public static final String PARAMETERNAME_NOTIFY_UPSTREAM_COMMITTERS = "irc_publisher.notifyUpstreamCommitters";
        public static final String PARAMETERVALUE_STRATEGY_DEFAULT = NotificationStrategy.STATECHANGE_ONLY.getDisplayName();
        public static final String[] PARAMETERVALUE_STRATEGY_VALUES = NotificationStrategy.getDisplayNames();
        public static final String PARAMETERNAME_HUDSON_LOGIN = "irc_publisher.hudsonLogin";
        public static final String PARAMETERNAME_HUDSON_PASSWORD = "irc_publisher.hudsonPassword";
        public static final String PARAMETERNAME_USE_NOTICE = "irc_publisher.useNotice";
        boolean enabled = false;
        String hostname = null;
        Integer port = 194;
        String password = null;
        String nick = null;
        List<String> channels;
        String commandPrefix = null;
        private String hudsonLogin;
        private String hudsonPassword;
        private boolean useNotice;

        DescriptorImpl() {
            super(IrcPublisher.class);
            this.load();
            if (this.isEnabled()) {
                try {
                    IRCConnectionProvider.setDesc(this);
                }
                catch (Exception e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                try {
                    IRCConnectionProvider.setDesc(null);
                }
                catch (IMException iMException) {
                    // empty catch block
                }
            }
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            boolean bl = this.enabled = "on".equals(req.getParameter("irc_publisher.enabled")) || "true".equals(req.getParameter("irc_publisher.enabled"));
            if (this.enabled) {
                this.hostname = req.getParameter("irc_publisher.hostname");
                this.password = req.getParameter("irc_publisher.password");
                this.nick = req.getParameter("irc_publisher.nick");
                try {
                    this.port = Integer.valueOf(req.getParameter("irc_publisher.port"));
                }
                catch (NumberFormatException e) {
                    throw new Descriptor.FormException("port field must be an Integer", "irc_publisher.port");
                }
                this.commandPrefix = req.getParameter("irc_publisher.commandPrefix");
                this.commandPrefix = Util.fixEmptyAndTrim((String)this.commandPrefix);
                this.channels = Arrays.asList(req.getParameter("irc_publisher.channels").split(" "));
                this.hudsonLogin = req.getParameter(PARAMETERNAME_HUDSON_LOGIN);
                this.hudsonPassword = req.getParameter(PARAMETERNAME_HUDSON_PASSWORD);
                this.useNotice = "on".equals(req.getParameter(PARAMETERNAME_USE_NOTICE));
                try {
                    IRCConnectionProvider.setDesc(this);
                    IRCConnectionProvider.getInstance().currentConnection();
                }
                catch (Exception e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                IRCConnectionProvider.getInstance().releaseConnection();
                try {
                    IRCConnectionProvider.setDesc(null);
                }
                catch (IMException iMException) {
                    // empty catch block
                }
            }
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return "IRC Notification";
        }

        public String getHelpFile() {
            return "/plugin/ircbot/help.html";
        }

        public String getChannels() {
            StringBuilder sb = new StringBuilder();
            if (this.channels != null) {
                for (String c : this.channels) {
                    sb.append(c).append(" ");
                }
            }
            return sb.toString().trim();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String t = req.getParameter(PARAMETERNAME_TARGETS);
            String n = req.getParameter(PARAMETERNAME_STRATEGY);
            if (n == null) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            } else {
                boolean foundStrategyValueMatch = false;
                for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                    if (!strategyValue.equals(n)) continue;
                    foundStrategyValueMatch = true;
                    break;
                }
                if (!foundStrategyValueMatch) {
                    n = PARAMETERVALUE_STRATEGY_DEFAULT;
                }
            }
            boolean notifyStart = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_START));
            boolean notifySuspects = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_SUSPECTS));
            boolean notifyCulprits = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_CULPRITS));
            boolean notifyFixers = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_FIXERS));
            boolean notifyUpstream = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_UPSTREAM_COMMITTERS));
            try {
                return new IrcPublisher(t, n, notifyStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstream);
            }
            catch (IMMessageTargetConversionException e) {
                throw new Descriptor.FormException((Throwable)e, PARAMETERNAME_TARGETS);
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getCommandPrefix() {
            return this.commandPrefix;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getNick() {
            return this.nick;
        }

        public String getPassword() {
            return this.password;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDefaultIdSuffix() {
            return null;
        }

        public String getHost() {
            return this.hostname;
        }

        public String getHudsonUserName() {
            return this.hudsonLogin;
        }

        public String getHudsonPassword() {
            return this.hudsonPassword;
        }

        public String getPluginDescription() {
            return "IRC notifier plugin";
        }

        public String getUserName() {
            return this.nick;
        }

        public boolean isExposePresence() {
            return true;
        }

        public boolean isUseNotice() {
            return this.useNotice;
        }
    }
}

