/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import hudson.Util;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMPresence;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.ircbot.IrcPublisher;
import hudson.plugins.ircbot.v2.IRCChannel;
import hudson.plugins.ircbot.v2.IRCConnection;
import hudson.plugins.ircbot.v2.PircConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.jibble.pircbot.IrcException;
import org.jibble.pircbot.NickAlreadyInUseException;

public class IRCConnection
implements IMConnection,
PircConnection.JoinListener {
    private static final Logger LOGGER = Logger.getLogger(IRCConnection.class.getName());
    private final IrcPublisher.DescriptorImpl descriptor;
    private final Authentication authentication;
    private PircConnection pircConnection;
    private List<IMMessageTarget> groupChats;
    private final List<Bot> bots = new ArrayList();
    private final Map<String, Bot> privateChats = new HashMap();

    public IRCConnection(IrcPublisher.DescriptorImpl descriptor, Authentication authentication) {
        this.descriptor = descriptor;
        this.authentication = authentication;
        this.groupChats = descriptor.getDefaultTargets() != null ? descriptor.getDefaultTargets() : Collections.emptyList();
    }

    public void close() {
        if (this.pircConnection != null && this.pircConnection.isConnected()) {
            this.pircConnection.disconnect();
            this.pircConnection.dispose();
        }
    }

    public boolean isConnected() {
        return this.pircConnection != null && this.pircConnection.isConnected();
    }

    public boolean connect() {
        try {
            this.pircConnection = new PircConnection(this.descriptor.getNick(), this.descriptor.isUseNotice());
            this.pircConnection.connect(this.descriptor.getHost(), this.descriptor.getPort(), this.descriptor.getPassword());
            LOGGER.info("connected to IRC");
            this.pircConnection.addJoinListener((PircConnection.JoinListener)this);
            String nickServPassword = this.descriptor.getNickServPassword();
            if (Util.fixEmpty((String)nickServPassword) != null) {
                this.pircConnection.identify(nickServPassword);
            }
            for (IMMessageTarget groupChatName : this.groupChats) {
                try {
                    this.getGroupChat(groupChatName);
                }
                catch (Exception e) {
                    LOGGER.warning("Unable to connect to channel '" + groupChatName + "'.\n" + "Message: " + ExceptionHelper.dump((Throwable)e));
                }
            }
            this.pircConnection.addMessageListener(this.descriptor.getNick(), PircConnection.CHAT_ESTABLISHER, (IMMessageListener)new ChatEstablishedListener(this, null));
            return true;
        }
        catch (NickAlreadyInUseException e) {
            LOGGER.warning("Error connecting to irc: " + (Object)((Object)e));
        }
        catch (IOException e) {
            LOGGER.warning("Error connecting to irc: " + e);
        }
        catch (IrcException e) {
            LOGGER.warning("Error connecting to irc: " + (Object)((Object)e));
        }
        return false;
    }

    private void getGroupChat(IMMessageTarget groupChat) {
        if (!(groupChat instanceof GroupChatIMMessageTarget)) {
            LOGGER.warning(groupChat + " is no channel. Cannot join.");
            return;
        }
        GroupChatIMMessageTarget channel = (GroupChatIMMessageTarget)groupChat;
        LOGGER.info("Trying to join channel " + channel.getName());
        if (channel.hasPassword()) {
            this.pircConnection.joinChannel(channel.getName(), channel.getPassword());
        } else {
            this.pircConnection.joinChannel(channel.getName());
        }
        this.bots.add(new Bot((IMChat)new IRCChannel(channel.getName(), this.pircConnection), this.descriptor.getNick(), this.descriptor.getHost(), this.descriptor.getCommandPrefix(), this.authentication));
    }

    public void channelJoined(String channelName) {
        LOGGER.info("Joined channel " + channelName);
    }

    public void addConnectionListener(IMConnectionListener listener) {
        if (this.pircConnection != null) {
            this.pircConnection.addConnectionListener(listener);
        }
    }

    public void removeConnectionListener(IMConnectionListener listener) {
        if (this.pircConnection != null) {
            this.pircConnection.removeConnectionListener(listener);
        }
    }

    public void send(IMMessageTarget target, String text) throws IMException {
        this.pircConnection.sendIMMessage(target.toString(), text);
    }

    public void setPresence(IMPresence presence, String statusMessage) throws IMException {
        if (presence.ordinal() >= IMPresence.OCCUPIED.ordinal()) {
            if (statusMessage == null || statusMessage.trim().length() == 0) {
                statusMessage = "away";
            }
            this.pircConnection.sendRawLineViaQueue("AWAY " + statusMessage);
        } else {
            this.pircConnection.sendRawLineViaQueue("AWAY");
        }
    }

    static /* synthetic */ IrcPublisher.DescriptorImpl access$100(IRCConnection x0) {
        return x0.descriptor;
    }

    static /* synthetic */ Map access$200(IRCConnection x0) {
        return x0.privateChats;
    }

    static /* synthetic */ PircConnection access$300(IRCConnection x0) {
        return x0.pircConnection;
    }

    static /* synthetic */ Authentication access$400(IRCConnection x0) {
        return x0.authentication;
    }
}

