/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.ircbot.IrcUserProperty;
import hudson.plugins.ircbot.v2.IRCConnectionProvider;
import hudson.plugins.ircbot.v2.IRCMessageTargetConverter;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcPublisher
extends IMPublisher {
    private static final Logger LOGGER = Logger.getLogger(IrcPublisher.class.getName());
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final IMMessageTargetConverter CONVERTER = new IRCMessageTargetConverter();
    @Deprecated
    public List<String> channels = new ArrayList<String>();

    public IrcPublisher(List<IMMessageTarget> defaultTargets, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters) {
        super(defaultTargets, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected String getConfiguredIMId(User user) {
        IrcUserProperty ircUserProperty = (IrcUserProperty)((Object)user.getProperties().get((Object)IrcUserProperty.DESCRIPTOR));
        if (ircUserProperty != null) {
            return ircUserProperty.getNick();
        }
        return null;
    }

    protected IMConnection getIMConnection() throws IMException {
        return IRCConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "IRC notifier plugin";
    }

    private Object readResolve() {
        if (this.getNotificationTargets() == null) {
            if (this.channels != null) {
                ArrayList<GroupChatIMMessageTarget> targets = new ArrayList<GroupChatIMMessageTarget>(this.channels.size());
                for (String channel : this.channels) {
                    targets.add(new GroupChatIMMessageTarget(channel));
                }
                this.setNotificationTargets(targets);
            } else {
                this.setNotificationTargets(Collections.emptyList());
            }
        }
        this.channels = null;
        if (this.getNotificationStrategy() == null) {
            this.setNotificationStrategy(NotificationStrategy.STATECHANGE_ONLY);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements IMPublisherDescriptor {
        private static final String PREFIX = "irc_publisher.";
        public static final String PARAMETERNAME_STRATEGY = "irc_publisher.strategy";
        public static final String PARAMETERNAME_NOTIFY_START = "irc_publisher.notifyStart";
        public static final String PARAMETERNAME_NOTIFY_SUSPECTS = "irc_publisher.notifySuspects";
        public static final String PARAMETERNAME_NOTIFY_CULPRITS = "irc_publisher.notifyCulprits";
        public static final String PARAMETERNAME_NOTIFY_FIXERS = "irc_publisher.notifyFixers";
        public static final String PARAMETERNAME_NOTIFY_UPSTREAM_COMMITTERS = "irc_publisher.notifyUpstreamCommitters";
        public static final String PARAMETERVALUE_STRATEGY_DEFAULT = NotificationStrategy.STATECHANGE_ONLY.getDisplayName();
        public static final String[] PARAMETERVALUE_STRATEGY_VALUES = NotificationStrategy.getDisplayNames();
        public static final String PARAMETERNAME_HUDSON_LOGIN = "irc_publisher.hudsonLogin";
        public static final String PARAMETERNAME_HUDSON_PASSWORD = "irc_publisher.hudsonPassword";
        public static final String PARAMETERNAME_USE_NOTICE = "irc_publisher.useNotice";
        public static final String PARAMETERNAME_NICKSERV_PASSWORD = "irc_publisher.nickServPassword";
        boolean enabled = false;
        String hostname = null;
        Integer port = 194;
        String password = null;
        String nick = null;
        String nickServPassword = null;
        @Deprecated
        List<String> channels;
        private List<IMMessageTarget> defaultTargets;
        String commandPrefix = null;
        private String hudsonLogin;
        private String hudsonPassword;
        private boolean useNotice;

        DescriptorImpl() {
            super(IrcPublisher.class);
            this.load();
            if (this.isEnabled()) {
                try {
                    IRCConnectionProvider.setDesc(this);
                }
                catch (Exception e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                try {
                    IRCConnectionProvider.setDesc(null);
                }
                catch (IMException iMException) {
                    // empty catch block
                }
            }
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            boolean bl = this.enabled = "on".equals(req.getParameter("irc_publisher.enabled")) || "true".equals(req.getParameter("irc_publisher.enabled"));
            if (this.enabled) {
                this.hostname = req.getParameter("irc_publisher.hostname");
                this.password = req.getParameter("irc_publisher.password");
                this.nick = req.getParameter("irc_publisher.nick");
                this.nickServPassword = req.getParameter(PARAMETERNAME_NICKSERV_PASSWORD);
                try {
                    this.port = Integer.valueOf(req.getParameter("irc_publisher.port"));
                }
                catch (NumberFormatException e) {
                    throw new Descriptor.FormException("port field must be an Integer", "irc_publisher.port");
                }
                this.commandPrefix = req.getParameter("irc_publisher.commandPrefix");
                this.commandPrefix = Util.fixEmptyAndTrim((String)this.commandPrefix);
                String[] channelsNames = req.getParameterValues("irc_publisher.channel.name");
                String[] channelsPasswords = req.getParameterValues("irc_publisher.channel.password");
                List targets = Collections.emptyList();
                if (channelsNames != null) {
                    targets = new ArrayList(channelsNames.length);
                    for (int i = 0; i < channelsNames.length; ++i) {
                        if (Util.fixEmptyAndTrim((String)channelsNames[i]) == null) {
                            throw new Descriptor.FormException("Channel name must not be empty", "channel.name");
                        }
                        if (Util.fixEmpty((String)channelsNames[i]) != null) {
                            targets.add(new GroupChatIMMessageTarget(channelsNames[i], channelsPasswords[i]));
                            continue;
                        }
                        targets.add(new GroupChatIMMessageTarget(channelsNames[i]));
                    }
                }
                this.defaultTargets = targets;
                this.hudsonLogin = req.getParameter(PARAMETERNAME_HUDSON_LOGIN);
                this.hudsonPassword = req.getParameter(PARAMETERNAME_HUDSON_PASSWORD);
                this.useNotice = "on".equals(req.getParameter(PARAMETERNAME_USE_NOTICE));
                try {
                    IRCConnectionProvider.setDesc(this);
                    IRCConnectionProvider.getInstance().currentConnection();
                }
                catch (Exception e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                IRCConnectionProvider.getInstance().releaseConnection();
                try {
                    IRCConnectionProvider.setDesc(null);
                }
                catch (IMException iMException) {
                    // empty catch block
                }
            }
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return "IRC Notification";
        }

        public String getHelpFile() {
            return "/plugin/ircbot/help.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String n;
            String[] channelsNames = req.getParameterValues("irc_publisher.channel.name");
            String[] channelsPasswords = req.getParameterValues("irc_publisher.channel.password");
            List<IMMessageTarget> targets = Collections.emptyList();
            if (channelsNames != null) {
                targets = new ArrayList(channelsNames.length);
                for (int i = 0; i < channelsNames.length; ++i) {
                    if (Util.fixEmptyAndTrim((String)channelsNames[i]) == null) {
                        throw new Descriptor.FormException("Channel name must not be empty", "channel.name");
                    }
                    if (Util.fixEmpty((String)channelsNames[i]) != null) {
                        targets.add((IMMessageTarget)new GroupChatIMMessageTarget(channelsNames[i], channelsPasswords[i]));
                        continue;
                    }
                    targets.add((IMMessageTarget)new GroupChatIMMessageTarget(channelsNames[i]));
                }
            }
            if ((n = req.getParameter(PARAMETERNAME_STRATEGY)) == null) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            } else {
                boolean foundStrategyValueMatch = false;
                for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                    if (!strategyValue.equals(n)) continue;
                    foundStrategyValueMatch = true;
                    break;
                }
                if (!foundStrategyValueMatch) {
                    n = PARAMETERVALUE_STRATEGY_DEFAULT;
                }
            }
            boolean notifyStart = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_START));
            boolean notifySuspects = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_SUSPECTS));
            boolean notifyCulprits = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_CULPRITS));
            boolean notifyFixers = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_FIXERS));
            boolean notifyUpstream = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_UPSTREAM_COMMITTERS));
            return new IrcPublisher(targets, n, notifyStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstream);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getCommandPrefix() {
            return this.commandPrefix;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getNick() {
            return this.nick;
        }

        public String getNickServPassword() {
            return this.nickServPassword;
        }

        public String getPassword() {
            return this.password;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDefaultIdSuffix() {
            return null;
        }

        public String getHost() {
            return this.hostname;
        }

        public String getHudsonUserName() {
            return this.hudsonLogin;
        }

        public String getHudsonPassword() {
            return this.hudsonPassword;
        }

        public String getPluginDescription() {
            return "IRC notifier plugin";
        }

        public String getUserName() {
            return this.nick;
        }

        public boolean isExposePresence() {
            return true;
        }

        public List<IMMessageTarget> getDefaultTargets() {
            if (this.defaultTargets == null) {
                return Collections.emptyList();
            }
            return this.defaultTargets;
        }

        public IMMessageTargetConverter getIMMessageTargetConverter() {
            return CONVERTER;
        }

        public boolean isUseNotice() {
            return this.useNotice;
        }

        private Object readResolve() {
            if (this.defaultTargets == null && this.channels != null) {
                this.defaultTargets = new ArrayList<IMMessageTarget>(this.channels.size());
                for (String channel : this.channels) {
                    this.defaultTargets.add((IMMessageTarget)new GroupChatIMMessageTarget(channel));
                }
                this.channels = null;
                this.save();
            }
            return this;
        }
    }
}

