/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot;

import hudson.Extension;
import hudson.model.User;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.ircbot.IrcPublisher;
import hudson.plugins.ircbot.IrcUserProperty;
import hudson.plugins.ircbot.v2.IRCConnectionProvider;
import hudson.plugins.ircbot.v2.IRCMessageTargetConverter;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcPublisher
extends IMPublisher {
    private static final Logger LOGGER = Logger.getLogger(IrcPublisher.class.getName());
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final IMMessageTargetConverter CONVERTER = new IRCMessageTargetConverter();
    @Deprecated
    public List<String> channels = new ArrayList();

    public IrcPublisher(List<IMMessageTarget> defaultTargets, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier) {
        super(defaultTargets, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, buildToChatNotifier);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected String getConfiguredIMId(User user) {
        IrcUserProperty ircUserProperty = (IrcUserProperty)user.getProperties().get(IrcUserProperty.DESCRIPTOR);
        if (ircUserProperty != null) {
            return ircUserProperty.getNick();
        }
        return null;
    }

    protected IMConnection getIMConnection() throws IMException {
        return IRCConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "IRC notifier plugin";
    }

    protected Object readResolve() {
        super.readResolve();
        if (this.getNotificationTargets() == null) {
            if (this.channels != null) {
                ArrayList<GroupChatIMMessageTarget> targets = new ArrayList<GroupChatIMMessageTarget>(this.channels.size());
                for (String channel : this.channels) {
                    targets.add(new GroupChatIMMessageTarget(channel));
                }
                this.setNotificationTargets(targets);
            } else {
                this.setNotificationTargets(Collections.emptyList());
            }
        }
        this.channels = null;
        if (this.getNotificationStrategy() == null) {
            this.setNotificationStrategy(NotificationStrategy.STATECHANGE_ONLY);
        }
        return this;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ IMMessageTargetConverter access$100() {
        return CONVERTER;
    }
}

