/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.ircbot.v2.PircConnection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.jibble.pircbot.PircBot;

/*
 * Exception performing whole class analysis ignored.
 */
public class PircConnection
extends PircBot {
    private static final Logger LOGGER = Logger.getLogger(PircConnection.class.getName());
    @SuppressWarnings(value={"DM_STRING_CTOR"}, justification="we want a new instance here to enable reference comparison")
    public static final String CHAT_ESTABLISHER = new String("<<<ChatEstablisher>>>");
    private final List<IMConnectionListener> listeners = new CopyOnWriteArrayList();
    private final List<MessageListener> msgListeners = new CopyOnWriteArrayList();
    private final List<JoinListener> joinListeners = new CopyOnWriteArrayList();
    private final List<InviteListener> inviteListeners = new CopyOnWriteArrayList();
    private final List<PartListener> partListeners = new CopyOnWriteArrayList();
    private final boolean useNotice;
    private volatile boolean explicitDisconnect = false;

    public PircConnection(String name, boolean useNotice) {
        this.useNotice = useNotice;
        this.setName(name);
        this.setMessageDelay(500L);
    }

    public void sendIMMessage(String target, String message) {
        String[] lines;
        for (String line : lines = message.split("\\r?\\n|\\r")) {
            if (this.useNotice) {
                this.sendNotice(target, line);
                continue;
            }
            this.sendMessage(target, line);
        }
    }

    protected void handleLine(String line) {
        LOGGER.fine(line);
        super.handleLine(line);
    }

    protected void onMessage(String channel, String sender, String login, String hostname, String message) {
        for (MessageListener l : this.msgListeners) {
            if (!MessageListener.access$000((MessageListener)l).equals(channel)) continue;
            MessageListener.access$100((MessageListener)l).onMessage(new IMMessage(sender, channel, message));
        }
    }

    protected void onPrivateMessage(String sender, String login, String hostname, String message) {
        for (MessageListener l : this.msgListeners) {
            if (!this.getName().equals(MessageListener.access$000((MessageListener)l)) || MessageListener.access$200((MessageListener)l) != CHAT_ESTABLISHER && !sender.equals(MessageListener.access$200((MessageListener)l))) continue;
            MessageListener.access$100((MessageListener)l).onMessage(new IMMessage(sender, this.getNick(), message));
        }
    }

    protected void onNotice(String sourceNick, String sourceLogin, String sourceHostname, String target, String notice) {
        super.onNotice(sourceNick, sourceLogin, sourceHostname, target, notice);
        LOGGER.info("Notice from " + sourceNick + ": '" + PircConnection.normalize((String)notice) + "'");
    }

    protected void onJoin(String channel, String sender, String login, String hostname) {
        for (JoinListener l : this.joinListeners) {
            if (!this.getName().equals(sender)) continue;
            l.channelJoined(channel);
        }
    }

    protected void onPart(String channel, String sender, String login, String hostname) {
        for (PartListener l : this.partListeners) {
            if (!this.getNick().equals(sender)) continue;
            l.channelParted(channel);
        }
    }

    protected void onKick(String channel, String kickerNick, String kickerLogin, String kickerHostname, String recipientNick, String reason) {
        for (PartListener l : this.partListeners) {
            if (!this.getNick().equals(recipientNick)) continue;
            l.channelParted(channel);
        }
    }

    protected void onServerResponse(int code, String response) {
        if (code >= 400 && code <= 599) {
            LOGGER.warning("IRC server responded error " + code + " Message:\n" + response);
        }
    }

    public final void closeConnection() {
        this.explicitDisconnect = true;
        super.disconnect();
    }

    protected void onDisconnect() {
        super.dispose();
        if (!this.explicitDisconnect) {
            for (IMConnectionListener l : this.listeners) {
                l.connectionBroken(null);
            }
        }
        this.explicitDisconnect = false;
        super.onDisconnect();
    }

    protected void onInvite(String targetNick, String sourceNick, String sourceLogin, String sourceHostname, String channel) {
        if (this.getNick().equals(targetNick)) {
            for (InviteListener listener : this.inviteListeners) {
                listener.inviteReceived(channel, sourceNick);
            }
        }
    }

    public void addConnectionListener(IMConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(IMConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void addMessageListener(String target, IMMessageListener listener) {
        this.msgListeners.add(new MessageListener(target, listener));
    }

    public void addMessageListener(String target, String sender, IMMessageListener listener) {
        this.msgListeners.add(new MessageListener(target, sender, listener));
    }

    public void removeMessageListener(String target, IMMessageListener listener) {
        this.msgListeners.remove(new MessageListener(target, listener));
    }

    public void addJoinListener(JoinListener listener) {
        this.joinListeners.add(listener);
    }

    public void removeJoinListener(JoinListener listener) {
        this.joinListeners.remove(listener);
    }

    public void addInviteListener(InviteListener listener) {
        this.inviteListeners.add(listener);
    }

    public void removeInviteListener(InviteListener listener) {
        this.inviteListeners.remove(listener);
    }

    public void addPartListener(PartListener listener) {
        this.partListeners.add(listener);
    }

    public void removePartListener(PartListener listener) {
        this.partListeners.remove(listener);
    }

    private static String normalize(String ircMessage) {
        String msg = ircMessage.replace("\u0001", "");
        msg = msg.replace("\u0002", "");
        msg = msg.replace("\u0016", "");
        msg = msg.replace("\u000f", "");
        return msg;
    }
}

