/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.ivy.IvyBuildTrigger;
import hudson.ivy.IvyMessageImpl;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class IvyBuildTrigger
extends Publisher
implements DependecyDeclarer {
    private static final String BACKUP_IVY_FILE_NAME = "ivy.xml";
    private static final Logger LOGGER = Logger.getLogger(IvyBuildTrigger.class.getName());
    private String ivyFile = "ivy.xml";
    private long lastmodified = 0L;
    private final String ivyConfName;
    private transient ModuleDescriptor moduleDescriptor;
    public static final DescriptorImpl DESCRIPTOR;

    public IvyBuildTrigger(String ivyFile, String ivyConfName) {
        this.ivyFile = ivyFile;
        this.ivyConfName = ivyConfName;
    }

    public String getIvyFile() {
        return this.ivyFile;
    }

    public String getIvyConfName() {
        return this.ivyConfName;
    }

    public IvyConfiguration getIvyConfiguration() {
        for (IvyConfiguration i : DESCRIPTOR.getConfigurations()) {
            if (this.ivyConfName == null || !i.getName().equals(this.ivyConfName)) continue;
            return i;
        }
        return null;
    }

    public Ivy getIvy() {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        Ivy ivy = Ivy.newInstance();
        IvyConfiguration ivyConf = this.getIvyConfiguration();
        if (ivyConf != null) {
            File conf = new File(ivyConf.getIvyConfPath());
            try {
                LOGGER.info("Configure Ivy for Configuration: " + IvyConfiguration.access$000((IvyConfiguration)ivyConf));
                ivy.configure(conf);
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, "Parsing error while reading the ivy configuration " + ivyConf.getName() + " at " + ivyConf.getIvyConfPath(), e);
                return null;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "I/O error while reading the ivy configuration " + ivyConf.getName() + " at " + ivyConf.getIvyConfPath(), e);
                return null;
            }
        }
        return ivy;
    }

    public ModuleDescriptor getModuleDescriptor(AbstractProject p) {
        if (this.moduleDescriptor == null) {
            this.recomputeModuleDescriptor(p);
        }
        return this.moduleDescriptor;
    }

    private void recomputeModuleDescriptor(AbstractProject p) {
        LOGGER.fine("Recomputing Moduledescriptor for Project " + p.getFullDisplayName());
        Ivy ivy = this.getIvy();
        if (ivy == null) {
            this.setModuleDescriptor(null);
            return;
        }
        this.copyIvyFileFromWorkspaceIfNecessary(p);
        File ivyF = new File(p.getRootDir(), "ivy.xml");
        if (!ivyF.exists()) {
            this.setModuleDescriptor(null);
            return;
        }
        if (this.moduleDescriptor != null && ivyF.lastModified() == this.lastmodified) {
            return;
        }
        this.setModuleDescriptor((ModuleDescriptor)ivy.execute((Ivy.IvyCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void setModuleDescriptor(ModuleDescriptor d) {
        ModuleDescriptor old = this.moduleDescriptor;
        this.moduleDescriptor = d;
        if (old == this.moduleDescriptor) {
            return;
        }
        if (old == null || !old.equals(this.moduleDescriptor)) {
            DESCRIPTOR.invalidateProjectMap();
            Hudson.getInstance().rebuildDependencyGraph();
        }
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.recomputeModuleDescriptor(build.getProject());
        return true;
    }

    private FilePath getWorkspace(AbstractProject p) {
        try {
            return p.getWorkspace();
        }
        catch (NullPointerException e) {
            LOGGER.warning("Caught a problem in AbstractProject.getWorkspace!");
            return null;
        }
    }

    private void copyIvyFileFromWorkspaceIfNecessary(AbstractProject p) {
        FilePath workspace = this.getWorkspace(p);
        File rootDir = p.getRootDir();
        if (workspace == null) {
            return;
        }
        FilePath f = workspace.child(this.ivyFile);
        try {
            FilePath backupCopy = new FilePath(new File(rootDir, "ivy.xml"));
            f.copyTo(backupCopy);
            new File(rootDir, "ivy.xml").setLastModified(f.lastModified());
            return;
        }
        catch (IOException e) {
            LOGGER.warning("Failed to read the ivy file " + f);
        }
        catch (InterruptedException e) {
            LOGGER.warning("Interupted when reading the ivy file " + f);
        }
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        ModuleDescriptor md = this.getModuleDescriptor(owner);
        if (md == null) {
            return;
        }
        DependencyDescriptor[] deps = md.getDependencies();
        ArrayList<AbstractProject> dependencies = new ArrayList<AbstractProject>();
        for (DependencyDescriptor depDesc : deps) {
            ModuleId id = depDesc.getDependencyId();
            List possibleDeps = DESCRIPTOR.getProjectsFor(id);
            for (AbstractProject p : possibleDeps) {
                if (p.isDisabled()) {
                    p = null;
                }
                if (p == null) continue;
                dependencies.add(p);
            }
        }
        graph.addDependency(dependencies, owner);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        DESCRIPTOR = new DescriptorImpl();
    }
}

