/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.ivy.IvyMessageImpl;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyBuildTrigger
extends Publisher
implements DependecyDeclarer {
    private static final String BACKUP_IVY_FILE_NAME = "ivy.xml";
    private static final Logger LOGGER = Logger.getLogger(IvyBuildTrigger.class.getName());
    private String ivyFile = "ivy.xml";
    private long lastmodified = 0L;
    private final String ivyConfName;
    private transient ModuleDescriptor moduleDescriptor;
    public static final DescriptorImpl DESCRIPTOR;

    public IvyBuildTrigger(String ivyFile, String ivyConfName) {
        this.ivyFile = ivyFile;
        this.ivyConfName = ivyConfName;
    }

    public String getIvyFile() {
        return this.ivyFile;
    }

    public String getIvyConfName() {
        return this.ivyConfName;
    }

    public IvyConfiguration getIvyConfiguration() {
        for (IvyConfiguration i : DESCRIPTOR.getConfigurations()) {
            if (this.ivyConfName == null || !i.getName().equals(this.ivyConfName)) continue;
            return i;
        }
        return null;
    }

    public Ivy getIvy() {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        Ivy ivy = Ivy.newInstance();
        IvyConfiguration ivyConf = this.getIvyConfiguration();
        if (ivyConf != null) {
            File conf = new File(ivyConf.getIvyConfPath());
            try {
                LOGGER.info("Configure Ivy for Configuration: " + ivyConf.name);
                ivy.configure(conf);
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, "Parsing error while reading the ivy configuration " + ivyConf.getName() + " at " + ivyConf.getIvyConfPath(), e);
                return null;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "I/O error while reading the ivy configuration " + ivyConf.getName() + " at " + ivyConf.getIvyConfPath(), e);
                return null;
            }
        }
        return ivy;
    }

    public ModuleDescriptor getModuleDescriptor(AbstractProject p) {
        if (this.moduleDescriptor == null) {
            this.recomputeModuleDescriptor(p);
        }
        return this.moduleDescriptor;
    }

    private void recomputeModuleDescriptor(AbstractProject p) {
        LOGGER.fine("Recomputing Moduledescriptor for Project " + p.getFullDisplayName());
        Ivy ivy = this.getIvy();
        if (ivy == null) {
            this.setModuleDescriptor(null);
            return;
        }
        this.copyIvyFileFromWorkspaceIfNecessary(p);
        final File ivyF = new File(p.getRootDir(), BACKUP_IVY_FILE_NAME);
        if (!ivyF.exists()) {
            this.setModuleDescriptor(null);
            return;
        }
        if (this.moduleDescriptor != null && ivyF.lastModified() == this.lastmodified) {
            return;
        }
        this.setModuleDescriptor((ModuleDescriptor)ivy.execute(new Ivy.IvyCallback(){

            public Object doInIvyContext(Ivy ivy, IvyContext context) {
                try {
                    return ModuleDescriptorParserRegistry.getInstance().parseDescriptor((ParserSettings)ivy.getSettings(), ivyF.toURI().toURL(), ivy.getSettings().doValidate());
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "The URL is malformed : " + ivyF, e);
                    return null;
                }
                catch (ParseException e) {
                    LOGGER.log(Level.WARNING, "Parsing error while reading the ivy file " + ivyF, e);
                    return null;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "I/O error while reading the ivy file " + ivyF, e);
                    return null;
                }
            }
        }));
    }

    private void setModuleDescriptor(ModuleDescriptor d) {
        ModuleDescriptor old = this.moduleDescriptor;
        this.moduleDescriptor = d;
        if (old == this.moduleDescriptor) {
            return;
        }
        if (old == null || !old.equals(this.moduleDescriptor)) {
            DESCRIPTOR.invalidateProjectMap();
            Hudson.getInstance().rebuildDependencyGraph();
        }
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.recomputeModuleDescriptor(build.getProject());
        return true;
    }

    private FilePath getWorkspace(AbstractProject p) {
        try {
            return p.getWorkspace();
        }
        catch (NullPointerException e) {
            LOGGER.warning("Caught a problem in AbstractProject.getWorkspace!");
            return null;
        }
    }

    private void copyIvyFileFromWorkspaceIfNecessary(AbstractProject p) {
        FilePath workspace = this.getWorkspace(p);
        File rootDir = p.getRootDir();
        if (workspace == null) {
            return;
        }
        FilePath f = workspace.child(this.ivyFile);
        try {
            FilePath backupCopy = new FilePath(new File(rootDir, BACKUP_IVY_FILE_NAME));
            f.copyTo(backupCopy);
            new File(rootDir, BACKUP_IVY_FILE_NAME).setLastModified(f.lastModified());
            return;
        }
        catch (IOException e) {
            LOGGER.warning("Failed to read the ivy file " + f);
        }
        catch (InterruptedException e) {
            LOGGER.warning("Interupted when reading the ivy file " + f);
        }
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        ModuleDescriptor md = this.getModuleDescriptor(owner);
        if (md == null) {
            return;
        }
        DependencyDescriptor[] deps = md.getDependencies();
        ArrayList<AbstractProject> dependencies = new ArrayList<AbstractProject>();
        for (DependencyDescriptor depDesc : deps) {
            ModuleId id = depDesc.getDependencyId();
            List<AbstractProject> possibleDeps = DESCRIPTOR.getProjectsFor(id);
            for (AbstractProject p : possibleDeps) {
                if (p.isDisabled()) {
                    p = null;
                }
                if (p == null) continue;
                dependencies.add(p);
            }
        }
        graph.addDependency(dependencies, owner);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    static {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        DESCRIPTOR = new DescriptorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        private volatile IvyConfiguration[] configurations = new IvyConfiguration[0];
        private volatile transient Map<ModuleId, List<AbstractProject>> projectMap = null;

        DescriptorImpl() {
            super(IvyBuildTrigger.class);
            this.load();
        }

        public List<AbstractProject> getProjectsFor(ModuleId searchId) {
            List<Object> result;
            if (this.projectMap == null) {
                this.calculateProjectMap();
            }
            if ((result = this.projectMap.get(searchId)) == null) {
                result = Collections.emptyList();
            }
            return result;
        }

        public void invalidateProjectMap() {
            this.projectMap = null;
        }

        private void calculateProjectMap() {
            List projects = Hudson.getInstance().getAllItems(Project.class);
            this.projectMap = new HashMap<ModuleId, List<AbstractProject>>();
            for (Project p : projects) {
                ModuleDescriptor m;
                IvyBuildTrigger t;
                if (p.isDisabled() || (t = (IvyBuildTrigger)p.getPublisher((Descriptor)DESCRIPTOR)) == null) continue;
                try {
                    m = t.getModuleDescriptor((AbstractProject)p);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Calculating the Modules Descriptor failed for project " + p.getFullDisplayName(), e);
                    m = null;
                }
                if (m == null) continue;
                ModuleId id = m.getModuleRevisionId().getModuleId();
                List<AbstractProject> list = this.projectMap.get(id);
                if (list == null) {
                    list = new ArrayList<AbstractProject>();
                }
                list.add((AbstractProject)p);
                this.projectMap.put(id, list);
            }
        }

        public IvyConfiguration[] getConfigurations() {
            return this.configurations;
        }

        public String getDisplayName() {
            return "Trigger the build of other project based on the Ivy management system";
        }

        protected void convert(Map<String, Object> oldPropertyBag) {
            if (oldPropertyBag.containsKey("configurations")) {
                this.configurations = (IvyConfiguration[])oldPropertyBag.get("configurations");
            }
        }

        public boolean configure(StaplerRequest req) {
            IvyConfiguration[] confs;
            boolean r = true;
            String[] names = req.getParameterValues("ivy_name");
            String[] paths = req.getParameterValues("ivy_conf_path");
            if (names != null && paths != null) {
                int len = Math.min(names.length, paths.length);
                confs = new IvyConfiguration[len];
                for (int i = 0; i < len; ++i) {
                    if (Util.nullify((String)names[i]) == null || Util.nullify((String)paths[i]) == null) continue;
                    confs[i] = new IvyConfiguration(names[i], paths[i]);
                }
            } else {
                confs = new IvyConfiguration[]{};
            }
            this.configurations = confs;
            this.save();
            this.invalidateProjectMap();
            return r;
        }

        public void doCheckIvyConf(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    File f = this.getFileParameter("value");
                    if (f.getPath().equals("")) {
                        this.error("The Ivy configuration path is required");
                        return;
                    }
                    if (!f.isFile()) {
                        this.error(f + " is not a file");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doCheckIvyFile(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.WorkspaceFilePath(req, rsp, true, true).process();
        }

        public Publisher newInstance(StaplerRequest req) {
            return new IvyBuildTrigger(req.getParameter("ivy_file"), req.getParameter("ivy_conf_name"));
        }
    }

    public static class IvyConfiguration {
        private String name;
        private String ivyConfPath;

        public IvyConfiguration(String name, String ivyConfPath) {
            this.name = name;
            this.ivyConfPath = ivyConfPath;
        }

        public String getIvyConfPath() {
            return this.ivyConfPath;
        }

        public String getName() {
            return this.name;
        }

        public boolean getExists() {
            return new File(this.ivyConfPath).exists();
        }
    }
}

