/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.ivy.IvyMessageImpl;
import hudson.ivy.Messages;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Project;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyBuildTrigger
extends Notifier
implements DependecyDeclarer {
    private static final String BACKUP_IVY_FILE_NAME = "ivy.xml";
    private static final Logger LOGGER = Logger.getLogger(IvyBuildTrigger.class.getName());
    private String ivyFile = "ivy.xml";
    private final String ivyConfName;
    private transient long lastmodified = 0L;
    private transient ModuleDescriptor moduleDescriptor;
    private transient VersionMatcher versionMatcher;
    public static final DescriptorImpl DESCRIPTOR;

    public IvyBuildTrigger(String ivyFile, String ivyConfName) {
        this.ivyFile = ivyFile;
        this.ivyConfName = ivyConfName;
    }

    public String getIvyFile() {
        return this.ivyFile;
    }

    public String getIvyConfName() {
        return this.ivyConfName;
    }

    private IvyConfiguration getIvyConfiguration() {
        IvyConfiguration conf = null;
        if (this.ivyConfName != null) {
            for (IvyConfiguration i : DESCRIPTOR.getConfigurations()) {
                if (!i.getName().equals(this.ivyConfName)) continue;
                conf = i;
                break;
            }
        }
        return conf;
    }

    public Ivy getIvy() {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        IvyConfiguration ivyConf = this.getIvyConfiguration();
        Ivy ivy = Ivy.newInstance();
        Ivy configured = null;
        if (ivyConf != null) {
            try {
                ivy.configure(new File(ivyConf.getIvyConfPath()));
                LOGGER.fine("Configured Ivy using the Ivy settings " + ivyConf.getName());
                configured = ivy;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while reading the Ivy settings " + ivyConf.getName() + " at " + ivyConf.getIvyConfPath(), e);
            }
        } else {
            try {
                ivy.configureDefault();
                LOGGER.fine("Configured Ivy using default 2.0 settings");
                configured = ivy;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while reading the default Ivy 2.0 settings", e);
            }
        }
        return configured;
    }

    private ModuleDescriptor getModuleDescriptor(AbstractProject p) {
        if (this.moduleDescriptor == null) {
            this.recomputeModuleDescriptor(p.getSomeBuildWithWorkspace());
        }
        return this.moduleDescriptor;
    }

    private boolean copyIvyFileFromWorkspaceIfNecessary(FilePath workspace, File localFile) throws IOException, InterruptedException {
        boolean copied = false;
        if (workspace != null) {
            FilePath f = workspace.child(this.ivyFile);
            FilePath backupCopy = new FilePath(localFile);
            long flastModified = f.lastModified();
            if (flastModified == 0L) {
                throw new FileNotFoundException("Can't stat file " + f);
            }
            if (flastModified > this.lastmodified) {
                f.copyTo(backupCopy);
                localFile.setLastModified(flastModified);
                copied = true;
                LOGGER.info("Copied the workspace ivy file to backup");
            }
        }
        return copied;
    }

    private void recomputeModuleDescriptor(AbstractBuild<?, ?> b) {
        File ivyF;
        Ivy ivy;
        block6: {
            LOGGER.fine("Recomputing Moduledescriptor for Project " + b.getProject().getFullDisplayName());
            ivy = this.getIvy();
            if (ivy == null) {
                this.setModuleDescriptor(null);
                return;
            }
            this.versionMatcher = ivy.getSettings().getVersionMatcher();
            ivyF = new File(b.getRootDir(), BACKUP_IVY_FILE_NAME);
            try {
                this.copyIvyFileFromWorkspaceIfNecessary(b.getWorkspace(), ivyF);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to access the workspace ivy file", e);
                LOGGER.log(Level.WARNING, "Removing ModuleDescriptor");
                this.setModuleDescriptor(null);
                return;
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interupted while accessing the workspace ivy file", e);
                if (!ivyF.canRead()) break block6;
                LOGGER.log(Level.WARNING, "Will try to use use existing backup");
            }
        }
        if (!ivyF.canRead()) {
            LOGGER.log(Level.WARNING, "Cannot read ivy file backup...removing ModuleDescriptor");
            this.setModuleDescriptor(null);
            return;
        }
        if (this.moduleDescriptor == null || ivyF.lastModified() > this.lastmodified) {
            this.lastmodified = ivyF.lastModified();
            this.setModuleDescriptor((ModuleDescriptor)ivy.execute(new Ivy.IvyCallback(){

                public Object doInIvyContext(Ivy ivy, IvyContext context) {
                    try {
                        return ModuleDescriptorParserRegistry.getInstance().parseDescriptor((ParserSettings)ivy.getSettings(), ivyF.toURI().toURL(), ivy.getSettings().doValidate());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.WARNING, "The URL is malformed : " + ivyF, e);
                        return null;
                    }
                    catch (ParseException e) {
                        LOGGER.log(Level.WARNING, "Parsing error while reading the ivy file " + ivyF, e);
                        return null;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "I/O error while reading the ivy file " + ivyF, e);
                        return null;
                    }
                }
            }));
        }
    }

    private void setModuleDescriptor(ModuleDescriptor d) {
        ModuleDescriptor old = this.moduleDescriptor;
        this.moduleDescriptor = d;
        if (old == this.moduleDescriptor) {
            return;
        }
        if (old == null || !old.equals(this.moduleDescriptor)) {
            IvyBuildTrigger.DESCRIPTOR.invalidateProjectMap();
            Hudson.getInstance().rebuildDependencyGraph();
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.recomputeModuleDescriptor(build);
        return true;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        ModuleDescriptor md = this.getModuleDescriptor(owner);
        if (md == null) {
            return;
        }
        DependencyDescriptor[] deps = md.getDependencies();
        ArrayList<AbstractProject> dependencies = new ArrayList<AbstractProject>();
        for (DependencyDescriptor depDesc : deps) {
            ModuleId id = depDesc.getDependencyId();
            ModuleRevisionId rid = depDesc.getDependencyRevisionId();
            List possibleDeps = IvyBuildTrigger.DESCRIPTOR.getProjectsFor(id);
            for (AbstractProject p : possibleDeps) {
                if (p.isDisabled()) {
                    p = null;
                }
                if (p == null || !(p instanceof Project) || !this.captures(rid, (Project)p)) continue;
                dependencies.add(p);
            }
        }
        graph.addDependency(dependencies, owner);
    }

    private boolean captures(ModuleRevisionId depRevId, Project candidate) {
        boolean captures;
        IvyBuildTrigger t = (IvyBuildTrigger)candidate.getPublisher((Descriptor)DESCRIPTOR);
        boolean bl = captures = t != null;
        if (captures && DESCRIPTOR.isExtendedVersionMatching()) {
            ModuleDescriptor cmd = t.getModuleDescriptor((AbstractProject)candidate);
            ModuleRevisionId cmrid = cmd.getModuleRevisionId();
            VersionMatcher matcher = this.versionMatcher;
            boolean bl2 = captures = matcher != null && matcher.isDynamic(depRevId);
            if (captures) {
                String dbranch = depRevId.getBranch();
                String cbranch = cmrid.getBranch();
                if (dbranch != null) {
                    captures = dbranch.equals(cbranch);
                } else {
                    boolean bl3 = captures = cbranch == null;
                }
                if (captures && (captures = matcher.accept(depRevId, cmrid)) && matcher.needModuleDescriptor(depRevId, cmrid)) {
                    captures = matcher.accept(depRevId, cmd);
                }
            }
        }
        return captures;
    }

    static {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        DESCRIPTOR = new DescriptorImpl();
    }

    public static class UserCause
    extends Cause.UserCause {
        private String ivylabel;

        public UserCause(String ivylabel) {
            this.ivylabel = ivylabel;
        }

        public String getIvylabel() {
            return this.ivylabel;
        }

        public String getShortDescription() {
            return Messages.IvyBuildTrigger_UserCause_ShortDescription(this.getIvylabel(), this.getUserName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private volatile IvyConfiguration[] configurations = new IvyConfiguration[0];
        private volatile transient Map<ModuleId, List<AbstractProject>> projectMap = null;
        private volatile boolean extendedVersionMatching = false;

        DescriptorImpl() {
            this.load();
        }

        private List<AbstractProject> getProjectsFor(ModuleId searchId) {
            List<Object> result;
            if (this.projectMap == null) {
                this.calculateProjectMap();
            }
            if ((result = this.projectMap.get(searchId)) == null) {
                result = Collections.emptyList();
            }
            return result;
        }

        private void invalidateProjectMap() {
            this.projectMap = null;
        }

        private void calculateProjectMap() {
            List projects = Hudson.getInstance().getAllItems(Project.class);
            HashMap<ModuleId, List<AbstractProject>> projectMap = new HashMap<ModuleId, List<AbstractProject>>();
            for (Project p : projects) {
                ModuleDescriptor m;
                IvyBuildTrigger t;
                if (p.isDisabled() || (t = (IvyBuildTrigger)p.getPublisher((Descriptor)DESCRIPTOR)) == null) continue;
                try {
                    m = t.getModuleDescriptor((AbstractProject)p);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Calculating the ModuleDescriptor failed for project " + p.getFullDisplayName(), e);
                    m = null;
                }
                if (m == null) continue;
                ModuleId id = m.getModuleRevisionId().getModuleId();
                ArrayList<Project> list = (ArrayList<Project>)projectMap.get(id);
                if (list == null) {
                    list = new ArrayList<Project>();
                }
                list.add(p);
                projectMap.put(id, list);
            }
            this.projectMap = projectMap;
        }

        public IvyConfiguration[] getConfigurations() {
            return this.configurations;
        }

        public boolean isExtendedVersionMatching() {
            return this.extendedVersionMatching;
        }

        public String getDisplayName() {
            return Messages.IvyBuildTrigger_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            IvyConfiguration[] confs;
            boolean r = true;
            String[] names = req.getParameterValues("ivy_name");
            String[] paths = req.getParameterValues("ivy_conf_path");
            String vm = req.getParameter("ivy_version_matching");
            if (names != null && paths != null) {
                int len = Math.min(names.length, paths.length);
                confs = new IvyConfiguration[len];
                for (int i = 0; i < len; ++i) {
                    if (Util.nullify((String)names[i]) == null || Util.nullify((String)paths[i]) == null) continue;
                    confs[i] = new IvyConfiguration(names[i], paths[i]);
                }
            } else {
                confs = new IvyConfiguration[]{};
            }
            LOGGER.info("IvyConfigurations: " + confs.length);
            this.configurations = confs;
            this.extendedVersionMatching = vm != null;
            this.save();
            this.invalidateProjectMap();
            Hudson.getInstance().rebuildDependencyGraph();
            return r;
        }

        public void doHandleExternalTrigger(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            String org = Util.fixEmptyAndTrim((String)req.getParameter("org"));
            String name = Util.fixEmptyAndTrim((String)req.getParameter("name"));
            String branch = Util.fixEmptyAndTrim((String)req.getParameter("branch"));
            String rev = Util.fixEmptyAndTrim((String)req.getParameter("rev"));
            Hudson.getInstance().getACL().checkPermission(Item.BUILD);
            if (org == null || name == null) {
                throw new IllegalArgumentException("doHandleExternalTrigger requires the org and name parameters");
            }
            if (this.extendedVersionMatching && branch == null && rev == null) {
                throw new IllegalArgumentException("doHandleExternalTrigger requires rev or branch when using extended revision matching");
            }
            ModuleId id = ModuleId.newInstance((String)org, (String)name);
            String ivylabel = ModuleRevisionId.newInstance((String)org, (String)name, (String)branch, (String)Util.fixNull((String)rev)).toString();
            List downstream = Collections.emptyList();
            List<AbstractProject> candidates = this.getProjectsFor(id);
            for (AbstractProject candidate : candidates) {
                Project p;
                IvyBuildTrigger t;
                if (candidate.isDisabled() || !(candidate instanceof Project) || (t = (IvyBuildTrigger)(p = (Project)candidate).getPublisher((Descriptor)DESCRIPTOR)) == null) continue;
                if (this.extendedVersionMatching) {
                    ModuleDescriptor md = t.getModuleDescriptor((AbstractProject)p);
                    ModuleRevisionId mdrid = md.getModuleRevisionId();
                    String mdbranch = mdrid.getBranch();
                    if (branch != null && !branch.equals(mdbranch) || branch == null && mdbranch != null || rev != null && !rev.equals(mdrid.getRevision())) continue;
                }
                downstream = Hudson.getInstance().getDependencyGraph().getDownstream((AbstractProject)p);
                break;
            }
            for (AbstractProject down : downstream) {
                if (down.isDisabled()) continue;
                down.scheduleBuild((Cause)new UserCause(ivylabel));
            }
        }

        public FormValidation doCheckIvyConf(@QueryParameter String value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyConf_PathRequiredError());
            }
            File f = new File(value);
            if (!f.isFile()) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyConf_PathNotFileError(f));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIvyFile(@QueryParameter String value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyFile_PathRequiredError());
            }
            if (new File(value).isAbsolute()) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyFile_PathAbsoluteError());
            }
            return FormValidation.ok();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject json) {
            return new IvyBuildTrigger(req.getParameter("ivy_file"), req.getParameter("ivy_conf_name"));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Project.class.isAssignableFrom(jobType);
        }
    }

    public static class IvyConfiguration {
        private String name;
        private String ivyConfPath;

        public IvyConfiguration(String name, String ivyConfPath) {
            this.name = name;
            this.ivyConfPath = ivyConfPath;
        }

        public String getIvyConfPath() {
            return this.ivyConfPath;
        }

        public String getName() {
            return this.name;
        }

        public boolean getExists() {
            return new File(this.ivyConfPath).exists();
        }
    }
}

