/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.Util;
import hudson.ivy.AbstractIvyProject;
import hudson.ivy.Messages;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildTrigger;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIvyBuild<P extends AbstractIvyProject<P, B>, B extends AbstractIvyBuild<P, B>>
extends AbstractBuild<P, B> {
    public static boolean debug = false;

    protected AbstractIvyBuild(P job) throws IOException {
        super(job);
    }

    public AbstractIvyBuild(P job, Calendar timestamp) {
        super(job, timestamp);
    }

    public AbstractIvyBuild(P project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    protected final void scheduleDownstreamBuilds(BuildListener listener) {
        BuildTrigger bt = (BuildTrigger)((AbstractIvyProject)this.getParent()).getPublishersList().get(BuildTrigger.class);
        if (this.getResult().isWorseThan(bt != null ? bt.getThreshold() : Result.SUCCESS)) {
            return;
        }
        for (AbstractProject down : ((AbstractIvyProject)this.getParent()).getDownstreamProjects()) {
            if (debug) {
                listener.getLogger().println("Considering whether to trigger " + down + " or not");
            }
            boolean trigger = true;
            if (down.isInQueue()) {
                if (debug) {
                    listener.getLogger().println(" -> No, because downstream is already in queue");
                }
                trigger = false;
            } else if (this.areUpstreamsBuilding(down, (AbstractProject)this.getParent())) {
                if (debug) {
                    listener.getLogger().println(" -> No, because downstream has dependencies already building or in queue");
                }
                trigger = false;
            } else if (this.inDownstreamProjects(down)) {
                if (debug) {
                    listener.getLogger().println(" -> No, because downstream has dependencies in the downstream projects list");
                }
                trigger = false;
            } else {
                AbstractBuild dlb = (AbstractBuild)down.getLastBuild();
                for (AbstractIvyProject up : Util.filter((List)down.getUpstreamProjects(), AbstractIvyProject.class)) {
                    int n;
                    Object ulb = up == this.getParent() ? (this.getResult() == null || !this.getResult().isWorseThan(Result.UNSTABLE) ? this : up.getLastSuccessfulBuild()) : up.getLastSuccessfulBuild();
                    if (ulb == null) {
                        if (debug) {
                            listener.getLogger().println(" -> No, because another upstream " + up + " for " + down + " has no successful build");
                        }
                        trigger = false;
                        break;
                    }
                    if (dlb != null && (n = dlb.getUpstreamRelationship((AbstractProject)up)) != -1) assert (ulb.getNumber() >= n);
                }
            }
            if (!trigger) continue;
            listener.getLogger().println(Messages.IvyBuild_Triggering((Object)down.getName()));
            down.scheduleBuild((Cause)new Cause.UpstreamCause((Run)this));
        }
    }

    private boolean inDownstreamProjects(AbstractProject downstreamProject) {
        DependencyGraph graph = Hudson.getInstance().getDependencyGraph();
        Set tups = graph.getTransitiveUpstream(downstreamProject);
        for (AbstractProject tup : tups) {
            for (AbstractProject dp : ((AbstractIvyProject)this.getParent()).getDownstreamProjects()) {
                if (dp == this.getParent() || dp == downstreamProject || dp != tup) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areUpstreamsBuilding(AbstractProject downstreamProject, AbstractProject excludeProject) {
        DependencyGraph graph = Hudson.getInstance().getDependencyGraph();
        Set tups = graph.getTransitiveUpstream(downstreamProject);
        for (AbstractProject tup : tups) {
            if (tup == excludeProject || !tup.isBuilding() && !tup.isInQueue()) continue;
            return true;
        }
        return false;
    }
}

