/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.EnvVars;
import hudson.Util;
import hudson.ivy.AbstractIvyBuild;
import hudson.ivy.AbstractIvyProject;
import hudson.ivy.AggregatableAction;
import hudson.ivy.IvyAggregatedReport;
import hudson.ivy.IvyBuild;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleSet;
import hudson.ivy.IvyModuleSetBuild;
import hudson.ivy.IvyReporter;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Fingerprint;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyModuleSetBuild
extends AbstractIvyBuild<IvyModuleSet, IvyModuleSetBuild> {
    List<IvyReporter> projectActionReporters;
    private static final Logger LOGGER = Logger.getLogger(IvyModuleSetBuild.class.getName());
    public static boolean debug = false;

    public IvyModuleSetBuild(IvyModuleSet job) throws IOException {
        super((AbstractIvyProject)job);
    }

    public IvyModuleSetBuild(IvyModuleSet project, File buildDir) throws IOException {
        super((AbstractIvyProject)project, buildDir);
    }

    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        String opts = ((IvyModuleSet)this.project).getAntOpts();
        if (opts != null) {
            envs.put((Object)"ANT_OPTS", (Object)opts);
        }
        return envs;
    }

    public Result getResult() {
        Result r = super.getResult();
        for (IvyBuild b : this.getModuleLastBuilds().values()) {
            Result br = b.getResult();
            if (r == null) {
                r = br;
                continue;
            }
            if (br == Result.NOT_BUILT || br == null) continue;
            r = r.combine(br);
        }
        return r;
    }

    List<ChangeLogSet.Entry> getChangeSetFor(IvyModule mod) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Map<IvyModule, List<IvyBuild>> getModuleBuilds() {
        Collection mods = this.getParent().getModules();
        IvyModuleSetBuild nb = (IvyModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<IvyModule, List<IvyBuild>> r = new LinkedHashMap<IvyModule, List<IvyBuild>>(mods.size());
        for (IvyModule m : mods) {
            ArrayList<IvyBuild> builds = new ArrayList<IvyBuild>();
            for (IvyBuild b = (IvyBuild)m.getNearestBuild(this.number); b != null && b.getNumber() < end; b = (IvyBuild)b.getNextBuild()) {
                builds.add(b);
            }
            r.put(m, builds);
        }
        return r;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        IvyModule m;
        if (token.indexOf(36) > 0 && (m = ((IvyModuleSet)this.getProject()).getModule(token)) != null) {
            return m.getBuildByNumber(this.getNumber());
        }
        return super.getDynamic(token, req, rsp);
    }

    public Map<IvyModule, IvyBuild> getModuleLastBuilds() {
        Collection mods = this.getParent().getModules();
        IvyModuleSetBuild nb = (IvyModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<IvyModule, IvyBuild> r = new LinkedHashMap<IvyModule, IvyBuild>(mods.size());
        for (IvyModule m : mods) {
            IvyBuild b = (IvyBuild)m.getNearestOldBuild(end - 1);
            if (b == null || b.getNumber() < this.getNumber()) continue;
            r.put(m, b);
        }
        return r;
    }

    public void registerAsProjectAction(IvyReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList();
        }
        this.projectActionReporters.add(reporter);
    }

    public <T extends Action> List<T> findModuleBuildActions(Class<T> action) {
        Collection mods = this.getParent().getModules();
        ArrayList<Action> r = new ArrayList<Action>(mods.size());
        IvyModuleSetBuild nb = (IvyModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() - 1 : Integer.MAX_VALUE;
        block0: for (IvyModule m : mods) {
            for (IvyBuild b = (IvyBuild)m.getNearestOldBuild(end); b != null && b.getNumber() >= this.number; b = (IvyBuild)b.getPreviousBuild()) {
                Action a = b.getAction(action);
                if (a == null) continue;
                r.add(a);
                continue block0;
            }
        }
        return r;
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl(this, null));
        ((IvyModuleSet)this.getProject()).updateTransientActions();
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        Fingerprint.RangeSet rs = super.getDownstreamRelationship(that);
        for (List builds : this.getModuleBuilds().values()) {
            for (IvyBuild b : builds) {
                rs.add(b.getDownstreamRelationship(that));
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyModuleBuild(IvyBuild newBuild) {
        try {
            this.getParent().updateNextBuildNumber();
            Map moduleBuilds = this.getModuleBuilds();
            IvyModuleSetBuild ivyModuleSetBuild = this;
            synchronized (ivyModuleSetBuild) {
                IvyAggregatedReport mar;
                boolean modified = false;
                List actions = this.getActions();
                HashSet individuals = new HashSet();
                for (Action a : actions) {
                    if (!(a instanceof IvyAggregatedReport)) continue;
                    mar = (IvyAggregatedReport)a;
                    mar.update(moduleBuilds, newBuild);
                    individuals.add(mar.getIndividualActionType());
                    modified = true;
                }
                for (AggregatableAction aa : newBuild.getActions(AggregatableAction.class)) {
                    if (!individuals.add(aa.getClass())) continue;
                    mar = aa.createAggregatedAction(this, moduleBuilds);
                    mar.update(moduleBuilds, newBuild);
                    actions.add(mar);
                    modified = true;
                }
                if (modified) {
                    this.save();
                    ((IvyModuleSet)this.getProject()).updateTransientActions();
                }
            }
            String moduleFsName = ((IvyModule)newBuild.getProject()).getModuleName().toFileSystemName();
            Util.createSymlink((File)this.getRootDir(), (String)("../../modules/" + moduleFsName + "/builds/" + newBuild.getId()), (String)moduleFsName, (TaskListener)new StreamTaskListener());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + this, e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + this, e);
        }
    }

    public IvyModuleSet getParent() {
        return (IvyModuleSet)super.getParent();
    }

    static /* synthetic */ Job access$100(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$200(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$300(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$400(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$500(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$600(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ List access$700(IvyModuleSetBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ Job access$800(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$900(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1000(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1100(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1200(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1300(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1400(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1500(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1600(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1700(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1800(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$1900(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ List access$2000(IvyModuleSetBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$2100(IvyModuleSetBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$2202(IvyModuleSetBuild x0, List x1) {
        x0.buildEnvironments = x1;
        return x0.buildEnvironments;
    }

    static /* synthetic */ Job access$2300(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2400(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2500(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2600(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2700(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2800(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$2900(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$3000(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$3100(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$3200(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$3300(IvyModuleSetBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$3400(IvyModuleSetBuild x0) {
        return x0.project;
    }
}

