/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.ivy.IvyBuilder;
import hudson.ivy.Messages;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.tools.ant.BuildEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IvyBuilder
implements DelegatingCallable<Result, IOException> {
    private final List<String> goals;
    private final Map<String, String> systemProps;
    protected final BuildListener listener;
    protected transient List<Future<?>> futures;
    private static final long serialVersionUID = 1L;

    protected IvyBuilder(BuildListener listener, List<String> goals, Map<String, String> systemProps) {
        this.listener = listener;
        this.goals = goals;
        this.systemProps = systemProps;
    }

    abstract void preBuild(BuildEvent var1) throws IOException, InterruptedException;

    abstract void postBuild(BuildEvent var1) throws IOException, InterruptedException;

    abstract void preModule(BuildEvent var1) throws InterruptedException, IOException;

    abstract void postModule(BuildEvent var1) throws InterruptedException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Result call() throws IOException {
        this.futures = new ArrayList();
        Adapter a = new Adapter(this);
        System.getProperties().putAll((Map<?, ?>)this.systemProps);
        this.listener.getLogger().println(this.formatArgs(this.goals));
        boolean messageReported = false;
        long startTime = System.nanoTime();
        for (Future f : this.futures) {
            try {
                if (!f.isDone() && !messageReported) {
                    messageReported = true;
                    this.listener.getLogger().println(Messages.IvyBuilder_Waiting());
                }
                f.get();
            }
            catch (InterruptedException e) {
                for (Future g : this.futures) {
                    g.cancel(true);
                }
                this.listener.getLogger().println(Messages.IvyBuilder_Aborted());
                Result result = Result.ABORTED;
                return result;
            }
            catch (ExecutionException e) {
            }
        }
        a.overheadTime += System.nanoTime() - startTime;
        this.futures.clear();
        this.listener.getLogger().println(Messages.IvyBuilder_Failed());
        Result result = Result.FAILURE;
        return result;
    }

    private String formatArgs(List<String> args) {
        StringBuilder buf = new StringBuilder("Executing Ant: ");
        for (String arg : args) {
            buf.append(' ').append(arg);
        }
        return buf.toString();
    }

    private String format(NumberFormat n, long nanoTime) {
        return n.format(nanoTime / 1000000L);
    }

    public ClassLoader getClassLoader() {
        return Hudson.getInstance().getPluginManager().uberClassLoader;
    }
}

