/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy.builder;

import hudson.Extension;
import hudson.ivy.AntIvyBuildWrapper;
import hudson.ivy.IvyModuleSet;
import hudson.ivy.builder.IvyBuilderType;
import hudson.ivy.builder.IvyBuilderTypeDescriptor;
import hudson.model.Environment;
import hudson.model.Hudson;
import hudson.tasks.Ant;
import hudson.tasks.Builder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntIvyBuilderType
extends IvyBuilderType {
    private String targets;
    private String antName;
    private String antOpts;
    private String buildFile;
    private String antProperties;

    @DataBoundConstructor
    public AntIvyBuilderType(String antName, String buildFile, String targets, String antProperties, String antOpts) {
        this.antName = antName;
        this.buildFile = buildFile;
        this.targets = targets;
        this.antProperties = antProperties;
        this.antOpts = antOpts;
    }

    public String getTargets() {
        return this.targets;
    }

    protected String getCalculatedTargets(String targets, List<Environment> buildEnvironments) {
        String additionalTargets = this.getAdditionalAntTargets(buildEnvironments);
        if (StringUtils.isNotBlank((String)additionalTargets)) {
            return StringUtils.isNotBlank((String)targets) ? additionalTargets + targets : additionalTargets;
        }
        return targets;
    }

    public String getAntName() {
        return this.antName;
    }

    public String getAntOpts() {
        return this.antOpts;
    }

    protected String getCalculatedAntOpts(List<Environment> buildEnvironments) {
        String antOpts = null;
        if (this.antOpts != null && this.antOpts.trim().length() > 0) {
            antOpts = this.antOpts.replaceAll("[\t\r\n]+", " ");
        } else {
            String globalOpts = IvyModuleSet.DESCRIPTOR.getGlobalAntOpts();
            if (globalOpts != null) {
                antOpts = globalOpts.replaceAll("[\t\r\n]+", " ");
            }
        }
        String additionalArgs = this.getAddtionalAntOpts(buildEnvironments);
        if (StringUtils.isNotBlank((String)additionalArgs)) {
            return StringUtils.isNotBlank((String)antOpts) ? additionalArgs + antOpts : additionalArgs;
        }
        return antOpts;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getAntProperties() {
        return this.antProperties;
    }

    @Override
    public Map<String, String> getEnvironment() {
        HashMap<String, String> envs = new HashMap<String, String>();
        String opts = this.getCalculatedAntOpts(null);
        if (opts != null) {
            envs.put("ANT_OPTS", opts);
        }
        return envs;
    }

    @Override
    public Builder getBuilder(Properties additionalProperties, String overrideTargets, List<Environment> environments) {
        StringBuilder properties = new StringBuilder();
        if (this.antProperties != null) {
            properties.append(this.antProperties);
        }
        if (additionalProperties != null) {
            for (String key : additionalProperties.stringPropertyNames()) {
                properties.append("\n");
                properties.append(key).append("=").append(additionalProperties.getProperty(key));
            }
        }
        return new Ant(this.getCalculatedTargets(overrideTargets == null ? this.targets : overrideTargets, environments), this.antName, this.getCalculatedAntOpts(environments), this.buildFile, properties.length() == 0 ? null : properties.toString());
    }

    private String getAdditionalAntTargets(List<Environment> buildEnvironments) {
        if (buildEnvironments != null) {
            StringBuilder additionalAntTargets = new StringBuilder();
            for (Environment environment : buildEnvironments) {
                if (!(environment instanceof AntIvyBuildWrapper.AntIvyBuilderEnvironment)) continue;
                additionalAntTargets.append(((AntIvyBuildWrapper.AntIvyBuilderEnvironment)environment).getAdditionalArgs()).append(" ");
            }
            return additionalAntTargets.toString();
        }
        return null;
    }

    private String getAddtionalAntOpts(List<Environment> buildEnvironments) {
        if (buildEnvironments != null) {
            StringBuilder addtionalAntOpts = new StringBuilder();
            for (Environment environment : buildEnvironments) {
                if (!(environment instanceof AntIvyBuildWrapper.AntIvyBuilderEnvironment)) continue;
                addtionalAntOpts.append(((AntIvyBuildWrapper.AntIvyBuilderEnvironment)environment).getAdditionalOpts()).append(" ");
            }
            return addtionalAntOpts.toString();
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends IvyBuilderTypeDescriptor {
        public String getDisplayName() {
            return "Ant Builder";
        }

        public Ant.AntInstallation[] getInstallations() {
            return ((Ant.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Ant.DescriptorImpl.class)).getInstallations();
        }
    }
}

