/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.ivy.AbstractIvyProject;
import hudson.ivy.IvyAggregatedReport;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleSetBuild;
import hudson.ivy.IvyReporter;
import hudson.ivy.Messages;
import hudson.ivy.ModuleName;
import hudson.ivy.builder.AntIvyBuilderType;
import hudson.ivy.builder.IvyBuilderType;
import hudson.ivy.builder.NAntIvyBuilderType;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.ResourceActivity;
import hudson.model.SCMedItem;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.queue.CauseOfBlockage;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Function1;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IvyModuleSet
extends AbstractIvyProject<IvyModuleSet, IvyModuleSetBuild>
implements TopLevelItem,
ItemGroup<IvyModule>,
SCMedItem,
Saveable,
BuildableItemWithBuildWrappers {
    transient Map<ModuleName, IvyModule> modules = new CopyOnWriteMap.Tree();
    transient List<IvyModule> sortedActiveModules;
    private String ivyFilePattern;
    private String ivyFileExcludesPattern;
    private String targets;
    private String ivyBranch;
    private String relativePathToDescriptorFromModuleRoot;
    private String ivySettingsFile;
    private String ivySettingsPropertyFiles;
    private IvyBuilderType ivyBuilderType;
    private String antName;
    private String antOpts;
    private String buildFile;
    private String antProperties;
    private boolean aggregatorStyleBuild = true;
    private boolean incrementalBuild = false;
    private String changedModulesProperty;
    private boolean ignoreUpstreamChanges = false;
    private Boolean allowedToTriggerDownstream = true;
    private boolean useUpstreamParameters = false;
    private boolean archivingDisabled = false;
    private DescribableList<Publisher, Descriptor<Publisher>> publishers = new DescribableList((Saveable)this);
    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers = new DescribableList((Saveable)this);
    @Extension(ordinal=890.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public boolean isUseUpstreamParameters() {
        return this.useUpstreamParameters;
    }

    public void setUseUpstreamParameters(boolean useUpstreamParameters) {
        this.useUpstreamParameters = useUpstreamParameters;
    }

    public IvyModuleSet(String name) {
        super((ItemGroup)Hudson.getInstance(), name);
    }

    public String getUrlChildPrefix() {
        return ".";
    }

    public Hudson getParent() {
        return Hudson.getInstance();
    }

    public Collection<IvyModule> getItems() {
        return this.modules.values();
    }

    @Exported
    public Collection<IvyModule> getModules() {
        return this.getItems();
    }

    public IvyModule getItem(String name) {
        return this.modules.get(ModuleName.fromString(name));
    }

    public IvyModule getModule(String name) {
        return this.getItem(name);
    }

    @Override
    protected void updateTransientActions() {
        Collection a;
        super.updateTransientActions();
        for (IvyModule module : this.modules.values()) {
            module.updateTransientActions();
        }
        if (this.publishers != null) {
            for (Publisher step : this.publishers) {
                a = step.getProjectActions((AbstractProject)this);
                if (a == null) continue;
                this.transientActions.addAll(a);
            }
        }
        if (this.buildWrappers != null) {
            for (Publisher step : this.buildWrappers) {
                a = step.getProjectActions((AbstractProject)this);
                if (a == null) continue;
                this.transientActions.addAll(a);
            }
        }
    }

    @Override
    protected void addTransientActionsFromBuild(IvyModuleSetBuild build, Set<Class> added) {
        if (build == null) {
            return;
        }
        for (Action a : build.getActions()) {
            if (!(a instanceof IvyAggregatedReport) || !added.add(a.getClass())) continue;
            this.transientActions.add(((IvyAggregatedReport)a).getProjectAction(this));
        }
        List<IvyReporter> list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (IvyReporter step : list) {
            Action a;
            if (!added.add(step.getClass()) || (a = step.getAggregatedProjectAction(this)) == null) continue;
            this.transientActions.add(a);
        }
    }

    void onModuleDeleted(IvyModule module) {
        this.modules.remove(module.getModuleName());
    }

    public boolean hasDisabledModule() {
        for (IvyModule m : this.modules.values()) {
            if (!m.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public List<IvyModule> getDisabledModules(boolean disabled) {
        if (!disabled && this.sortedActiveModules != null) {
            return this.sortedActiveModules;
        }
        ArrayList<IvyModule> r = new ArrayList<IvyModule>();
        for (IvyModule m : this.modules.values()) {
            if (m.isDisabled() != disabled) continue;
            r.add(m);
        }
        return r;
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public String getChangedModulesProperty() {
        return this.changedModulesProperty;
    }

    public boolean isAggregatorStyleBuild() {
        return this.aggregatorStyleBuild;
    }

    public boolean ignoreUpstreamChanges() {
        return this.ignoreUpstreamChanges;
    }

    public boolean isAllowedToTriggerDownstream() {
        return this.allowedToTriggerDownstream;
    }

    public void setAllowedToTriggerDownstream(boolean allowedToTriggerDownstream) {
        this.allowedToTriggerDownstream = allowedToTriggerDownstream;
    }

    public boolean isArchivingDisabled() {
        return this.archivingDisabled;
    }

    public void setIncrementalBuild(boolean incrementalBuild) {
        this.incrementalBuild = incrementalBuild;
    }

    public String getIvyFilePattern() {
        return this.ivyFilePattern;
    }

    public void setIvyFilePattern(String ivyFilePattern) {
        this.ivyFilePattern = ivyFilePattern;
    }

    public String getIvyFileExcludesPattern() {
        return this.ivyFileExcludesPattern;
    }

    public void setIvyFileExcludesPattern(String ivyFileExcludesPattern) {
        this.ivyFileExcludesPattern = ivyFileExcludesPattern;
    }

    public String getIvySettingsFile() {
        return this.ivySettingsFile;
    }

    public void setIvySettingsFile(String ivySettingsFile) {
        this.ivySettingsFile = ivySettingsFile;
    }

    public String getIvySettingsPropertyFiles() {
        return this.ivySettingsPropertyFiles;
    }

    public void setIvySettingsPropertyFiles(String ivySettingsPropertyFiles) {
        this.ivySettingsPropertyFiles = ivySettingsPropertyFiles;
    }

    public String getIvyBranch() {
        return this.ivyBranch;
    }

    public void setIvyBranch(String ivyBranch) {
        this.ivyBranch = ivyBranch;
    }

    public IvyBuilderType getIvyBuilderType() {
        return this.ivyBuilderType;
    }

    public void setAggregatorStyleBuild(boolean aggregatorStyleBuild) {
        this.aggregatorStyleBuild = aggregatorStyleBuild;
    }

    public void setIgnoreUpstremChanges(boolean ignoreUpstremChanges) {
        this.ignoreUpstreamChanges = ignoreUpstremChanges;
    }

    public void setIsArchivingDisabled(boolean archivingDisabled) {
        this.archivingDisabled = archivingDisabled;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getModulePublishers() {
        return this.aggregatorStyleBuild ? new DescribableList((Saveable)this) : this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishers() {
        return this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.publishers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.buildWrappers;
    }

    @Deprecated
    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappers() {
        return this.buildWrappers;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (ModuleName.isValid(token)) {
            return this.getModule(token);
        }
        return super.getDynamic(token, req, rsp);
    }

    public File getRootDirFor(IvyModule child) {
        return new File(this.getModulesDir(), child.getModuleName().toFileSystemName());
    }

    public Collection<Job> getAllJobs() {
        HashSet<IvyModule> jobs = new HashSet<IvyModule>(this.getItems());
        jobs.add((IvyModule)((Object)this));
        return jobs;
    }

    protected Class<IvyModuleSetBuild> getBuildClass() {
        return IvyModuleSetBuild.class;
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new CollectionSearchIndex<IvyModule>(){

            protected IvyModule get(String key) {
                for (IvyModule m : IvyModuleSet.this.modules.values()) {
                    if (!m.getDisplayName().equals(key)) continue;
                    return m;
                }
                return null;
            }

            protected Collection<IvyModule> all() {
                return IvyModuleSet.this.modules.values();
            }

            protected String getName(IvyModule o) {
                return o.getName();
            }
        });
    }

    public boolean isFingerprintConfigured() {
        return true;
    }

    public synchronized void save() throws IOException {
        super.save();
        if (!this.isAggregatorStyleBuild()) {
            for (IvyModule module : this.getModules()) {
                module.save();
            }
        }
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.modules = Collections.emptyMap();
        super.onLoad(parent, name);
        this.modules = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getModulesDir(), (Function1)new Function1<ModuleName, IvyModule>(){

            public ModuleName call(IvyModule module) {
                return module.getModuleName();
            }
        });
        if (this.publishers == null) {
            this.publishers = new DescribableList((Saveable)this);
        }
        this.publishers.setOwner((Saveable)this);
        if (this.buildWrappers == null) {
            this.buildWrappers = new DescribableList((Saveable)this);
        }
        this.buildWrappers.setOwner((Saveable)this);
        this.updateTransientActions();
    }

    private File getModulesDir() {
        return new File(this.getRootDir(), "modules");
    }

    public synchronized int assignBuildNumber() throws IOException {
        this.updateNextBuildNumber();
        return super.assignBuildNumber();
    }

    public void logRotate() throws IOException, InterruptedException {
        super.logRotate();
        for (IvyModule m : this.modules.values()) {
            m.logRotate();
        }
    }

    void updateNextBuildNumber() throws IOException {
        int next = this.nextBuildNumber;
        for (IvyModule m : this.modules.values()) {
            next = Math.max(next, m.getNextBuildNumber());
        }
        if (this.nextBuildNumber != next) {
            this.nextBuildNumber = next;
            this.saveNextBuildNumber();
        }
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        this.publishers.buildDependencyGraph((AbstractProject)this, graph);
        this.buildWrappers.buildDependencyGraph((AbstractProject)this, graph);
    }

    protected Set<ResourceActivity> getResourceActivities() {
        HashSet<ResourceActivity> activities = new HashSet<ResourceActivity>();
        activities.addAll(super.getResourceActivities());
        activities.addAll(Util.filter(this.publishers, ResourceActivity.class));
        activities.addAll(Util.filter(this.buildWrappers, ResourceActivity.class));
        return activities;
    }

    public CauseOfBlockage getCauseOfBlockage() {
        CauseOfBlockage cob = super.getCauseOfBlockage();
        if (cob != null) {
            return cob;
        }
        for (IvyModule module : this.modules.values()) {
            if (!module.isBuilding() && !module.isInQueue()) continue;
            return new BecauseOfModuleBuildInProgress(module);
        }
        return null;
    }

    public AbstractProject<?, ?> asProject() {
        return this;
    }

    public String getRelativePathToDescriptorFromModuleRoot() {
        return this.relativePathToDescriptorFromModuleRoot;
    }

    public void setRelativePathToDescriptorFromModuleRoot(String relativePathToDescriptorFromModuleRoot) {
        this.relativePathToDescriptorFromModuleRoot = relativePathToDescriptorFromModuleRoot;
    }

    public List<Queue.Item> getQueueItems() {
        ArrayList<Queue.Item> r = new ArrayList<Queue.Item>();
        for (Queue.Item item : Hudson.getInstance().getQueue().getItems()) {
            Queue.Task t = item.task;
            if ((!(t instanceof IvyModule) || ((IvyModule)t).getParent() != this) && t != this) continue;
            r.add(item);
        }
        return r;
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.ignoreUpstreamChanges = !json.has("triggerByDependency");
        this.allowedToTriggerDownstream = json.has("allowedToTriggerDownstream");
        this.useUpstreamParameters = json.has("useUpstreamParameters");
        this.ivyFilePattern = Util.fixEmptyAndTrim((String)json.getString("ivyFilePattern"));
        this.ivyFileExcludesPattern = Util.fixEmptyAndTrim((String)json.getString("ivyFileExcludesPattern"));
        this.ivySettingsFile = Util.fixEmptyAndTrim((String)json.getString("ivySettingsFile"));
        this.ivySettingsPropertyFiles = Util.fixEmptyAndTrim((String)json.getString("ivySettingsPropertyFiles"));
        this.ivyBranch = Util.fixEmptyAndTrim((String)json.getString("ivyBranch"));
        this.relativePathToDescriptorFromModuleRoot = Util.fixEmptyAndTrim((String)json.getString("relativePathToDescriptorFromModuleRoot"));
        JSONObject ivyBuilderTypeJson = json.getJSONObject("ivyBuilderType");
        try {
            this.ivyBuilderType = (IvyBuilderType)req.bindJSON(Class.forName(ivyBuilderTypeJson.getString("stapler-class")), ivyBuilderTypeJson);
        }
        catch (ClassNotFoundException e) {
            throw new Descriptor.FormException("Error creating specified builder type.", (Throwable)e, "ivyBuilderType");
        }
        this.aggregatorStyleBuild = !req.hasParameter("perModuleBuild");
        this.incrementalBuild = req.hasParameter("incrementalBuild");
        if (this.incrementalBuild) {
            this.changedModulesProperty = Util.fixEmptyAndTrim((String)json.getJSONObject("incrementalBuild").getString("changedModulesProperty"));
        }
        this.publishers.rebuild(req, json, BuildStepDescriptor.filter((List)Publisher.all(), ((Object)((Object)this)).getClass()));
        this.buildWrappers.rebuild(req, json, BuildWrappers.getFor((AbstractProject)this));
        if (!this.isAggregatorStyleBuild()) {
            for (IvyModule module : this.getModules()) {
                module.getBuildWrappersList().rebuild(req, json, BuildWrappers.getFor((AbstractProject)module));
            }
        }
        this.updateTransientActions();
    }

    public Class<? extends AbstractProject> getModuleClass() {
        return IvyModule.class;
    }

    public void doDoDeleteAllDisabledModules(StaplerResponse rsp) throws IOException, InterruptedException {
        this.checkPermission(DELETE);
        for (IvyModule m : this.getDisabledModules(true)) {
            m.delete();
        }
        rsp.sendRedirect2(".");
    }

    public FormValidation doCheckFileInWorkspace(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        IvyModuleSetBuild lb = (IvyModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getModuleRoot()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckIvySettingsFile(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        String v = Util.fixEmpty((String)value);
        if (v == null || v.length() == 0) {
            return FormValidation.ok();
        }
        if (v.startsWith("/") || v.startsWith("\\") || v.matches("^\\w\\:\\\\.*")) {
            return FormValidation.error((String)"Ivy settings file must be a relative path.");
        }
        IvyModuleSetBuild lb = (IvyModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getWorkspace()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public ArrayList<Descriptor<IvyBuilderType>> getBuilderTypeDescriptors() {
        ArrayList<Descriptor<IvyBuilderType>> buildTypeDescriptors = new ArrayList<Descriptor<IvyBuilderType>>();
        buildTypeDescriptors.add(Hudson.getInstance().getDescriptor(AntIvyBuilderType.class));
        if (Hudson.getInstance().getPlugin("nant") != null) {
            buildTypeDescriptors.add((Descriptor<IvyBuilderType>)Hudson.getInstance().getDescriptor(NAntIvyBuilderType.class));
        }
        return buildTypeDescriptors;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    protected Object readResolve() {
        if (this.ivyBuilderType == null) {
            this.ivyBuilderType = new AntIvyBuilderType(this.antName, this.buildFile, this.targets, this.antProperties, this.antOpts);
            this.antName = null;
            this.buildFile = null;
            this.targets = null;
            this.antProperties = null;
            this.antOpts = null;
        }
        if (this.allowedToTriggerDownstream == null) {
            this.allowedToTriggerDownstream = true;
        }
        return this;
    }

    public static final class DescriptorImpl
    extends AbstractProject.AbstractProjectDescriptor {
        private String globalAntOpts;

        public DescriptorImpl() {
            this.load();
        }

        public String getGlobalAntOpts() {
            return this.globalAntOpts;
        }

        public void setGlobalAntOpts(String globalAntOpts) {
            this.globalAntOpts = globalAntOpts;
            this.save();
        }

        public String getDisplayName() {
            return Messages.IvyModuleSet_DiplayName();
        }

        public IvyModuleSet newInstance(String name) {
            return new IvyModuleSet(name);
        }

        public boolean configure(StaplerRequest req, JSONObject o) {
            this.globalAntOpts = Util.fixEmptyAndTrim((String)o.getString("globalAntOpts"));
            this.save();
            return true;
        }
    }

    public static class BecauseOfModuleBuildInProgress
    extends CauseOfBlockage {
        public final IvyModule module;

        public BecauseOfModuleBuildInProgress(IvyModule module) {
            this.module = module;
        }

        public String getShortDescription() {
            return Messages.IvyModuleSet_ModuleBuildInProgress(this.module.getName());
        }
    }
}

