/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.ivy.AbstractIvyProject;
import hudson.ivy.IvyAggregatedReport;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleSet;
import hudson.ivy.IvyModuleSetBuild;
import hudson.ivy.IvyReporter;
import hudson.ivy.ModuleName;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.ResourceActivity;
import hudson.model.SCMedItem;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.queue.CauseOfBlockage;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Function1;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IvyModuleSet
extends AbstractIvyProject<IvyModuleSet, IvyModuleSetBuild>
implements TopLevelItem,
ItemGroup<IvyModule>,
SCMedItem,
Saveable,
BuildableItemWithBuildWrappers {
    transient Map<ModuleName, IvyModule> modules = new CopyOnWriteMap.Tree();
    transient List<IvyModule> sortedActiveModules;
    private String ivyFilePattern;
    private String ivyFileExcludesPattern;
    private String targets;
    private String ivyBranch;
    private String relativePathToDescriptorFromModuleRoot;
    private String antName;
    private String antOpts;
    private String buildFile;
    private String antProperties;
    private boolean aggregatorStyleBuild = true;
    private boolean incrementalBuild = false;
    private String changedModulesProperty;
    private boolean ignoreUpstreamChanges = false;
    private boolean archivingDisabled = false;
    private DescribableList<Publisher, Descriptor<Publisher>> publishers = new DescribableList((Saveable)this);
    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers = new DescribableList((Saveable)this);
    @Extension(ordinal=890.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public IvyModuleSet(String name) {
        super((ItemGroup)Hudson.getInstance(), name);
    }

    public String getUrlChildPrefix() {
        return ".";
    }

    public Hudson getParent() {
        return Hudson.getInstance();
    }

    public Collection<IvyModule> getItems() {
        return this.modules.values();
    }

    @Exported
    public Collection<IvyModule> getModules() {
        return this.getItems();
    }

    public IvyModule getItem(String name) {
        return (IvyModule)this.modules.get(ModuleName.fromString((String)name));
    }

    public IvyModule getModule(String name) {
        return this.getItem(name);
    }

    protected void updateTransientActions() {
        Collection a;
        super.updateTransientActions();
        for (IvyModule module : this.modules.values()) {
            module.updateTransientActions();
        }
        if (this.publishers != null) {
            for (Publisher step : this.publishers) {
                a = step.getProjectActions((AbstractProject)this);
                if (a == null) continue;
                this.transientActions.addAll(a);
            }
        }
        if (this.buildWrappers != null) {
            for (Publisher step : this.buildWrappers) {
                a = step.getProjectActions((AbstractProject)this);
                if (a == null) continue;
                this.transientActions.addAll(a);
            }
        }
    }

    protected void addTransientActionsFromBuild(IvyModuleSetBuild build, Set<Class> added) {
        if (build == null) {
            return;
        }
        for (Action a : build.getActions()) {
            if (!(a instanceof IvyAggregatedReport) || !added.add(a.getClass())) continue;
            this.transientActions.add(((IvyAggregatedReport)a).getProjectAction(this));
        }
        List list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (IvyReporter step : list) {
            Action a;
            if (!added.add(step.getClass()) || (a = step.getAggregatedProjectAction(this)) == null) continue;
            this.transientActions.add(a);
        }
    }

    void onModuleDeleted(IvyModule module) {
        this.modules.remove(module.getModuleName());
    }

    public boolean hasDisabledModule() {
        for (IvyModule m : this.modules.values()) {
            if (!m.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public List<IvyModule> getDisabledModules(boolean disabled) {
        if (!disabled && this.sortedActiveModules != null) {
            return this.sortedActiveModules;
        }
        ArrayList<IvyModule> r = new ArrayList<IvyModule>();
        for (IvyModule m : this.modules.values()) {
            if (m.isDisabled() != disabled) continue;
            r.add(m);
        }
        return r;
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public String getChangedModulesProperty() {
        return this.changedModulesProperty;
    }

    public boolean isAggregatorStyleBuild() {
        return this.aggregatorStyleBuild;
    }

    public boolean ignoreUpstreamChanges() {
        return this.ignoreUpstreamChanges;
    }

    public boolean isArchivingDisabled() {
        return this.archivingDisabled;
    }

    public void setIncrementalBuild(boolean incrementalBuild) {
        this.incrementalBuild = incrementalBuild;
    }

    public String getIvyFilePattern() {
        return this.ivyFilePattern;
    }

    public void setIvyFilePattern(String ivyFilePattern) {
        this.ivyFilePattern = ivyFilePattern;
    }

    public String getIvyFileExcludesPattern() {
        return this.ivyFileExcludesPattern;
    }

    public void setIvyFileExcludesPattern(String ivyFileExcludesPattern) {
        this.ivyFileExcludesPattern = ivyFileExcludesPattern;
    }

    public String getIvyBranch() {
        return this.ivyBranch;
    }

    public void setIvyBranch(String ivyBranch) {
        this.ivyBranch = ivyBranch;
    }

    public void setAggregatorStyleBuild(boolean aggregatorStyleBuild) {
        this.aggregatorStyleBuild = aggregatorStyleBuild;
    }

    public void setIgnoreUpstremChanges(boolean ignoreUpstremChanges) {
        this.ignoreUpstreamChanges = ignoreUpstremChanges;
    }

    public void setIsArchivingDisabled(boolean archivingDisabled) {
        this.archivingDisabled = archivingDisabled;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getModulePublishers() {
        return this.aggregatorStyleBuild ? new DescribableList((Saveable)this) : this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishers() {
        return this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.publishers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.buildWrappers;
    }

    @Deprecated
    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappers() {
        return this.buildWrappers;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (ModuleName.isValid((String)token)) {
            return this.getModule(token);
        }
        return super.getDynamic(token, req, rsp);
    }

    public File getRootDirFor(IvyModule child) {
        return new File(this.getModulesDir(), child.getModuleName().toFileSystemName());
    }

    public Collection<Job> getAllJobs() {
        HashSet<Job> jobs = new HashSet<Job>(this.getItems());
        jobs.add((Job)this);
        return jobs;
    }

    protected Class<IvyModuleSetBuild> getBuildClass() {
        return IvyModuleSetBuild.class;
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isFingerprintConfigured() {
        return true;
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.modules = Collections.emptyMap();
        super.onLoad(parent, name);
        this.modules = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getModulesDir(), (Function1)new /* Unavailable Anonymous Inner Class!! */);
        if (this.publishers == null) {
            this.publishers = new DescribableList((Saveable)this);
        }
        this.publishers.setOwner((Saveable)this);
        if (this.buildWrappers == null) {
            this.buildWrappers = new DescribableList((Saveable)this);
        }
        this.buildWrappers.setOwner((Saveable)this);
        this.updateTransientActions();
    }

    private File getModulesDir() {
        return new File(this.getRootDir(), "modules");
    }

    public synchronized int assignBuildNumber() throws IOException {
        this.updateNextBuildNumber();
        return super.assignBuildNumber();
    }

    public void logRotate() throws IOException, InterruptedException {
        super.logRotate();
        for (IvyModule m : this.modules.values()) {
            m.logRotate();
        }
    }

    void updateNextBuildNumber() throws IOException {
        int next = this.nextBuildNumber;
        for (IvyModule m : this.modules.values()) {
            next = Math.max(next, m.getNextBuildNumber());
        }
        if (this.nextBuildNumber != next) {
            this.nextBuildNumber = next;
            this.saveNextBuildNumber();
        }
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        this.publishers.buildDependencyGraph((AbstractProject)this, graph);
        this.buildWrappers.buildDependencyGraph((AbstractProject)this, graph);
    }

    protected Set<ResourceActivity> getResourceActivities() {
        HashSet<ResourceActivity> activities = new HashSet<ResourceActivity>();
        activities.addAll(super.getResourceActivities());
        activities.addAll(Util.filter((Iterable)this.publishers, ResourceActivity.class));
        activities.addAll(Util.filter((Iterable)this.buildWrappers, ResourceActivity.class));
        return activities;
    }

    public CauseOfBlockage getCauseOfBlockage() {
        CauseOfBlockage cob = super.getCauseOfBlockage();
        if (cob != null) {
            return cob;
        }
        for (IvyModule module : this.modules.values()) {
            if (!module.isBuilding() && !module.isInQueue()) continue;
            return new BecauseOfModuleBuildInProgress(module);
        }
        return null;
    }

    public AbstractProject<?, ?> asProject() {
        return this;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public String getRelativePathToDescriptorFromModuleRoot() {
        return this.relativePathToDescriptorFromModuleRoot;
    }

    public void setRelativePathToDescriptorFromModuleRoot(String relativePathToDescriptorFromModuleRoot) {
        this.relativePathToDescriptorFromModuleRoot = relativePathToDescriptorFromModuleRoot;
    }

    public String getAntOpts() {
        if (this.antOpts != null && this.antOpts.trim().length() > 0) {
            return this.antOpts.replaceAll("[\t\r\n]+", " ");
        }
        String globalOpts = DESCRIPTOR.getGlobalAntOpts();
        if (globalOpts != null) {
            return globalOpts.replaceAll("[\t\r\n]+", " ");
        }
        return globalOpts;
    }

    public void setAntOpts(String antOpts) {
        this.antOpts = antOpts;
    }

    public String getUserConfiguredAntOpts() {
        return this.antOpts;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getAntProperties() {
        return this.antProperties;
    }

    public String getAnt() {
        return this.antName;
    }

    public void setAnt(String antName) {
        this.antName = antName;
    }

    public List<Queue.Item> getQueueItems() {
        ArrayList<Queue.Item> r = new ArrayList<Queue.Item>();
        for (Queue.Item item : Hudson.getInstance().getQueue().getItems()) {
            Queue.Task t = item.task;
            if ((!(t instanceof IvyModule) || ((IvyModule)t).getParent() != this) && t != this) continue;
            r.add(item);
        }
        return r;
    }

    public String getUserConfiguredTargets() {
        return this.targets;
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.ignoreUpstreamChanges = !json.has("triggerByDependency");
        this.ivyFilePattern = Util.fixEmptyAndTrim((String)json.getString("ivyFilePattern"));
        this.ivyFileExcludesPattern = Util.fixEmptyAndTrim((String)json.getString("ivyFileExcludesPattern"));
        this.targets = json.getString("targets").trim();
        this.ivyBranch = Util.fixEmptyAndTrim((String)json.getString("ivyBranch"));
        this.relativePathToDescriptorFromModuleRoot = Util.fixEmptyAndTrim((String)json.getString("relativePathToDescriptorFromModuleRoot"));
        this.antName = json.has("antName") ? Util.fixEmptyAndTrim((String)json.getString("antName")) : null;
        this.buildFile = Util.fixEmptyAndTrim((String)json.getString("buildFile"));
        this.antOpts = Util.fixEmptyAndTrim((String)json.getString("antOpts"));
        this.antProperties = Util.fixEmptyAndTrim((String)json.getString("antProperties"));
        this.aggregatorStyleBuild = !req.hasParameter("perModuleBuild");
        this.incrementalBuild = req.hasParameter("incrementalBuild");
        if (this.incrementalBuild) {
            this.changedModulesProperty = Util.fixEmptyAndTrim((String)json.getJSONObject("incrementalBuild").getString("changedModulesProperty"));
        }
        this.publishers.rebuild(req, json, BuildStepDescriptor.filter((List)Publisher.all(), this.getClass()));
        this.buildWrappers.rebuild(req, json, BuildWrappers.getFor((AbstractProject)this));
        this.updateTransientActions();
    }

    public Class<? extends AbstractProject> getModuleClass() {
        return IvyModule.class;
    }

    public void doDoDeleteAllDisabledModules(StaplerResponse rsp) throws IOException, InterruptedException {
        this.checkPermission(DELETE);
        for (IvyModule m : this.getDisabledModules(true)) {
            m.delete();
        }
        rsp.sendRedirect2(".");
    }

    public FormValidation doCheckFileInWorkspace(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        IvyModuleSetBuild lb = (IvyModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getModuleRoot()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckFileRelative(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        String v = Util.fixEmpty((String)value);
        if (v == null || v.length() == 0) {
            return FormValidation.ok();
        }
        if (v.startsWith("/") || v.startsWith("\\") || v.matches("^\\w\\:\\\\.*")) {
            return FormValidation.error((String)"Alternate settings file must be a relative path.");
        }
        IvyModuleSetBuild lb = (IvyModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getModuleRoot()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }
}

