/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.ivy.AbstractIvyBuild;
import hudson.ivy.AggregatableAction;
import hudson.ivy.IvyAggregatedReport;
import hudson.ivy.IvyBuild;
import hudson.ivy.IvyBuildProxy;
import hudson.ivy.IvyBuildProxy2;
import hudson.ivy.IvyBuilder;
import hudson.ivy.IvyMessageImpl;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleInfo;
import hudson.ivy.IvyModuleSet;
import hudson.ivy.IvyReporter;
import hudson.ivy.Messages;
import hudson.ivy.ModuleName;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Environment;
import hudson.model.Fingerprint;
import hudson.model.Hudson;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Ant;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Publisher;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyModuleSetBuild
extends AbstractIvyBuild<IvyModuleSet, IvyModuleSetBuild> {
    List<IvyReporter> projectActionReporters;
    private static final Logger LOGGER = Logger.getLogger(IvyModuleSetBuild.class.getName());
    public static boolean debug = false;

    public IvyModuleSetBuild(IvyModuleSet job) throws IOException {
        super(job);
    }

    public IvyModuleSetBuild(IvyModuleSet project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        String opts = ((IvyModuleSet)this.project).getAntOpts();
        if (opts != null) {
            envs.put((Object)"ANT_OPTS", (Object)opts);
        }
        return envs;
    }

    public Result getResult() {
        Result r = super.getResult();
        for (IvyBuild b : this.getModuleLastBuilds().values()) {
            Result br = b.getResult();
            if (r == null) {
                r = br;
                continue;
            }
            if (br == Result.NOT_BUILT || br == null) continue;
            r = r.combine(br);
        }
        return r;
    }

    List<ChangeLogSet.Entry> getChangeSetFor(final IvyModule mod) {
        return new ArrayList<ChangeLogSet.Entry>(){
            {
                for (ChangeLogSet.Entry e : IvyModuleSetBuild.this.getChangeSet()) {
                    if (!this.isDescendantOf(e, mod)) continue;
                    this.add(e);
                }
            }

            private boolean isDescendantOf(ChangeLogSet.Entry e, IvyModule mod2) {
                for (String path : e.getAffectedPaths()) {
                    if (!path.startsWith(mod2.getRelativePathToModuleRoot())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Map<IvyModule, List<IvyBuild>> getModuleBuilds() {
        Collection<IvyModule> mods = this.getParent().getModules();
        IvyModuleSetBuild nb = (IvyModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<IvyModule, List<IvyBuild>> r = new LinkedHashMap<IvyModule, List<IvyBuild>>(mods.size());
        for (IvyModule m : mods) {
            ArrayList<IvyBuild> builds = new ArrayList<IvyBuild>();
            for (IvyBuild b = (IvyBuild)m.getNearestBuild(this.number); b != null && b.getNumber() < end; b = (IvyBuild)b.getNextBuild()) {
                builds.add(b);
            }
            r.put(m, builds);
        }
        return r;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        IvyModule m;
        if (token.indexOf(36) > 0 && (m = ((IvyModuleSet)this.getProject()).getModule(token)) != null) {
            return m.getBuildByNumber(this.getNumber());
        }
        return super.getDynamic(token, req, rsp);
    }

    public Map<IvyModule, IvyBuild> getModuleLastBuilds() {
        Collection<IvyModule> mods = this.getParent().getModules();
        IvyModuleSetBuild nb = (IvyModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<IvyModule, IvyBuild> r = new LinkedHashMap<IvyModule, IvyBuild>(mods.size());
        for (IvyModule m : mods) {
            IvyBuild b = (IvyBuild)m.getNearestOldBuild(end - 1);
            if (b == null || b.getNumber() < this.getNumber()) continue;
            r.put(m, b);
        }
        return r;
    }

    public void registerAsProjectAction(IvyReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<IvyReporter>();
        }
        this.projectActionReporters.add(reporter);
    }

    public <T extends Action> List<T> findModuleBuildActions(Class<T> action) {
        Collection<IvyModule> mods = this.getParent().getModules();
        ArrayList<Action> r = new ArrayList<Action>(mods.size());
        IvyModuleSetBuild nb = (IvyModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() - 1 : Integer.MAX_VALUE;
        block0: for (IvyModule m : mods) {
            for (IvyBuild b = (IvyBuild)m.getNearestOldBuild(end); b != null && b.getNumber() >= this.number; b = (IvyBuild)b.getPreviousBuild()) {
                Action a = b.getAction(action);
                if (a == null) continue;
                r.add(a);
                continue block0;
            }
        }
        return r;
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl());
        ((IvyModuleSet)this.getProject()).updateTransientActions();
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        Fingerprint.RangeSet rs = super.getDownstreamRelationship(that);
        for (List<IvyBuild> builds : this.getModuleBuilds().values()) {
            for (IvyBuild b : builds) {
                rs.add(b.getDownstreamRelationship(that));
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyModuleBuild(IvyBuild newBuild) {
        try {
            this.getParent().updateNextBuildNumber();
            Map<IvyModule, List<IvyBuild>> moduleBuilds = this.getModuleBuilds();
            IvyModuleSetBuild ivyModuleSetBuild = this;
            synchronized (ivyModuleSetBuild) {
                IvyAggregatedReport mar;
                boolean modified = false;
                List actions = this.getActions();
                HashSet individuals = new HashSet();
                for (Action a : actions) {
                    if (!(a instanceof IvyAggregatedReport)) continue;
                    mar = (IvyAggregatedReport)a;
                    mar.update(moduleBuilds, newBuild);
                    individuals.add(mar.getIndividualActionType());
                    modified = true;
                }
                for (AggregatableAction aa : newBuild.getActions(AggregatableAction.class)) {
                    if (!individuals.add(aa.getClass())) continue;
                    mar = aa.createAggregatedAction(this, moduleBuilds);
                    mar.update(moduleBuilds, newBuild);
                    actions.add(mar);
                    modified = true;
                }
                if (modified) {
                    this.save();
                    ((IvyModuleSet)this.getProject()).updateTransientActions();
                }
            }
            String moduleFsName = ((IvyModule)newBuild.getProject()).getModuleName().toFileSystemName();
            Util.createSymlink((File)this.getRootDir(), (String)("../../modules/" + moduleFsName + "/builds/" + newBuild.getId()), (String)moduleFsName, (TaskListener)new StreamTaskListener());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
    }

    public IvyModuleSet getParent() {
        return (IvyModuleSet)super.getParent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IvyPreloadTask
    implements Callable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;

        private IvyPreloadTask() {
        }

        public Boolean call() throws IOException {
            try {
                return Channel.current().preloadJar((Callable)this, new Class[]{Ivy.class});
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IvyXmlParser
    implements Callable<List<IvyModuleInfo>, Throwable> {
        private static final String IVY_XML_PATTERN = "**/ivy.xml";
        private final BuildListener listener;
        private final boolean verbose = debug;
        private final String ivyFilePattern;
        private final String ivyFileExcludePattern;
        private final String ivyBranch;
        private final String workspace;
        private static final long serialVersionUID = 1L;

        public IvyXmlParser(BuildListener listener, IvyModuleSet project, String workspace) {
            this.listener = listener;
            this.ivyFilePattern = project.getIvyFilePattern() == null ? IVY_XML_PATTERN : project.getIvyFilePattern();
            this.ivyFileExcludePattern = project.getIvyFileExcludesPattern();
            this.ivyBranch = project.getIvyBranch();
            this.workspace = workspace;
        }

        public List<IvyModuleInfo> call() throws Throwable {
            File ws = new File(this.workspace);
            FileSet ivyFiles = Util.createFileSet((File)ws, (String)this.ivyFilePattern, (String)this.ivyFileExcludePattern);
            final PrintStream logger = this.listener.getLogger();
            Ivy ivy = this.getIvy(logger);
            HashMap<ModuleDescriptor, String> moduleDescriptors = new HashMap<ModuleDescriptor, String>();
            for (String ivyFilePath : ivyFiles.getDirectoryScanner().getIncludedFiles()) {
                final File ivyFile = new File(ws, ivyFilePath);
                ModuleDescriptor module = (ModuleDescriptor)ivy.execute(new Ivy.IvyCallback(){

                    public Object doInIvyContext(Ivy ivy, IvyContext context) {
                        try {
                            return ModuleDescriptorParserRegistry.getInstance().parseDescriptor((ParserSettings)ivy.getSettings(), ivyFile.toURI().toURL(), ivy.getSettings().doValidate());
                        }
                        catch (MalformedURLException e) {
                            logger.println("The URL is malformed : " + ivyFile);
                            return null;
                        }
                        catch (ParseException e) {
                            logger.println("Parsing error while reading the ivy file " + ivyFile);
                            return null;
                        }
                        catch (IOException e) {
                            logger.println("I/O error while reading the ivy file " + ivyFile);
                            return null;
                        }
                    }
                });
                moduleDescriptors.put(module, ivyFilePath);
            }
            ArrayList<IvyModuleInfo> infos = new ArrayList<IvyModuleInfo>();
            List sortedModuleDescriptors = ivy.sortModuleDescriptors(moduleDescriptors.keySet(), SortOptions.DEFAULT);
            for (ModuleDescriptor moduleDescriptor : sortedModuleDescriptors) {
                infos.add(new IvyModuleInfo(moduleDescriptor, (String)moduleDescriptors.get(moduleDescriptor)));
            }
            if (this.verbose) {
                for (IvyModuleInfo moduleInfo : infos) {
                    logger.printf("Discovered module %s at %s.\n", moduleInfo.displayName, moduleInfo.relativePathToDescriptor);
                }
            }
            return infos;
        }

        public Ivy getIvy(PrintStream logger) {
            Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
            Ivy ivy = Ivy.newInstance();
            Ivy configured = null;
            try {
                ivy.configureDefault();
                if (this.verbose) {
                    logger.println("Configured Ivy using default 2.1 settings");
                }
                if (this.ivyBranch != null) {
                    ivy.getSettings().setDefaultBranch(this.ivyBranch);
                }
                configured = ivy;
            }
            catch (Exception e) {
                logger.println("Error while reading the default Ivy 2.1 settings: " + e.getMessage());
                logger.println(e.getStackTrace());
            }
            return configured;
        }
    }

    private static final class AntExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AntExecutionException(Exception cause) {
            super(cause);
        }

        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Builder
    extends IvyBuilder {
        private final Map<ModuleName, IvyBuildProxy2> proxies;
        private final Map<ModuleName, List<Publisher>> modulePublishers = new HashMap<ModuleName, List<Publisher>>();
        private IvyBuildProxy2 lastProxy;
        private final transient Map<ModuleName, IvyBuild.ProxyImpl2> sourceProxies;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, Map<ModuleName, IvyBuild.ProxyImpl2> proxies, Collection<IvyModule> modules, List<String> goals, Map<String, String> systemProps) {
            super(listener, goals, systemProps);
            this.sourceProxies = proxies;
            this.proxies = new HashMap<ModuleName, IvyBuild.ProxyImpl2>(proxies);
            for (Map.Entry<ModuleName, IvyBuildProxy2> e : this.proxies.entrySet()) {
                e.setValue(new FilterImpl(e.getValue()));
            }
            for (IvyModule m : modules) {
                this.modulePublishers.put(m.getModuleName(), m.createModulePublishers());
            }
        }

        void end(Launcher launcher) throws IOException, InterruptedException {
            for (Map.Entry<ModuleName, IvyBuild.ProxyImpl2> e : this.sourceProxies.entrySet()) {
                IvyBuild.ProxyImpl2 p = e.getValue();
                for (Publisher publisher : this.modulePublishers.get(e.getKey())) {
                    publisher.perform((AbstractBuild)p.owner(), launcher, this.listener);
                    p.appendLastLog();
                }
                p.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result call() throws IOException {
            try {
                Result result = super.call();
                return result;
            }
            finally {
                if (this.lastProxy != null) {
                    this.lastProxy.appendLastLog();
                }
            }
        }

        @Override
        void preBuild(BuildEvent event) throws IOException, InterruptedException {
        }

        @Override
        void postBuild(BuildEvent event) throws IOException, InterruptedException {
        }

        @Override
        void preModule(BuildEvent event) throws InterruptedException, IOException, AbortException {
            File baseDir = event.getProject().getBaseDir();
        }

        @Override
        void postModule(BuildEvent event) throws InterruptedException, IOException, AbortException {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FilterImpl
        extends IvyBuildProxy2.Filter<IvyBuildProxy2>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public FilterImpl(IvyBuildProxy2 core) {
                super(core);
            }

            @Override
            public void executeAsync(IvyBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.futures.add(Channel.current().callAsync((Callable)new IvyBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }
        }
    }

    private class RunnerImpl
    extends AbstractBuild.AbstractRunner {
        private Map<ModuleName, IvyBuild.ProxyImpl2> proxies;

        private RunnerImpl() {
            super((AbstractBuild)IvyModuleSetBuild.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Result doRun(BuildListener listener) throws Exception {
            PrintStream logger = listener.getLogger();
            try {
                EnvVars envVars = IvyModuleSetBuild.this.getEnvironment((TaskListener)listener);
                this.parseIvyDescriptorFiles(listener, logger, envVars);
                if (!((IvyModuleSet)IvyModuleSetBuild.this.project).isAggregatorStyleBuild()) {
                    DependencyGraph graph = Hudson.getInstance().getDependencyGraph();
                    HashSet<IvyModule> triggeredModules = new HashSet<IvyModule>();
                    if (!((IvyModuleSet)IvyModuleSetBuild.this.project).isIncrementalBuild() || IvyModuleSetBuild.this.getChangeSet().isEmptySet()) {
                        Iterator<IvyModule> i$ = ((IvyModuleSet)((IvyModuleSetBuild)IvyModuleSetBuild.this).project).sortedActiveModules.iterator();
                        while (i$.hasNext()) {
                            IvyModule module = i$.next();
                            List ups = module.getUpstreamProjects();
                            boolean triggerBuild = true;
                            for (AbstractProject upstreamDep : ups) {
                                if (!triggeredModules.contains(upstreamDep)) continue;
                                triggerBuild = false;
                                break;
                            }
                            if (triggerBuild) {
                                logger.println("Triggering " + module.getModuleName());
                                module.scheduleBuild((Cause)new Cause.UpstreamCause((Run)IvyModuleSetBuild.this));
                            }
                            triggeredModules.add(module);
                        }
                        return null;
                    }
                    Iterator<IvyModule> i$ = ((IvyModuleSet)((IvyModuleSetBuild)IvyModuleSetBuild.this).project).sortedActiveModules.iterator();
                    while (i$.hasNext()) {
                        IvyModule module = i$.next();
                        boolean triggerBuild = false;
                        if (module.getLastBuild() == null || !IvyModuleSetBuild.this.getChangeSetFor(module).isEmpty() || ((IvyBuild)module.getLastBuild()).getResult().isWorseThan(Result.SUCCESS)) {
                            triggerBuild = true;
                            List ups = module.getUpstreamProjects();
                            for (AbstractProject upstreamDep : ups) {
                                if (!triggeredModules.contains(upstreamDep)) continue;
                                triggerBuild = false;
                                triggeredModules.add(module);
                                break;
                            }
                        }
                        if (!triggerBuild) continue;
                        logger.println("Triggering " + module.getModuleName());
                        module.scheduleBuild((Cause)new Cause.UpstreamCause((Run)IvyModuleSetBuild.this));
                        triggeredModules.add(module);
                    }
                    return null;
                }
                try {
                    Ant ant;
                    ArrayList<BuildWrapper> wrappers = new ArrayList<BuildWrapper>();
                    for (BuildWrapper w : ((IvyModuleSet)IvyModuleSetBuild.this.project).getBuildWrappersList()) {
                        wrappers.add(w);
                    }
                    ParametersAction parameters = (ParametersAction)IvyModuleSetBuild.this.getAction(ParametersAction.class);
                    if (parameters != null) {
                        parameters.createBuildWrappers((AbstractBuild)IvyModuleSetBuild.this, wrappers);
                    }
                    for (BuildWrapper w : wrappers) {
                        BuildWrapper.Environment e = w.setUp((AbstractBuild)IvyModuleSetBuild.this, this.launcher, listener);
                        if (e == null) {
                            Result result = Result.FAILURE;
                            return result;
                        }
                        IvyModuleSetBuild.this.buildEnvironments.add(e);
                        e.buildEnvVars((Map)envVars);
                    }
                    if (!this.preBuild(listener, (Iterable)((IvyModuleSet)IvyModuleSetBuild.this.project).getPublishers())) {
                        Result i$ = Result.FAILURE;
                        return i$;
                    }
                    ArrayList<String> changedModules = new ArrayList<String>();
                    for (IvyModule m : ((IvyModuleSet)((IvyModuleSetBuild)IvyModuleSetBuild.this).project).sortedActiveModules) {
                        if (IvyModuleSetBuild.this.getChangeSet().isEmptySet() || !((IvyModuleSet)IvyModuleSetBuild.this.project).isIncrementalBuild() || IvyModuleSetBuild.this.getChangeSetFor(m).isEmpty()) continue;
                        changedModules.add(m.getModuleName().name);
                    }
                    StringBuilder antProperties = new StringBuilder();
                    if (((IvyModuleSet)IvyModuleSetBuild.this.project).getAntProperties() != null) {
                        antProperties.append(((IvyModuleSet)IvyModuleSetBuild.this.project).getAntProperties()).append("\n");
                    }
                    if (((IvyModuleSet)IvyModuleSetBuild.this.project).isAggregatorStyleBuild() && ((IvyModuleSet)IvyModuleSetBuild.this.project).isIncrementalBuild()) {
                        antProperties.append(((IvyModuleSet)IvyModuleSetBuild.this.project).getChangedModulesProperty() == null ? "hudson.ivy.changedModules" : ((IvyModuleSet)IvyModuleSetBuild.this.project).getChangedModulesProperty());
                        antProperties.append("=").append(StringUtils.join(changedModules, (char)','));
                    }
                    if ((ant = new Ant(((IvyModuleSet)IvyModuleSetBuild.this.getProject()).getTargets(), ((IvyModuleSet)IvyModuleSetBuild.this.project).getAnt(), ((IvyModuleSet)IvyModuleSetBuild.this.project).getAntOpts(), ((IvyModuleSet)IvyModuleSetBuild.this.project).getBuildFile(), antProperties.length() == 0 ? null : antProperties.toString())).perform((AbstractBuild)IvyModuleSetBuild.this, this.launcher, listener)) {
                        Result result = Result.SUCCESS;
                        return result;
                    }
                    Result result = Result.FAILURE;
                    return result;
                }
                finally {
                    boolean failed = false;
                    for (int i = IvyModuleSetBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                        if (((Environment)IvyModuleSetBuild.this.buildEnvironments.get(i)).tearDown((AbstractBuild)IvyModuleSetBuild.this, listener)) continue;
                        failed = true;
                    }
                    IvyModuleSetBuild.this.buildEnvironments = null;
                    if (failed) {
                        return Result.FAILURE;
                    }
                }
            }
            catch (AbortException e) {
                if (e.getMessage() == null) return Result.FAILURE;
                listener.error(e.getMessage());
                return Result.FAILURE;
            }
            catch (InterruptedIOException e) {
                e.printStackTrace(listener.error("Aborted Ivy execution for InterruptedIOException"));
                return Result.ABORTED;
            }
            catch (InterruptedException e) {
                e.printStackTrace(listener.error("Aborted Ivy execution for InterruptedException"));
                return Result.ABORTED;
            }
            catch (IOException e) {
                e.printStackTrace(listener.error(Messages.IvyModuleSetBuild_FailedToParseIvyXml()));
                return Result.FAILURE;
            }
            catch (Run.RunnerAbortedException e) {
                return Result.FAILURE;
            }
            catch (RuntimeException e) {
                e.printStackTrace(listener.error("Processing failed due to a bug in the code. Please report this to users@hudson.dev.java.net"));
                logger.println("project=" + IvyModuleSetBuild.this.project);
                logger.println("project.getModules()=" + ((IvyModuleSet)IvyModuleSetBuild.this.project).getModules());
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseIvyDescriptorFiles(BuildListener listener, PrintStream logger, EnvVars envVars) throws IOException, InterruptedException {
            Map<ModuleName, IvyModule> modules;
            List ivyDescriptors;
            logger.println("Parsing Ivy Descriptor Files");
            try {
                IvyXmlParser parser = new IvyXmlParser(listener, (IvyModuleSet)IvyModuleSetBuild.this.project, IvyModuleSetBuild.this.getModuleRoot().getRemote());
                if (IvyModuleSetBuild.this.getModuleRoot().getChannel() instanceof Channel) {
                    ((Channel)IvyModuleSetBuild.this.getModuleRoot().getChannel()).preloadJar((Callable)parser, new Class[]{Ivy.class});
                }
                ivyDescriptors = (List)IvyModuleSetBuild.this.getModuleRoot().act((Callable)parser);
            }
            catch (IOException e) {
                if (e.getCause() instanceof AbortException) {
                    throw (AbortException)e.getCause();
                }
                throw e;
            }
            catch (Throwable e) {
                throw new IOException("Unable to parse ivy descriptors", e);
            }
            Map<ModuleName, IvyModule> map = modules = ((IvyModuleSet)((IvyModuleSetBuild)IvyModuleSetBuild.this).project).modules;
            synchronized (map) {
                HashMap<ModuleName, IvyModule> old = new HashMap<ModuleName, IvyModule>(modules);
                ArrayList<IvyModule> sortedModules = new ArrayList<IvyModule>();
                modules.clear();
                for (IvyModuleInfo ivyDescriptor : ivyDescriptors) {
                    IvyModule mm = (IvyModule)((Object)old.get(ivyDescriptor.name));
                    if (mm != null) {
                        if (debug) {
                            logger.println("Reconfiguring " + (Object)((Object)mm));
                        }
                        mm.reconfigure(ivyDescriptor);
                        modules.put(ivyDescriptor.name, mm);
                    } else {
                        logger.println(Messages.IvyModuleSetBuild_DiscoveredModule(ivyDescriptor.name, ivyDescriptor.displayName));
                        mm = new IvyModule((IvyModuleSet)IvyModuleSetBuild.this.project, ivyDescriptor, IvyModuleSetBuild.this.getNumber());
                        modules.put(mm.getModuleName(), mm);
                    }
                    sortedModules.add(mm);
                    mm.save();
                }
                ((IvyModuleSet)((IvyModuleSetBuild)IvyModuleSetBuild.this).project).sortedActiveModules = sortedModules;
                old.keySet().removeAll(modules.keySet());
                for (IvyModule om : old.values()) {
                    if (debug) {
                        logger.println("Disabling " + (Object)((Object)om));
                    }
                    om.makeDisabled(true);
                }
                modules.putAll(old);
            }
            Hudson.getInstance().rebuildDependencyGraph();
            for (IvyModule m : modules.values()) {
                m.updateNextBuildNumber(IvyModuleSetBuild.this.getNumber());
            }
        }

        protected void post2(BuildListener listener) throws Exception {
            if (((IvyModuleSet)IvyModuleSetBuild.this.project).isAggregatorStyleBuild()) {
                this.performAllBuildStep(listener, (Iterable)((IvyModuleSet)IvyModuleSetBuild.this.project).getPublishers(), true);
            }
            this.performAllBuildStep(listener, ((IvyModuleSet)IvyModuleSetBuild.this.project).getProperties(), true);
        }

        public void cleanUp(BuildListener listener) throws Exception {
            if (((IvyModuleSet)IvyModuleSetBuild.this.project).isAggregatorStyleBuild()) {
                IvyModuleSetBuild.this.scheduleDownstreamBuilds(listener);
                this.performAllBuildStep(listener, (Iterable)((IvyModuleSet)IvyModuleSetBuild.this.project).getPublishers(), false);
            }
            this.performAllBuildStep(listener, ((IvyModuleSet)IvyModuleSetBuild.this.project).getProperties(), false);
        }
    }
}

