/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.AbortException;
import hudson.FilePath;
import hudson.ivy.AbstractIvyBuild;
import hudson.ivy.FilteredChangeLogSet;
import hudson.ivy.IvyBuildProxy;
import hudson.ivy.IvyBuildProxy2;
import hudson.ivy.IvyBuilder;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleSet;
import hudson.ivy.IvyModuleSetBuild;
import hudson.ivy.IvyReporter;
import hudson.ivy.Messages;
import hudson.ivy.SplittableBuildListener;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.ChangeLogSet;
import hudson.slaves.WorkspaceList;
import hudson.tasks.Ant;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyBuild
extends AbstractIvyBuild<IvyModule, IvyBuild> {
    List<IvyReporter> projectActionReporters;
    public static boolean debug = false;

    public IvyBuild(IvyModule job) throws IOException {
        super(job);
    }

    public IvyBuild(IvyModule job, Calendar timestamp) {
        super(job, timestamp);
    }

    public IvyBuild(IvyModule project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    public String getUpUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof IvyModuleSetBuild)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + '/';
            }
        }
        return super.getUpUrl();
    }

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof IvyModuleSetBuild)) continue;
                return this.getParent().getDisplayName();
            }
        }
        return super.getDisplayName();
    }

    public IvyModuleSetBuild getParentBuild() {
        return (IvyModuleSetBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public IvyModuleSetBuild getModuleSetBuild() {
        return (IvyModuleSetBuild)this.getParent().getParent().getNearestOldBuild(this.getNumber());
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return new FilteredChangeLogSet(this);
    }

    public boolean hasChangeSetComputed() {
        return true;
    }

    public void registerAsProjectAction(IvyReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<IvyReporter>();
        }
        this.projectActionReporters.add(reporter);
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl());
        ((IvyModule)this.getProject()).updateTransientActions();
        IvyModuleSetBuild parentBuild = this.getModuleSetBuild();
        if (parentBuild != null) {
            parentBuild.notifyModuleBuild(this);
        }
    }

    protected void setWorkspace(FilePath path) {
        super.setWorkspace(path);
    }

    public IvyModule getParent() {
        return (IvyModule)super.getParent();
    }

    private class RunnerImpl
    extends AbstractBuild.AbstractRunner {
        private List<Publisher> reporters;

        private RunnerImpl() {
            super((AbstractBuild)IvyBuild.this);
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            return wsl.allocate(IvyBuild.this.getModuleSetBuild().getModuleRoot().child(((IvyModule)IvyBuild.this.getProject()).getRelativePathToModuleRoot()));
        }

        protected Result doRun(BuildListener listener) throws Exception {
            this.reporters = ((IvyModule)IvyBuild.this.getProject()).createModulePublishers();
            IvyModuleSet mms = ((IvyModule)IvyBuild.this.getProject()).getParent();
            if (debug) {
                listener.getLogger().println("Reporters=" + this.reporters);
            }
            for (BuildWrapper w : mms.getBuildWrappersList()) {
                BuildWrapper.Environment e = w.setUp((AbstractBuild)IvyBuild.this, this.launcher, listener);
                if (e == null) {
                    return Result.FAILURE;
                }
                IvyBuild.this.buildEnvironments.add(e);
            }
            Ant ant = new Ant(((IvyModule)IvyBuild.this.getProject()).getTargets(), mms.getAnt(), mms.getAntOpts(), mms.getBuildFile(), mms.getAntProperties());
            if (ant.perform((AbstractBuild)IvyBuild.this, this.launcher, listener)) {
                return Result.SUCCESS;
            }
            return Result.FAILURE;
        }

        public void post2(BuildListener listener) throws Exception {
            this.performAllBuildStep(listener, this.reporters, true);
            this.performAllBuildStep(listener, ((IvyModule)IvyBuild.this.project).getProperties(), true);
        }

        public void cleanUp(BuildListener listener) throws Exception {
            this.performAllBuildStep(listener, this.reporters, false);
            this.performAllBuildStep(listener, ((IvyModule)IvyBuild.this.project).getProperties(), false);
            IvyBuild.this.scheduleDownstreamBuilds(listener);
        }
    }

    class ProxyImpl2
    extends ProxyImpl
    implements IvyBuildProxy2 {
        private final SplittableBuildListener listener;
        long startTime;
        private final OutputStream log;
        private final IvyModuleSetBuild parentBuild;

        ProxyImpl2(IvyModuleSetBuild parentBuild, SplittableBuildListener listener) throws FileNotFoundException {
            this.parentBuild = parentBuild;
            this.listener = listener;
            this.log = new FileOutputStream(IvyBuild.this.getLogFile());
        }

        public void start() {
            IvyBuild.this.onStartBuilding();
            this.startTime = System.currentTimeMillis();
            try {
                this.listener.setSideOutputStream(this.log);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void end() {
            if (IvyBuild.this.result == null) {
                this.setResult(Result.SUCCESS);
            }
            IvyBuild.this.onEndBuilding();
            IvyBuild.this.duration = System.currentTimeMillis() - this.startTime;
            this.parentBuild.notifyModuleBuild(IvyBuild.this);
            try {
                this.listener.setSideOutputStream(null);
                IvyBuild.this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void appendLastLog() {
            try {
                this.listener.setSideOutputStream(this.log);
                this.listener.setSideOutputStream(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        protected void close() {
            try {
                this.log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (IvyBuild.this.hasntStartedYet()) {
                IvyBuild.this.run(new Run.Runner(){

                    public Result run(BuildListener listener) {
                        listener.getLogger().println(Messages.IvyBuild_FailedEarlier());
                        return Result.NOT_BUILT;
                    }

                    public void post(BuildListener listener) {
                    }

                    public void cleanUp(BuildListener listener) {
                    }
                });
            }
        }

        public IvyBuild owner() {
            return IvyBuild.this;
        }

        private Object writeReplace() {
            return Channel.current().export(IvyBuildProxy2.class, Executor.currentExecutor().newImpersonatingProxy(IvyBuildProxy2.class, (Object)this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyImpl
    implements IvyBuildProxy,
    Serializable {
        ProxyImpl() {
        }

        @Override
        public <V, T extends Throwable> V execute(IvyBuildProxy.BuildCallable<V, T> program) throws T, IOException, InterruptedException {
            return program.call(IvyBuild.this);
        }

        @Override
        @Deprecated
        public final void executeAsync(IvyBuildProxy.BuildCallable<?, ?> program) throws IOException {
            throw new AssertionError();
        }

        @Override
        public FilePath getRootDir() {
            return new FilePath(IvyBuild.this.getRootDir());
        }

        @Override
        public FilePath getProjectRootDir() {
            return new FilePath(IvyBuild.this.getParent().getRootDir());
        }

        @Override
        public FilePath getModuleSetRootDir() {
            return new FilePath(IvyBuild.this.getParent().getParent().getRootDir());
        }

        @Override
        public FilePath getArtifactsDir() {
            return new FilePath(IvyBuild.this.getArtifactsDir());
        }

        @Override
        public void setResult(Result result) {
            IvyBuild.this.setResult(result);
        }

        @Override
        public Calendar getTimestamp() {
            return IvyBuild.this.getTimestamp();
        }

        @Override
        public long getMilliSecsSinceBuildStart() {
            return System.currentTimeMillis() - this.getTimestamp().getTimeInMillis();
        }

        @Override
        public boolean isArchivingDisabled() {
            return IvyBuild.this.getParent().getParent().isArchivingDisabled();
        }

        @Override
        public void registerAsProjectAction(IvyReporter reporter) {
            IvyBuild.this.registerAsProjectAction(reporter);
        }

        @Override
        public void registerAsAggregatedProjectAction(IvyReporter reporter) {
            IvyModuleSetBuild pb = IvyBuild.this.getParentBuild();
            if (pb != null) {
                pb.registerAsProjectAction(reporter);
            }
        }

        private Object writeReplace() {
            return Channel.current().export(IvyBuildProxy.class, (Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Builder
    extends IvyBuilder {
        private final IvyBuildProxy buildProxy;
        private final IvyReporter[] reporters;
        private long startTime;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, IvyBuildProxy buildProxy, IvyReporter[] reporters, List<String> goals, Map<String, String> systemProps) {
            super(listener, goals, systemProps);
            this.buildProxy = new FilterImpl(buildProxy);
            this.reporters = reporters;
        }

        @Override
        void preBuild(BuildEvent event) throws IOException, InterruptedException {
            for (IvyReporter r : this.reporters) {
                r.preBuild(this.buildProxy, event, this.listener);
            }
        }

        @Override
        void postBuild(BuildEvent event) throws IOException, InterruptedException {
            for (IvyReporter r : this.reporters) {
                r.postBuild(this.buildProxy, event, this.listener);
            }
        }

        @Override
        void preModule(BuildEvent event) throws InterruptedException, IOException, AbortException {
            for (IvyReporter r : this.reporters) {
                if (r.enterModule(this.buildProxy, event, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
        }

        @Override
        void postModule(BuildEvent event) throws InterruptedException, IOException, AbortException {
            for (IvyReporter r : this.reporters) {
                if (r.leaveModule(this.buildProxy, event, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FilterImpl
        extends IvyBuildProxy.Filter<IvyBuildProxy>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public FilterImpl(IvyBuildProxy buildProxy) {
                super(buildProxy);
            }

            @Override
            public void executeAsync(IvyBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.futures.add(Channel.current().callAsync((Callable)new IvyBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }
        }
    }
}

