/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.FilePath;
import hudson.ivy.AbstractIvyBuild;
import hudson.ivy.AbstractIvyProject;
import hudson.ivy.FilteredChangeLogSet;
import hudson.ivy.IvyBuild;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleSetBuild;
import hudson.ivy.IvyReporter;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyBuild
extends AbstractIvyBuild<IvyModule, IvyBuild> {
    List<IvyReporter> projectActionReporters;
    public static boolean debug = false;

    public IvyBuild(IvyModule job) throws IOException {
        super((AbstractIvyProject)job);
    }

    public IvyBuild(IvyModule job, Calendar timestamp) {
        super((AbstractIvyProject)job, timestamp);
    }

    public IvyBuild(IvyModule project, File buildDir) throws IOException {
        super((AbstractIvyProject)project, buildDir);
    }

    public String getUpUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof IvyModuleSetBuild)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + '/';
            }
        }
        return super.getUpUrl();
    }

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof IvyModuleSetBuild)) continue;
                return this.getParent().getDisplayName();
            }
        }
        return super.getDisplayName();
    }

    public IvyModuleSetBuild getParentBuild() {
        return (IvyModuleSetBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public IvyModuleSetBuild getModuleSetBuild() {
        return (IvyModuleSetBuild)this.getParent().getParent().getNearestOldBuild(this.getNumber());
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return new FilteredChangeLogSet(this);
    }

    public boolean hasChangeSetComputed() {
        return true;
    }

    public void registerAsProjectAction(IvyReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList();
        }
        this.projectActionReporters.add(reporter);
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl(this, null));
        ((IvyModule)this.getProject()).updateTransientActions();
        IvyModuleSetBuild parentBuild = this.getModuleSetBuild();
        if (parentBuild != null) {
            parentBuild.notifyModuleBuild(this);
        }
    }

    protected void setWorkspace(FilePath path) {
        super.setWorkspace(path);
    }

    public IvyModule getParent() {
        return (IvyModule)super.getParent();
    }

    static /* synthetic */ void access$100(IvyBuild x0) {
        x0.onStartBuilding();
    }

    static /* synthetic */ Result access$200(IvyBuild x0) {
        return x0.result;
    }

    static /* synthetic */ void access$300(IvyBuild x0) {
        x0.onEndBuilding();
    }

    static /* synthetic */ long access$402(IvyBuild x0, long x1) {
        x0.duration = x1;
        return x0.duration;
    }

    static /* synthetic */ void access$500(IvyBuild x0, Run.Runner x1) {
        x0.run(x1);
    }

    static /* synthetic */ List access$600(IvyBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$700(IvyBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ Job access$800(IvyBuild x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$900(IvyBuild x0) {
        return x0.project;
    }
}

