/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy.builder;

import hudson.Extension;
import hudson.ivy.builder.IvyBuilderType;
import hudson.ivy.builder.IvyBuilderTypeDescriptor;
import hudson.model.Environment;
import hudson.model.Hudson;
import hudson.plugins.nant.NantBuilder;
import hudson.tasks.Builder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NAntIvyBuilderType
extends IvyBuilderType {
    private String targets;
    private String nantName;
    private String nantOpts;
    private String buildFile;
    private String nantProperties;

    @DataBoundConstructor
    public NAntIvyBuilderType(String nantName, String buildFile, String targets, String nantProperties, String nantOpts) {
        this.nantName = nantName;
        this.buildFile = buildFile;
        this.targets = targets;
        this.nantProperties = nantProperties;
        this.nantOpts = nantOpts;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getNantName() {
        return this.nantName;
    }

    public String getNantOpts() {
        return this.nantOpts;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getNantProperties() {
        return this.nantProperties;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return new HashMap<String, String>();
    }

    @Override
    public Builder getBuilder(Properties additionalProperties, String overrideTargets, List<Environment> environments) {
        StringBuilder properties = new StringBuilder();
        if (this.nantProperties != null) {
            properties.append(this.nantProperties);
        }
        if (additionalProperties != null) {
            for (String key : additionalProperties.stringPropertyNames()) {
                properties.append("\n");
                properties.append(key).append("=").append(additionalProperties.getProperty(key));
            }
        }
        return new NantBuilder(this.buildFile, this.nantName, overrideTargets == null ? this.targets : overrideTargets, properties.length() == 0 ? null : properties.toString());
    }

    @Extension
    public static class DescriptorImpl
    extends IvyBuilderTypeDescriptor {
        public String getDisplayName() {
            return "NAnt Builder";
        }

        public NantBuilder.NantInstallation[] getInstallations() {
            return ((NantBuilder.DescriptorImpl)Hudson.getInstance().getDescriptorByType(NantBuilder.DescriptorImpl.class)).getInstallations();
        }
    }
}

