/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.ivy.IvyBuildTrigger;
import hudson.ivy.IvyMessageImpl;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class IvyBuildTrigger
extends Publisher
implements DependecyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(IvyBuildTrigger.class.getName());
    private String ivyFile = "ivy.xml";
    private long lastmodified = 0L;
    private final String ivyConfName;
    private transient ModuleDescriptor moduleDescriptor;
    public static final DescriptorImpl DESCRIPTOR;

    public IvyBuildTrigger(String ivyFile, String ivyConfName) {
        this.ivyFile = ivyFile;
        this.ivyConfName = ivyConfName;
    }

    public String getIvyFile() {
        return this.ivyFile;
    }

    public String getIvyConfName() {
        return this.ivyConfName;
    }

    public IvyConfiguration getIvyConfiguration() {
        for (IvyConfiguration i : DESCRIPTOR.getConfigurations()) {
            if (this.ivyConfName == null || !i.getName().equals(this.ivyConfName)) continue;
            return i;
        }
        return null;
    }

    public Ivy getIvy() {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        Ivy ivy = Ivy.newInstance();
        IvyConfiguration ivyConf = this.getIvyConfiguration();
        if (ivyConf != null) {
            File conf = new File(ivyConf.getIvyConfPath());
            try {
                LOGGER.info("Configure Ivy for Configuration: " + IvyConfiguration.access$000((IvyConfiguration)ivyConf));
                ivy.configure(conf);
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, "Parsing error while reading the ivy configuration " + ivyConf.getName() + " at " + ivyConf.getIvyConfPath(), e);
                return null;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "I/O error while reading the ivy configuration " + ivyConf.getName() + " at " + ivyConf.getIvyConfPath(), e);
                return null;
            }
        }
        return ivy;
    }

    public ModuleDescriptor getModuleDescriptor(FilePath workspace) {
        if (this.moduleDescriptor == null) {
            this.recomputeModuleDescriptor(workspace);
        }
        return this.moduleDescriptor;
    }

    public void recomputeModuleDescriptor(FilePath workspace) {
        Ivy ivy = this.getIvy();
        if (ivy == null) {
            this.moduleDescriptor = null;
        } else {
            FilePath ivyF = workspace.child(this.ivyFile);
            this.moduleDescriptor = (ModuleDescriptor)ivy.execute((Ivy.IvyCallback)new /* Unavailable Anonymous Inner Class!! */);
            try {
                this.lastmodified = ivyF.lastModified();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Could not save the last Modified Date of the ivy file:" + ivyF, e);
            }
            catch (IOException e1) {
                LOGGER.log(Level.WARNING, "Could not save the last Modified Date of the ivy file:" + ivyF, e1);
            }
        }
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = ((Project)build.getProject()).getWorkspace();
        FilePath f = workspace.child(this.ivyFile);
        try {
            if (this.lastmodified != f.lastModified()) {
                this.recomputeModuleDescriptor(((Project)build.getProject()).getWorkspace());
                Hudson.getInstance().rebuildDependencyGraph();
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to read the ivy file " + f));
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error("Interuption of the read the ivy file " + f));
        }
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        ModuleDescriptor md = this.getModuleDescriptor(owner.getWorkspace());
        if (md == null) {
            return;
        }
        List projects = Hudson.getInstance().getAllItems(Project.class);
        HashMap<ModuleId, Project> projectMap = new HashMap<ModuleId, Project>();
        for (Project p : projects) {
            ModuleDescriptor m;
            IvyBuildTrigger t;
            if (p.isDisabled() || (t = (IvyBuildTrigger)p.getPublisher((Descriptor)DESCRIPTOR)) == null || (m = t.getModuleDescriptor(p.getWorkspace())) == null) continue;
            ModuleId id = m.getModuleRevisionId().getModuleId();
            projectMap.put(id, p);
        }
        DependencyDescriptor[] deps = md.getDependencies();
        ArrayList<AbstractProject> dependencies = new ArrayList<AbstractProject>();
        for (DependencyDescriptor depDesc : deps) {
            ModuleId id = depDesc.getDependencyId();
            AbstractProject p = (AbstractProject)projectMap.get(id);
            if (p == null) continue;
            dependencies.add(p);
        }
        graph.addDependency(dependencies, owner);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        DESCRIPTOR = new DescriptorImpl();
    }
}

