/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.plugins.jabber.im.AbstractIMConnection;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.IMPublisherDescriptor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractIMConnection
implements IMConnection {
    private static final Logger LOGGER = Logger.getLogger(AbstractIMConnection.class.getName());
    private final Lock connectionLock = new ReentrantLock();
    private final ConnectorRunnable connector = new ConnectorRunnable(this, null);
    private volatile Thread connectorThread;
    private final IMPublisherDescriptor desc;
    private final BusyListener busyListener;

    protected AbstractIMConnection(IMPublisherDescriptor desc) {
        this.desc = desc;
        this.busyListener = new BusyListener(this);
    }

    public final boolean connect() {
        boolean result = this.connect0();
        if (StringUtils.isNotBlank((String)this.desc.getHost())) {
            this.busyListener.register();
            this.connectorThread = new Thread((Runnable)this.connector, "IM-ConnectorThread");
            this.connectorThread.start();
        }
        return result;
    }

    protected abstract boolean connect0();

    protected final void lock() {
        this.connectionLock.lock();
    }

    protected final boolean tryLock(long time, TimeUnit timeUnit) throws InterruptedException {
        return this.connectionLock.tryLock(time, timeUnit);
    }

    protected final void unlock() {
        this.connectionLock.unlock();
    }

    protected void tryReconnect() {
        ConnectorRunnable.access$100((ConnectorRunnable)this.connector).release();
    }

    protected void updateIMStatus() {
        this.updateIMStatus(null);
    }

    private void updateIMStatus(Executor exec) {
        int totalExecutors = this.getTotalExecutors();
        int busyExecutors = this.getBusyExecutors(exec);
        try {
            if (busyExecutors == 0) {
                this.setPresence(IMPresence.AVAILABLE, "Yawn, I'm so bored. Don't you have some work for me?");
            } else if (busyExecutors == totalExecutors) {
                this.setPresence(IMPresence.DND, "Please give me some rest! All " + totalExecutors + " executors are busy, " + Hudson.getInstance().getQueue().getItems().length + " jobs in queue.");
            } else {
                String msg = "Working: " + busyExecutors + " out of " + totalExecutors + " executors are busy.";
                int queueItems = Hudson.getInstance().getQueue().getItems().length;
                if (queueItems > 0) {
                    msg = msg + " " + queueItems + " jobs in queue.";
                }
                this.setPresence(IMPresence.OCCUPIED, msg);
            }
        }
        catch (IMException e) {
            // empty catch block
        }
    }

    private int getBusyExecutors(Executor exec) {
        Computer[] computers;
        int busyExecutors = 0;
        for (Computer compi : computers = Hudson.getInstance().getComputers()) {
            for (Executor executor : compi.getExecutors()) {
                if (!executor.isBusy() || !AbstractIMConnection.isNotEqual((Executor)executor, (Executor)exec)) continue;
                ++busyExecutors;
            }
        }
        return busyExecutors;
    }

    private int getTotalExecutors() {
        Computer[] computers;
        int totalExecutors = 0;
        for (Computer compi : computers = Hudson.getInstance().getComputers()) {
            totalExecutors += compi.getNumExecutors();
        }
        return totalExecutors;
    }

    private static boolean isNotEqual(Executor executor, Executor exec) {
        if (exec == null) {
            return true;
        }
        return !executor.getOwner().equals(exec.getOwner()) || executor.getNumber() != exec.getNumber();
    }

    protected abstract boolean isConnected();

    public final void close() {
        this.connectorThread.interrupt();
        this.connectorThread = null;
        this.busyListener.unregister();
    }

    protected abstract void close0();

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ void access$300(AbstractIMConnection x0, Executor x1) {
        x0.updateIMStatus(x1);
    }
}

