/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.AbstractIMConnection;
import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMChat;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessage;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.IMPublisherDescriptor;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberMessage;
import hudson.plugins.jabber.im.transport.JabberMultiUserChat;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.bot.Bot;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.tools.ExceptionHelper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

class JabberIMConnection
extends AbstractIMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPConnection connection;
    private final Map<String, WeakReference<GroupChat>> groupChatCache = new HashMap();
    private final Map<String, WeakReference<Chat>> chatCache = new HashMap();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final boolean legacySSL;
    private final String[] groupChats;
    private IMPresence impresence;
    private final String defaultIdSuffix;
    private String imStatusMessage;
    private JabberPublisherDescriptor desc;

    JabberIMConnection(JabberPublisherDescriptor desc) throws IMException {
        super((IMPublisherDescriptor)desc);
        Assert.isNotNull((Object)desc, (String)"Parameter 'desc' must not be null.");
        this.desc = desc;
        this.hostname = desc.getHostname();
        this.port = desc.getPort();
        this.legacySSL = desc.isLegacySSL();
        this.nick = desc.getJabberId();
        this.passwd = desc.getPassword();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getInitialGroupChats() != null ? desc.getInitialGroupChats().trim().split("\\s") : new String[0];
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
        this.defaultIdSuffix = desc.getDefaultIdSuffix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean connect0() {
        this.lock();
        try {
            if (!this.isConnected()) {
                if (this.createConnection()) {
                    LOGGER.info("Connected to XMPP on " + this.hostname + ":" + this.port);
                    this.updateIMStatus();
                    for (String groupChatName : this.groupChats) {
                        try {
                            groupChatName = groupChatName.trim();
                            this.createGroupChatConnection(groupChatName, true);
                            LOGGER.info("Joined groupchat " + groupChatName);
                        }
                        catch (XMPPException e) {
                            LOGGER.warning("Unable to connect to groupchat '" + groupChatName + "'. Did you append @conference or so to the name?\n" + "Message: " + e.toString());
                        }
                    }
                } else {
                    boolean arr$ = false;
                    return arr$;
                }
            }
            boolean arr$ = true;
            return arr$;
        }
        catch (Exception dontCare) {
            LOGGER.warning(ExceptionHelper.dump((Throwable)dontCare));
            this.tryReconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close0() {
        this.lock();
        try {
            try {
                if (this.isConnected()) {
                    for (WeakReference entry : this.groupChatCache.values()) {
                        GroupChat chat = (GroupChat)entry.get();
                        if (chat == null || !chat.isJoined()) continue;
                        chat.leave();
                    }
                    this.groupChatCache.clear();
                    this.chatCache.clear();
                    this.connection.close();
                }
            }
            finally {
                this.connection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean createConnection() throws XMPPException {
        String serviceName;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if ((serviceName = this.desc.getServiceName()) == null) {
            this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port) : new XMPPConnection(this.hostname, this.port);
        } else if (this.hostname == null) {
            this.connection = this.legacySSL ? new SSLXMPPConnection(serviceName) : new XMPPConnection(serviceName);
        } else {
            Object object = this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port, serviceName) : new XMPPConnection(this.hostname, this.port, serviceName);
        }
        if (this.connection.isConnected()) {
            this.connection.login(this.desc.getUserName(), this.passwd, "Hudson");
            String fullUser = this.desc.getUserName() + "@" + this.hostname;
            AndFilter filter = new AndFilter((PacketFilter)new MessageTypeFilter(Message.Type.CHAT), (PacketFilter)new ToContainsFilter(fullUser));
            IMListener listener = new IMListener(this, null);
            this.connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
            this.connection.addConnectionListener((ConnectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.connection.isAuthenticated();
    }

    private GroupChat createGroupChatConnection(String groupChatName, boolean forceReconnect) throws XMPPException {
        boolean create;
        WeakReference ref = (WeakReference)this.groupChatCache.get(groupChatName);
        GroupChat groupChat = null;
        if (ref != null) {
            groupChat = (GroupChat)ref.get();
        }
        boolean bl = create = groupChat == null || forceReconnect;
        if (forceReconnect && groupChat != null) {
            try {
                this.groupChatCache.remove(groupChatName);
                groupChat.leave();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (create) {
            groupChat = this.connection.createGroupChat(groupChatName);
            groupChat.join(this.groupChatNick);
            while (groupChat.pollMessage() != null) {
            }
            new Bot((IMChat)new JabberMultiUserChat(groupChat), this.groupChatNick, this.hostname, this.botCommandPrefix);
            this.groupChatCache.put(groupChatName, new WeakReference<GroupChat>(groupChat));
        }
        return groupChat;
    }

    private Chat getChat(String chatPartner, Message msg) {
        Chat c;
        WeakReference wr = (WeakReference)this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = this.connection.createChat(chatPartner);
        Bot bot = new Bot((IMChat)new JabberChat(chat), this.groupChatNick, this.hostname, this.botCommandPrefix);
        if (msg != null) {
            bot.onMessage((IMMessage)new JabberMessage(msg));
        }
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.isNotNull((Object)text, (String)"Parameter 'text' must not be null.");
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.createGroupChatConnection(target.toString(), false).sendMessage(text);
                } else {
                    Chat chat = this.getChat(target.toString(), null);
                    chat.sendMessage(text);
                }
            }
            catch (XMPPException dontCare) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)dontCare));
                this.tryReconnect();
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setPresence(IMPresence impresence, String statusMessage) throws IMException {
        Assert.isNotNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        if (this.desc.isExposePresence()) {
            this.impresence = impresence;
            this.imStatusMessage = statusMessage;
        } else {
            this.impresence = IMPresence.UNAVAILABLE;
            this.imStatusMessage = "";
        }
        this.sendPresence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                Presence presence;
                if (!this.isConnected()) {
                    return;
                }
                switch (2.$SwitchMap$hudson$plugins$jabber$im$IMPresence[this.impresence.ordinal()]) {
                    case 1: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.AVAILABLE);
                        break;
                    }
                    case 2: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.AWAY);
                        break;
                    }
                    case 3: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.DO_NOT_DISTURB);
                        break;
                    }
                    case 4: {
                        presence = new Presence(Presence.Type.UNAVAILABLE);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle " + this.impresence);
                    }
                }
                this.connection.sendPacket((Packet)presence);
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnected() {
        this.lock();
        try {
            boolean bl = this.connection != null && this.connection.isAuthenticated();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    static /* synthetic */ void access$100(JabberIMConnection x0) {
        x0.tryReconnect();
    }

    static /* synthetic */ void access$200(JabberIMConnection x0) {
        x0.tryReconnect();
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ Chat access$400(JabberIMConnection x0, String x1, Message x2) {
        return x0.getChat(x1, x2);
    }
}

