/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.tools;

import hudson.model.AbstractBuild;
import hudson.model.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BuildHelper {
    private BuildHelper() {
    }

    public static boolean isFix(AbstractBuild<?, ?> build) {
        if (build.getResult() != Result.SUCCESS) {
            return false;
        }
        AbstractBuild previousBuild = BuildHelper.getPreviousCompletedBuild(build);
        if (previousBuild != null) {
            return previousBuild.getResult().isWorseThan(Result.SUCCESS);
        }
        return false;
    }

    public static AbstractBuild<?, ?> getPreviousCompletedBuild(AbstractBuild<?, ?> build) {
        AbstractBuild previousBuild;
        for (previousBuild = (AbstractBuild)build.getPreviousBuild(); previousBuild != null; previousBuild = (AbstractBuild)previousBuild.getPreviousBuild()) {
            if (previousBuild.getResult() == Result.ABORTED || previousBuild.getResult() == Result.NOT_BUILT) {
                continue;
            }
            return previousBuild;
        }
        return previousBuild;
    }

    public static String getResultDescription(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        if (result == Result.ABORTED || result == Result.NOT_BUILT) {
            return result.toString();
        }
        if (BuildHelper.isFix(build)) {
            return "FIXED";
        }
        AbstractBuild previousBuild = BuildHelper.getPreviousCompletedBuild(build);
        if (result == Result.UNSTABLE) {
            if (previousBuild != null && previousBuild.getResult() == Result.UNSTABLE) {
                return "STILL UNSTABLE";
            }
        } else if (result == Result.FAILURE && previousBuild != null && previousBuild.getResult() == Result.FAILURE) {
            return "STILL FAILING";
        }
        return result.toString();
    }
}

