/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.tools;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class MessageHelper {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static final String QUOTE = "\"";

    public static String getBuildURL(AbstractBuild<?, ?> lastBuild) {
        StringBuilder builder = new StringBuilder(String.valueOf(Hudson.getInstance().getRootUrl()));
        builder.append(Util.encode((String)lastBuild.getUrl()));
        return builder.toString();
    }

    public static String[] extractCommandLine(String message) {
        return MessageHelper.extractParameters((String)message).toArray(new String[0]);
    }

    private static List<String> extractParameters(String commandLine) {
        ArrayList<String> parameters = new ArrayList<String>();
        int firstQuote = (commandLine = commandLine.trim()).indexOf("\"");
        if (firstQuote != -1) {
            int endQuoted = commandLine.indexOf("\"", firstQuote + 1);
            if (endQuoted == -1) {
                Collections.addAll(parameters, SPACE_PATTERN.split(commandLine));
            } else if (firstQuote == 0) {
                parameters.add(commandLine.substring(1, endQuoted - 1));
            } else {
                parameters.addAll(MessageHelper.extractParameters((String)commandLine.substring(0, firstQuote)));
                parameters.add(commandLine.substring(firstQuote + 1, endQuoted));
                if (endQuoted < commandLine.length() - 1) {
                    parameters.addAll(MessageHelper.extractParameters((String)commandLine.substring(endQuoted + 1)));
                }
            }
        } else {
            Collections.addAll(parameters, SPACE_PATTERN.split(commandLine));
        }
        return parameters;
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private static String join(String[] array, int startIndex) {
        String joined = StringUtils.join((Object[])MessageHelper.copyOfRange((Object[])array, (int)startIndex, (int)array.length, String[].class), (String)" ");
        joined = joined.replaceAll("\"", "");
        return joined;
    }

    public static String getJoinedName(String[] args, int startIndex) {
        String joined = MessageHelper.join((String[])args, (int)startIndex);
        return joined.replaceAll("\"", "");
    }
}

