/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.jabber.NotificationStrategy;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.IMPublisherDescriptor;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisher;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.tools.ExceptionHelper;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JabberPublisherDescriptor
extends BuildStepDescriptor<Publisher>
implements IMPublisherDescriptor {
    private static final Logger LOGGER = Logger.getLogger(JabberPublisherDescriptor.class.getName());
    private static final String PREFIX = "jabberPlugin.";
    public static final String PARAMETERNAME_PORT = "jabberPlugin.port";
    public static final String PARAMETERNAME_HOSTNAME = "jabberPlugin.hostname";
    public static final String PARAMETERNAME_SSL = "jabberPlugin.ssl";
    public static final String PARAMETERNAME_PRESENCE = "jabberPlugin.exposePresence";
    public static final String PARAMETERNAME_PASSWORD = "jabberPlugin.password";
    public static final String PARAMETERNAME_JABBERID = "jabberPlugin.jabberId";
    public static final String PARAMETERNAME_GROUP_NICKNAME = "jabberPlugin.groupNick";
    public static final String PARAMETERNAME_TARGETS = "jabberPlugin.targets";
    public static final String PARAMETERNAME_STRATEGY = "jabberPlugin.strategy";
    public static final String PARAMETERNAME_NOTIFY_START = "jabberPlugin.notifyStart";
    public static final String PARAMETERNAME_NOTIFY_SUSPECTS = "jabberPlugin.notifySuspects";
    public static final String PARAMETERNAME_NOTIFY_FIXERS = "jabberPlugin.notifyFixers";
    public static final String PARAMETERNAME_INITIAL_GROUPCHATS = "jabberPlugin.initialGroupChats";
    public static final String PARAMETERNAME_COMMAND_PREFIX = "jabberPlugin.commandPrefix";
    public static final String PARAMETERNAME_DEFAULT_ID_SUFFIX = "jabberPlugin.defaultIdSuffix";
    public static final String[] PARAMETERVALUE_STRATEGY_VALUES = new String[NotificationStrategy.values().length];
    public static final String PARAMETERVALUE_STRATEGY_DEFAULT;
    public static final String DEFAULT_COMMAND_PREFIX = "!";
    private static final int DEFAULT_PORT = 5222;
    private int port = 5222;
    private String hostname = null;
    private boolean legacySSL = false;
    private String hudsonNickname = "hudson";
    private String hudsonPassword = "secret";
    private String groupChatNickname = null;
    private boolean exposePresence = true;
    private String initialGroupChats = null;
    private String commandPrefix = "!";
    private String defaultIdSuffix;

    public JabberPublisherDescriptor() {
        super(JabberPublisher.class);
        this.load();
        if (StringUtils.isNotBlank((String)this.hostname) || StringUtils.isNotBlank((String)this.getServiceName())) {
            try {
                JabberIMConnectionProvider.getInstance().createConnection(this);
            }
            catch (Exception dontCare) {
                LOGGER.warning(ExceptionHelper.dump(dontCare));
            }
        } else {
            LOGGER.info("No hostname configured.");
        }
    }

    private void applyHostname(HttpServletRequest req) throws Descriptor.FormException {
        String s = req.getParameter(PARAMETERNAME_HOSTNAME);
        if (s != null && s.trim().length() > 0) {
            try {
                InetAddress.getByName(s);
                this.hostname = s;
            }
            catch (UnknownHostException e) {
                throw new Descriptor.FormException("Cannot find Host '" + s + "'.", PARAMETERNAME_HOSTNAME);
            }
        } else {
            this.hostname = null;
        }
    }

    private void applyNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonNickname = req.getParameter(PARAMETERNAME_JABBERID);
        if (this.hostname != null && (this.hudsonNickname == null || this.hudsonNickname.trim().length() == 0)) {
            throw new Descriptor.FormException("Account/Nickname cannot be empty.", PARAMETERNAME_JABBERID);
        }
    }

    private void applyPassword(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonPassword = req.getParameter(PARAMETERNAME_PASSWORD);
        if (this.hostname != null && this.hudsonPassword == null || this.hudsonPassword.trim().length() == 0) {
            throw new Descriptor.FormException("Password cannot be empty.", PARAMETERNAME_PASSWORD);
        }
    }

    private void applyGroupChatNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.groupChatNickname = req.getParameter(PARAMETERNAME_GROUP_NICKNAME);
        if (this.groupChatNickname != null && this.groupChatNickname.trim().length() == 0) {
            this.groupChatNickname = null;
        }
    }

    private void applyPort(HttpServletRequest req) throws Descriptor.FormException {
        String p = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_PORT));
        if (p != null) {
            try {
                int i = Integer.parseInt(p);
                if (i < 0 || i > 65535) {
                    throw new Descriptor.FormException("Port out of range.", PARAMETERNAME_PORT);
                }
                this.port = i;
            }
            catch (NumberFormatException e) {
                throw new Descriptor.FormException("Port cannot be parsed.", PARAMETERNAME_PORT);
            }
        } else {
            this.port = 5222;
        }
    }

    private void applyLegacySSL(HttpServletRequest req) {
        this.legacySSL = req.getParameter(PARAMETERNAME_SSL) != null;
    }

    private void applyPresence(HttpServletRequest req) {
        this.exposePresence = req.getParameter(PARAMETERNAME_PRESENCE) != null;
    }

    private void applyInitialGroupChats(HttpServletRequest req) {
        this.initialGroupChats = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_INITIAL_GROUPCHATS));
    }

    private void applyCommandPrefix(HttpServletRequest req) {
        String prefix = req.getParameter(PARAMETERNAME_COMMAND_PREFIX);
        this.commandPrefix = prefix != null && prefix.trim().length() > 0 ? prefix : DEFAULT_COMMAND_PREFIX;
    }

    private void applyDefaultIdSuffix(HttpServletRequest req) {
        String suffix = req.getParameter(PARAMETERNAME_DEFAULT_ID_SUFFIX);
        this.defaultIdSuffix = suffix != null && suffix.trim().length() > 0 ? suffix.trim() : "";
    }

    public String getDisplayName() {
        return "Jabber Notification";
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getHost() {
        if (StringUtils.isNotBlank((String)this.hostname)) {
            return this.hostname;
        }
        return this.getServiceName();
    }

    public String getJabberId() {
        return this.hudsonNickname;
    }

    @Override
    public String getPassword() {
        return this.hudsonPassword;
    }

    public String getGroupChatNickname() {
        return this.groupChatNickname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String getPortString() {
        if (this.port == 5222) {
            return null;
        }
        return String.valueOf(this.port);
    }

    public boolean isLegacySSL() {
        return this.legacySSL;
    }

    @Override
    public boolean isExposePresence() {
        return this.exposePresence;
    }

    public String getInitialGroupChats() {
        return Util.fixEmptyAndTrim((String)this.initialGroupChats);
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    @Override
    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public JabberPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
        Assert.isNotNull(req, "Parameter 'req' must not be null.");
        String t = req.getParameter(PARAMETERNAME_TARGETS);
        String n = req.getParameter(PARAMETERNAME_STRATEGY);
        if (n == null) {
            n = PARAMETERVALUE_STRATEGY_DEFAULT;
        } else {
            boolean foundStrategyValueMatch = false;
            for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                if (!strategyValue.equals(n)) continue;
                foundStrategyValueMatch = true;
                break;
            }
            if (!foundStrategyValueMatch) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            }
        }
        String s = req.getParameter(PARAMETERNAME_NOTIFY_START);
        String ns = req.getParameter(PARAMETERNAME_NOTIFY_SUSPECTS);
        String nf = req.getParameter(PARAMETERNAME_NOTIFY_FIXERS);
        try {
            return new JabberPublisher(t, n, s != null && "on".equals(s), ns != null && "on".equals(ns), nf != null && "on".equals(nf));
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException((Throwable)e, PARAMETERNAME_TARGETS);
        }
    }

    public void shutdown() {
        JabberIMConnectionProvider factory = JabberIMConnectionProvider.getInstance();
        factory.releaseConnection();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        Assert.isNotNull(req, "Parameter 'req' must not be null.");
        this.applyPresence((HttpServletRequest)req);
        this.applyHostname((HttpServletRequest)req);
        this.applyPort((HttpServletRequest)req);
        this.applyLegacySSL((HttpServletRequest)req);
        this.applyNickname((HttpServletRequest)req);
        this.applyPassword((HttpServletRequest)req);
        this.applyGroupChatNickname((HttpServletRequest)req);
        this.applyInitialGroupChats((HttpServletRequest)req);
        this.applyCommandPrefix((HttpServletRequest)req);
        this.applyDefaultIdSuffix((HttpServletRequest)req);
        if (StringUtils.isNotBlank((String)this.hostname) || StringUtils.isNotBlank((String)this.getServiceName())) {
            try {
                JabberIMConnectionProvider.getInstance().createConnection(this);
            }
            catch (Exception e) {
                throw new Descriptor.FormException("Unable to create Client: " + e, null);
            }
        } else {
            LOGGER.info("No hostname specified.");
        }
        this.save();
        return super.configure(req, json);
    }

    public FormValidation doJabberIdCheck(@QueryParameter String jabberId, @QueryParameter String port) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        if (jabberId == null || jabberId.trim().length() == 0) {
            return FormValidation.error((String)"Jabber ID must not be empty!");
        }
        if (JabberPublisherDescriptor.getHostPart(jabberId) != null) {
            String host = JabberPublisherDescriptor.getHostPart(jabberId);
            try {
                JabberPublisherDescriptor.checkHostAccessibility(host, port);
                return FormValidation.ok();
            }
            catch (UnknownHostException e) {
                return FormValidation.error((String)("Unknown host " + host));
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)("Invalid port " + port));
            }
            catch (IOException e) {
                return FormValidation.error((String)("Unable to connect to " + this.hostname + ":" + port + " : " + e.getMessage()));
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doServerCheck(@QueryParameter String hostname, @QueryParameter String port, @QueryParameter boolean legacySSL) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        String host = Util.fixEmptyAndTrim((String)hostname);
        String p = Util.fixEmptyAndTrim((String)port);
        if (host == null) {
            return FormValidation.ok();
        }
        try {
            JabberPublisherDescriptor.checkHostAccessibility(host, port);
            return FormValidation.ok();
        }
        catch (UnknownHostException e) {
            return FormValidation.error((String)("Unknown host " + host));
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)("Invalid port " + port));
        }
        catch (IOException e) {
            return FormValidation.error((String)("Unable to connect to " + hostname + ":" + p + " : " + e.getMessage()));
        }
    }

    private static void checkHostAccessibility(String hostname, String port) throws UnknownHostException, IOException, NumberFormatException {
        hostname = Util.fixEmptyAndTrim((String)hostname);
        port = Util.fixEmptyAndTrim((String)port);
        int iPort = 5222;
        InetAddress address = InetAddress.getByName(hostname);
        if (port != null) {
            iPort = Integer.parseInt(port);
        }
        Socket s = new Socket(address, iPort);
        s.close();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    @Override
    public String getUserName() {
        int idx = this.hudsonNickname.indexOf(64);
        if (idx < 0) {
            return this.hudsonNickname;
        }
        return this.hudsonNickname.substring(0, idx);
    }

    public String getServiceName() {
        return JabberPublisherDescriptor.getHostPart(this.hudsonNickname);
    }

    private static String getHostPart(String jabberId) {
        int idx = jabberId.indexOf(64);
        if (idx < 0) {
            return null;
        }
        return jabberId.substring(idx + 1);
    }

    static {
        int i = 0;
        for (NotificationStrategy strategy : NotificationStrategy.values()) {
            JabberPublisherDescriptor.PARAMETERVALUE_STRATEGY_VALUES[i++] = strategy.getDisplayName();
        }
        PARAMETERVALUE_STRATEGY_DEFAULT = NotificationStrategy.STATECHANGE_ONLY.getDisplayName();
    }
}

