/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.plugins.jabber.im.transport.bot.AbstractMultipleJobCommand;
import hudson.plugins.jabber.im.transport.bot.AbstractTextSendingCommand;
import hudson.plugins.jabber.tools.MessageHelper;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMultipleJobCommand
extends AbstractTextSendingCommand {
    static final String UNKNOWN_JOB_STR = "unknown job";
    static final String UNKNOWN_VIEW_STR = "unknown view";

    AbstractMultipleJobCommand() {
    }

    protected abstract CharSequence getMessageForJob(AbstractProject<?, ?> var1);

    protected abstract String getCommandShortName();

    protected String getReply(String sender, String[] args) {
        Mode mode;
        String view;
        ArrayList<AbstractProject> projects;
        block16: {
            projects = new ArrayList<AbstractProject>();
            view = null;
            try {
                if (args.length >= 2) {
                    if ("-v".equals(args[1])) {
                        mode = Mode.VIEW;
                        view = MessageHelper.getJoinedName((String[])args, (int)2);
                        this.getProjectsForView(projects, view);
                        break block16;
                    }
                    mode = Mode.SINGLE;
                    String jobName = MessageHelper.getJoinedName((String[])args, (int)1);
                    AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(jobName, AbstractProject.class);
                    if (project != null) {
                        projects.add(project);
                        break block16;
                    }
                    return sender + ": " + UNKNOWN_JOB_STR + " " + jobName;
                }
                if (args.length == 1) {
                    mode = Mode.ALL;
                    for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                        if (!Hudson.getInstance().equals(project.getParent())) continue;
                        projects.add(project);
                    }
                    break block16;
                }
                throw new IllegalArgumentException("'args' must not be empty!");
            }
            catch (IllegalArgumentException e) {
                return sender + ": error: " + e.getMessage();
            }
        }
        if (!projects.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            switch (1.$SwitchMap$hudson$plugins$jabber$im$transport$bot$AbstractMultipleJobCommand$Mode[mode.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    msg.append(this.getCommandShortName()).append(" of all projects:\n");
                    break;
                }
                case 3: {
                    msg.append(this.getCommandShortName()).append(" of projects in view " + view + ":\n");
                }
            }
            boolean first = true;
            for (AbstractProject project : projects) {
                if (!first) {
                    msg.append("\n");
                } else {
                    first = false;
                }
                msg.append(this.getMessageForJob(project));
            }
            return msg.toString();
        }
        return sender + ": no job found";
    }

    public String getHelp() {
        return " [<job>|-v <view>] - show the " + this.getCommandShortName() + " of a specific job, jobs in a view or all jobs";
    }

    private void getProjectsForView(Collection<AbstractProject<?, ?>> toAddTo, String viewName) {
        View view = Hudson.getInstance().getView(viewName);
        if (view != null) {
            Collection items = view.getItems();
            for (TopLevelItem item : items) {
                if (!(item instanceof AbstractProject)) continue;
                toAddTo.add((AbstractProject)item);
            }
        } else {
            throw new IllegalArgumentException("unknown view: " + viewName);
        }
    }
}

