/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.plugins.jabber.im.IMChat;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessage;
import hudson.plugins.jabber.im.IMMessageListener;
import hudson.plugins.jabber.im.transport.bot.AbortCommand;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import hudson.plugins.jabber.im.transport.bot.BuildCommand;
import hudson.plugins.jabber.im.transport.bot.HealthCommand;
import hudson.plugins.jabber.im.transport.bot.QueueCommand;
import hudson.plugins.jabber.im.transport.bot.SetAliasCommand;
import hudson.plugins.jabber.im.transport.bot.SnackCommand;
import hudson.plugins.jabber.im.transport.bot.StatusCommand;
import hudson.plugins.jabber.im.transport.bot.TestResultCommand;
import hudson.plugins.jabber.tools.ExceptionHelper;
import hudson.plugins.jabber.tools.MessageHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Bot
implements IMMessageListener {
    private static final Logger LOGGER = Logger.getLogger(Bot.class.getName());
    private final BotCommand BUILD_COMMAND;
    private static final BotCommand STATUS_COMMAND = new StatusCommand();
    private static final BotCommand HEALTH_COMMAND = new HealthCommand();
    private static final BotCommand QUEUE_COMMAND = new QueueCommand();
    private static final BotCommand SNACK_COMMAND = new SnackCommand();
    private static final BotCommand TESTRESULTS_COMMAND = new TestResultCommand();
    private static final BotCommand ABORT_COMMAND = new AbortCommand();
    private final BotCommand HELP_COMMAND = new /* Unavailable Anonymous Inner Class!! */;
    private String HELP_CACHE = null;
    private static final Map<String, BotCommand> COMMAND_MAP = new HashMap();
    private final SortedMap<String, BotCommand> cmdsAndAliases = new TreeMap();
    private final IMChat chat;
    private final String nick;
    private final String jabberServer;
    private final String commandPrefix;

    public Bot(IMChat chat, String nick, String jabberServer, String commandPrefix) {
        this.chat = chat;
        this.nick = nick;
        this.jabberServer = jabberServer;
        this.commandPrefix = commandPrefix;
        this.BUILD_COMMAND = new BuildCommand(this.nick + "@" + this.jabberServer);
        COMMAND_MAP.put("build", this.BUILD_COMMAND);
        COMMAND_MAP.put("schedule", this.BUILD_COMMAND);
        COMMAND_MAP.put("help", this.HELP_COMMAND);
        COMMAND_MAP.put("alias", new SetAliasCommand(this));
        this.cmdsAndAliases.putAll(COMMAND_MAP);
        chat.addMessageListener((IMMessageListener)this);
        if (chat.isMultiUserChat()) {
            this.addShutdownHook();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void onMessage(IMMessage msg) {
        String[] args;
        String payload = this.retrieveMessagePayLoad(msg.getBody());
        if (payload != null && (args = MessageHelper.extractCommandLine((String)payload)).length > 0) {
            String cmd = args[0];
            String sender = msg.getFrom();
            if (sender != null) {
                sender = this.chat.getNickName(sender);
            }
            try {
                BotCommand command = (BotCommand)this.cmdsAndAliases.get(cmd);
                if (command != null) {
                    command.executeCommand(this.chat, msg, sender, args);
                } else {
                    this.chat.sendMessage(sender + " did you mean me? Unknown command '" + cmd + "'\nUse " + this.commandPrefix + "help to get help!");
                }
            }
            catch (IMException e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
        }
    }

    private static boolean isNickSeparator(String candidate) {
        return ":".equals(candidate) || ",".equals(candidate);
    }

    private String retrieveMessagePayLoad(String body) {
        if (body == null) {
            return null;
        }
        if (body.startsWith(this.commandPrefix)) {
            return body.substring(this.commandPrefix.length()).trim();
        }
        if (body.startsWith(this.nick) && Bot.isNickSeparator((String)body.substring(this.nick.length(), this.nick.length() + 1))) {
            return body.substring(this.nick.length() + 1).trim();
        }
        return null;
    }

    BotCommand getCommand(String name) {
        return (BotCommand)this.cmdsAndAliases.get(name);
    }

    BotCommand addAlias(String name, BotCommand alias) {
        BotCommand old = (BotCommand)this.cmdsAndAliases.get(name);
        if (old != null && !(old instanceof SetAliasCommand.AliasCommand)) {
            throw new IllegalArgumentException("Won't override built-in command: '" + name + "'!");
        }
        this.cmdsAndAliases.put(name, alias);
        this.HELP_CACHE = null;
        return old;
    }

    SetAliasCommand.AliasCommand removeAlias(String name) {
        BotCommand alias = (BotCommand)this.cmdsAndAliases.get(name);
        if (alias instanceof SetAliasCommand.AliasCommand) {
            this.cmdsAndAliases.remove(name);
            return (SetAliasCommand.AliasCommand)alias;
        }
        return null;
    }

    SortedMap<String, SetAliasCommand.AliasCommand> getAliases() {
        TreeMap<String, SetAliasCommand.AliasCommand> result = new TreeMap<String, SetAliasCommand.AliasCommand>();
        for (Map.Entry entry : this.cmdsAndAliases.entrySet()) {
            if (!(entry.getValue() instanceof SetAliasCommand.AliasCommand)) continue;
            result.put((String)entry.getKey(), (SetAliasCommand.AliasCommand)entry.getValue());
        }
        return result;
    }

    static /* synthetic */ String access$000(Bot x0) {
        return x0.HELP_CACHE;
    }

    static /* synthetic */ SortedMap access$100(Bot x0) {
        return x0.cmdsAndAliases;
    }

    static /* synthetic */ String access$002(Bot x0, String x1) {
        x0.HELP_CACHE = x1;
        return x0.HELP_CACHE;
    }

    static /* synthetic */ IMChat access$200(Bot x0) {
        return x0.chat;
    }

    static {
        COMMAND_MAP.put("status", STATUS_COMMAND);
        COMMAND_MAP.put("s", STATUS_COMMAND);
        COMMAND_MAP.put("health", HEALTH_COMMAND);
        COMMAND_MAP.put("h", HEALTH_COMMAND);
        COMMAND_MAP.put("jobs", STATUS_COMMAND);
        COMMAND_MAP.put("queue", QUEUE_COMMAND);
        COMMAND_MAP.put("q", QUEUE_COMMAND);
        COMMAND_MAP.put("testresult", TESTRESULTS_COMMAND);
        COMMAND_MAP.put("abort", ABORT_COMMAND);
        COMMAND_MAP.put("botsnack", SNACK_COMMAND);
    }
}

