/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport.bot;

import hudson.plugins.jabber.im.transport.bot.AbstractTextSendingCommand;
import hudson.plugins.jabber.im.transport.bot.Bot;
import hudson.plugins.jabber.im.transport.bot.BotCommand;
import hudson.plugins.jabber.im.transport.bot.SetAliasCommand;
import hudson.plugins.jabber.tools.MessageHelper;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang.ArrayUtils;

public class SetAliasCommand
extends AbstractTextSendingCommand {
    private final Bot bot;

    public SetAliasCommand(Bot bot) {
        this.bot = bot;
    }

    protected String getReply(String sender, String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException();
        }
        if (args.length == 1) {
            SortedMap aliases = this.bot.getAliases();
            if (aliases.isEmpty()) {
                return "Defined aliases: none";
            }
            StringBuilder msg = new StringBuilder("Defined aliases:");
            for (Map.Entry entry : aliases.entrySet()) {
                msg.append("\n\t").append((String)entry.getKey()).append(((AliasCommand)entry.getValue()).getHelp());
            }
            return msg.toString();
        }
        if (args.length < 3) {
            String alias = args[1];
            AliasCommand aliasCmd = this.bot.removeAlias(alias);
            if (aliasCmd != null) {
                return "deleted alias: " + alias + aliasCmd.getHelp();
            }
            return sender + ": don't know an alias called '" + alias + "'";
        }
        String alias = args[1];
        String cmdName = args[2];
        BotCommand cmd = this.bot.getCommand(cmdName);
        if (cmd == null) {
            return sender + ": sorry don't know a command or alias called '" + cmdName + "'";
        }
        String[] cmdArguments = ArrayUtils.EMPTY_STRING_ARRAY;
        if (args.length > 3) {
            cmdArguments = (String[])MessageHelper.copyOfRange((Object[])args, (int)3, (int)args.length);
        }
        AliasCommand aliasCmd = new AliasCommand(cmd, cmdName, cmdArguments);
        try {
            this.bot.addAlias(alias, (BotCommand)aliasCmd);
        }
        catch (IllegalArgumentException e) {
            return sender + ": " + e.getMessage();
        }
        return "created alias: " + alias + aliasCmd.getHelp();
    }

    public String getHelp() {
        return " [<alias> [<command>]] - defines a new alias, deletes one or lists all existing aliases";
    }
}

