/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.IMPublisherDescriptor;
import hudson.util.TimeUnit2;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIMConnection
implements IMConnection {
    private static final Logger LOGGER = Logger.getLogger(AbstractIMConnection.class.getName());
    private final Lock connectionLock = new ReentrantLock();
    private final ConnectorRunnable connector = new ConnectorRunnable();
    private volatile Thread connectorThread;
    private final IMPublisherDescriptor desc;
    private final BusyListener busyListener;

    protected AbstractIMConnection(IMPublisherDescriptor desc) {
        this.desc = desc;
        this.busyListener = new BusyListener();
    }

    @Override
    public final boolean connect() {
        boolean result = this.connect0();
        if (StringUtils.isNotBlank((String)this.desc.getHost())) {
            this.busyListener.register();
            this.connectorThread = new Thread((Runnable)this.connector, "IM-ConnectorThread");
            this.connectorThread.start();
        }
        return result;
    }

    protected abstract boolean connect0();

    protected final void lock() {
        this.connectionLock.lock();
    }

    protected final boolean tryLock(long time, TimeUnit timeUnit) throws InterruptedException {
        return this.connectionLock.tryLock(time, timeUnit);
    }

    protected final void unlock() {
        this.connectionLock.unlock();
    }

    protected void tryReconnect() {
        this.connector.semaphore.release();
    }

    protected void updateIMStatus() {
        this.updateIMStatus(null);
    }

    private void updateIMStatus(Run<?, ?> run) {
        int totalExecutors = this.getTotalExecutors();
        int busyExecutors = this.getBusyExecutors(run);
        try {
            if (busyExecutors == 0) {
                this.setPresence(IMPresence.AVAILABLE, "Yawn, I'm so bored. Don't you have some work for me?");
            } else if (busyExecutors == totalExecutors) {
                this.setPresence(IMPresence.DND, "Please give me some rest! All " + totalExecutors + " executors are busy, " + Hudson.getInstance().getQueue().getItems().length + " job(s) in queue.");
            } else {
                String msg = "Working: " + busyExecutors + " out of " + totalExecutors + " executors are busy.";
                int queueItems = Hudson.getInstance().getQueue().getItems().length;
                if (queueItems > 0) {
                    msg = msg + " " + queueItems + " job(s) in queue.";
                }
                this.setPresence(IMPresence.OCCUPIED, msg);
            }
        }
        catch (IMException e) {
            // empty catch block
        }
    }

    private int getBusyExecutors(Run<?, ?> run) {
        Computer[] computers;
        int busyExecutors = 0;
        boolean stillRunningExecutorFound = run == null;
        for (Computer compi : computers = Hudson.getInstance().getComputers()) {
            for (Executor executor : compi.getExecutors()) {
                if (!executor.isBusy()) continue;
                if (AbstractIMConnection.isNotEqual(executor.getCurrentExecutable(), run)) {
                    ++busyExecutors;
                    continue;
                }
                stillRunningExecutorFound = true;
            }
        }
        if (!stillRunningExecutorFound) {
            LOGGER.warning("Didn't find executor for run " + run + " among the list of busy executors.");
        }
        return busyExecutors;
    }

    private int getTotalExecutors() {
        Computer[] computers;
        int totalExecutors = 0;
        for (Computer compi : computers = Hudson.getInstance().getComputers()) {
            totalExecutors += compi.getNumExecutors();
        }
        return totalExecutors;
    }

    private static boolean isNotEqual(Queue.Executable executable, Run<?, ?> run) {
        if (run == null) {
            return true;
        }
        if (executable instanceof Run) {
            return !((Run)executable).getId().equals(run.getId());
        }
        return false;
    }

    protected abstract boolean isConnected();

    @Override
    public final void close() {
        if (this.connectorThread != null) {
            this.connectorThread.interrupt();
            this.connectorThread = null;
        }
        this.busyListener.unregister();
    }

    protected abstract void close0();

    private final class ConnectorRunnable
    implements Runnable {
        private final Semaphore semaphore = new Semaphore(0);

        private ConnectorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block5: while (true) {
                    this.semaphore.acquire();
                    LOGGER.info("Trying to reconnect");
                    TimeUnit.SECONDS.sleep(30L);
                    boolean success = false;
                    int timeout = 1;
                    while (true) {
                        if (success) continue block5;
                        AbstractIMConnection.this.lock();
                        try {
                            if (!AbstractIMConnection.this.isConnected()) {
                                AbstractIMConnection.this.close();
                                success = AbstractIMConnection.this.connect();
                            } else {
                                success = true;
                            }
                        }
                        finally {
                            AbstractIMConnection.this.unlock();
                        }
                        if (!success) {
                            LOGGER.info("Reconnect failed. Next connection attempt in " + timeout + " minutes");
                            TimeUnit2.MINUTES.sleep((long)timeout);
                            timeout *= 2;
                            continue;
                        }
                        this.semaphore.drainPermits();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Connect thread interrupted");
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BusyListener
    extends RunListener<Run> {
        public BusyListener() {
            super(Run.class);
            LOGGER.info("Executor busy listener created");
        }

        public void onCompleted(Run r, TaskListener listener) {
            AbstractIMConnection.this.updateIMStatus(r);
        }

        public void onDeleted(Run r) {
            AbstractIMConnection.this.updateIMStatus(null);
        }

        public void onStarted(Run r, TaskListener listener) {
            AbstractIMConnection.this.updateIMStatus(null);
        }
    }
}

