/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.User;
import hudson.plugins.jabber.NotificationStrategy;
import hudson.plugins.jabber.im.DefaultIMMessageTargetConverter;
import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.IMMessageTargetConverter;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.tools.BuildHelper;
import hudson.plugins.jabber.tools.MessageHelper;
import hudson.plugins.jabber.user.JabberUserProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IMPublisher
extends Notifier
implements BuildStep {
    private static final Logger LOGGER = Logger.getLogger(IMPublisher.class.getName());
    private static final IMMessageTargetConverter CONVERTER = new DefaultIMMessageTargetConverter();
    private final List<IMMessageTarget> targets = new LinkedList<IMMessageTarget>();
    private final NotificationStrategy notificationStrategy;
    private final boolean notifyOnBuildStart;
    private final boolean notifySuspects;
    private final boolean notifyCulprits;
    private final boolean notifyFixers;

    protected IMPublisher(String targetsAsString, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers) throws IMMessageTargetConversionException {
        Assert.isNotNull(targetsAsString, "Parameter 'targetsAsString' must not be null.");
        String[] split = targetsAsString.split("\\s");
        IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
        for (String fragment : split) {
            IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
            if (createIMMessageTarget == null) continue;
            this.targets.add(createIMMessageTarget);
        }
        NotificationStrategy strategy = NotificationStrategy.forDisplayName(notificationStrategyString);
        if (strategy == null) {
            strategy = NotificationStrategy.STATECHANGE_ONLY;
        }
        this.notificationStrategy = strategy;
        this.notifyOnBuildStart = notifyGroupChatsOnBuildStart;
        this.notifySuspects = notifySuspects;
        this.notifyCulprits = notifyCulprits;
        this.notifyFixers = notifyFixers;
    }

    protected abstract String getPluginName();

    protected abstract IMConnection getIMConnection() throws IMException;

    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    protected NotificationStrategy getNotificationStrategy() {
        return this.notificationStrategy;
    }

    private List<IMMessageTarget> getNotificationTargets() {
        return this.targets;
    }

    public final String getTargets() {
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget t : this.targets) {
            if (t instanceof GroupChatIMMessageTarget && !t.toString().contains("@conference.")) {
                sb.append("*");
            }
            sb.append(t.toString());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public final String getStrategy() {
        return this.getNotificationStrategy().getDisplayName();
    }

    public final boolean getNotifyOnStart() {
        return this.notifyOnBuildStart;
    }

    public final boolean getNotifySuspects() {
        return this.notifySuspects;
    }

    public final boolean getNotifyCulprits() {
        return this.notifyCulprits;
    }

    public final boolean getNotifyFixers() {
        return this.notifyFixers;
    }

    protected void log(BuildListener listener, String message) {
        listener.getLogger().append(this.getPluginName()).append(": ").append(message).append("\n");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        String message;
        Assert.isNotNull(build, "Parameter 'build' must not be null.");
        Assert.isNotNull(buildListener, "Parameter 'buildListener' must not be null.");
        if (this.getNotificationStrategy().notificationWanted(build)) {
            this.notifyChats(build, buildListener);
        }
        if (this.notifySuspects && BuildHelper.isFailureOrUnstable(build)) {
            this.log(buildListener, "Notifying suspects");
            message = "Oh no! You're suspected of having broken " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
            for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                try {
                    this.log(buildListener, "Sending notification to suspect: " + target.toString());
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    this.log(buildListener, "There was an error sending suspect notification to: " + target.toString());
                }
            }
        }
        if (this.notifyCulprits && BuildHelper.isFailureOrUnstable(build)) {
            this.log(buildListener, "Notifying culprits");
            message = "You're still being suspected of having broken " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
            for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCulpritsOnly(build), buildListener)) {
                try {
                    this.log(buildListener, "Sending notification to culprit: " + target.toString());
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    this.log(buildListener, "There was an error sending suspect notification to: " + target.toString());
                }
            }
        }
        if (this.notifyFixers && BuildHelper.isFix(build)) {
            buildListener.getLogger().append("Notifying fixers\n");
            message = "Yippie! Seems you've fixed " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
            for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                try {
                    this.log(buildListener, "Sending notification to fixer: " + target.toString());
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    this.log(buildListener, "There was an error sending fixer notification to: " + target.toString());
                }
            }
        }
        return true;
    }

    private void notifyChats(AbstractBuild<?, ?> build, BuildListener buildListener) {
        StringBuilder sb = BuildHelper.isFix(build) ? new StringBuilder("Yippie, build fixed!\n") : new StringBuilder();
        sb.append("Project ").append(build.getProject().getName()).append(" build (").append(build.getNumber()).append("): ").append(BuildHelper.getResultDescription(build)).append(" in ").append(build.getTimestampString()).append(": ").append(MessageHelper.getBuildURL(build));
        if (build.getChangeSet() != null && !build.getChangeSet().isEmptySet()) {
            boolean hasManyChangeSets = build.getChangeSet().getItems().length > 1;
            for (ChangeLogSet.Entry entry : build.getChangeSet()) {
                sb.append("\n");
                if (hasManyChangeSets) {
                    sb.append("* ");
                }
                sb.append(entry.getAuthor()).append(": ").append(entry.getMsg());
            }
        }
        String msg = sb.toString();
        for (IMMessageTarget target : this.getNotificationTargets()) {
            try {
                this.log(buildListener, "Sending notification to: " + target.toString());
                this.getIMConnection().send(target, msg);
            }
            catch (Throwable e) {
                this.log(buildListener, "There was an error sending notification to: " + target.toString());
            }
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener buildListener) {
        try {
            if (this.notifyOnBuildStart) {
                StringBuilder sb = new StringBuilder("Starting build ").append(build.getNumber()).append(" for job ").append(build.getProject().getName());
                if (build.getPreviousBuild() != null) {
                    sb.append(" (previous build: ").append(((AbstractBuild)build.getPreviousBuild()).getResult().toString().toLowerCase());
                    if (((AbstractBuild)build.getPreviousBuild()).getResult().isWorseThan(Result.SUCCESS)) {
                        sb.append(" -- last ").append(((AbstractBuild)build.getPreviousNotFailedBuild()).getResult().toString().toLowerCase()).append(" #").append(((AbstractBuild)build.getPreviousNotFailedBuild()).getNumber()).append(" ").append(((AbstractBuild)build.getPreviousNotFailedBuild()).getTimestampString()).append(" ago");
                    }
                    sb.append(")");
                }
                String msg = sb.toString();
                for (IMMessageTarget target : this.getNotificationTargets()) {
                    if (!(target instanceof GroupChatIMMessageTarget)) continue;
                    try {
                        this.getIMConnection().send(target, msg);
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending notification to: " + target.toString());
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log(buildListener, "There was an error in the Jabber plugin: " + t.toString());
        }
        return true;
    }

    private static Set<User> getCommitters(AbstractBuild<?, ?> build) {
        HashSet<User> committers = new HashSet<User>();
        ChangeLogSet changeSet = build.getChangeSet();
        for (ChangeLogSet.Entry entry : changeSet) {
            committers.add(entry.getAuthor());
        }
        return committers;
    }

    private static Set<User> getCulpritsOnly(AbstractBuild<?, ?> build) {
        HashSet<User> culprits = new HashSet<User>(build.getCulprits());
        culprits.removeAll(IMPublisher.getCommitters(build));
        return culprits;
    }

    private Collection<IMMessageTarget> calculateIMTargets(Set<User> targets, BuildListener listener) {
        HashSet<IMMessageTarget> suspects = new HashSet<IMMessageTarget>();
        String defaultSuffix = null;
        try {
            defaultSuffix = this.getIMConnection().getDefaultIdSuffix();
            if (StringUtils.isBlank((String)defaultSuffix)) {
                defaultSuffix = null;
            }
        }
        catch (IMException e) {
            // empty catch block
        }
        LOGGER.fine("Default Suffix: " + defaultSuffix);
        for (User target : targets) {
            LOGGER.fine("Possible target: " + target.getId());
            String jabberId = null;
            JabberUserProperty jabberUserProperty = (JabberUserProperty)((Object)target.getProperties().get((Object)JabberUserProperty.DESCRIPTOR));
            if (jabberUserProperty != null && jabberUserProperty.getJid() != null) {
                jabberId = jabberUserProperty.getJid();
            } else if (defaultSuffix != null) {
                jabberId = target.getId() + defaultSuffix;
            }
            if (jabberId != null) {
                try {
                    suspects.add(CONVERTER.fromString(jabberId));
                }
                catch (IMMessageTargetConversionException e) {
                    this.log(listener, "Invalid Jabber ID: " + jabberId);
                }
                continue;
            }
            this.log(listener, "No Jabber ID found for: " + target.getId());
        }
        return suspects;
    }

    public abstract BuildStepDescriptor<Publisher> getDescriptor();
}

