/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.AbstractIMConnection;
import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.transport.JabberChat;
import hudson.plugins.jabber.im.transport.JabberMessage;
import hudson.plugins.jabber.im.transport.JabberMultiUserChat;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.im.transport.bot.Bot;
import hudson.plugins.jabber.tools.Assert;
import hudson.plugins.jabber.tools.ExceptionHelper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.MessageEvent;
import org.jivesoftware.smackx.packet.XHTMLExtension;

class JabberIMConnection
extends AbstractIMConnection {
    private static final Logger LOGGER = Logger.getLogger(JabberIMConnection.class.getName());
    private volatile XMPPConnection connection;
    private final Map<String, WeakReference<GroupChat>> groupChatCache = new HashMap<String, WeakReference<GroupChat>>();
    private final Map<String, WeakReference<Chat>> chatCache = new HashMap<String, WeakReference<Chat>>();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick;
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final boolean legacySSL;
    private final String[] groupChats;
    private IMPresence impresence;
    private final String defaultIdSuffix;
    private String imStatusMessage;
    private JabberPublisherDescriptor desc;

    JabberIMConnection(JabberPublisherDescriptor desc) throws IMException {
        super(desc);
        Assert.isNotNull(desc, "Parameter 'desc' must not be null.");
        this.desc = desc;
        this.hostname = desc.getHostname();
        this.port = desc.getPort();
        this.legacySSL = desc.isLegacySSL();
        this.nick = desc.getJabberId();
        this.passwd = desc.getPassword();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getInitialGroupChats() != null ? desc.getInitialGroupChats().trim().split("\\s") : new String[0];
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
        this.defaultIdSuffix = desc.getDefaultIdSuffix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean connect0() {
        this.lock();
        try {
            if (!this.isConnected()) {
                if (this.createConnection()) {
                    LOGGER.info("Connected to XMPP on " + this.hostname + ":" + this.port);
                    this.updateIMStatus();
                    for (String groupChatName : this.groupChats) {
                        try {
                            groupChatName = groupChatName.trim();
                            this.createGroupChatConnection(groupChatName, true);
                            LOGGER.info("Joined groupchat " + groupChatName);
                        }
                        catch (XMPPException e) {
                            LOGGER.warning("Unable to connect to groupchat '" + groupChatName + "'. Did you append @conference or so to the name?\n" + "Message: " + e.toString());
                        }
                    }
                } else {
                    boolean arr$ = false;
                    return arr$;
                }
            }
            boolean arr$ = true;
            return arr$;
        }
        catch (Exception dontCare) {
            LOGGER.warning(ExceptionHelper.dump(dontCare));
            this.tryReconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close0() {
        this.lock();
        try {
            try {
                if (this.isConnected()) {
                    for (WeakReference<GroupChat> entry : this.groupChatCache.values()) {
                        GroupChat chat = (GroupChat)entry.get();
                        if (chat == null || !chat.isJoined()) continue;
                        chat.leave();
                    }
                    this.groupChatCache.clear();
                    this.chatCache.clear();
                    this.connection.close();
                }
            }
            finally {
                this.connection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean createConnection() throws XMPPException {
        String serviceName;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if ((serviceName = this.desc.getServiceName()) == null) {
            this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port) : new XMPPConnection(this.hostname, this.port);
        } else if (this.hostname == null) {
            this.connection = this.legacySSL ? new SSLXMPPConnection(serviceName) : new XMPPConnection(serviceName);
        } else {
            Object object = this.connection = this.legacySSL ? new SSLXMPPConnection(this.hostname, this.port, serviceName) : new XMPPConnection(this.hostname, this.port, serviceName);
        }
        if (this.connection.isConnected()) {
            this.connection.login(this.desc.getUserName(), this.passwd, "Hudson");
            String fullUser = this.desc.getUserName() + "@" + this.hostname;
            AndFilter filter = new AndFilter((PacketFilter)new MessageTypeFilter(Message.Type.CHAT), (PacketFilter)new ToContainsFilter(fullUser));
            IMListener listener = new IMListener();
            this.connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
            this.connection.addConnectionListener(new ConnectionListener(){

                public void connectionClosedOnError(Exception paramException) {
                    JabberIMConnection.this.tryReconnect();
                }

                public void connectionClosed() {
                    JabberIMConnection.this.tryReconnect();
                }
            });
        }
        return this.connection.isAuthenticated();
    }

    private GroupChat createGroupChatConnection(String groupChatName, boolean forceReconnect) throws XMPPException {
        boolean create;
        WeakReference<GroupChat> ref = this.groupChatCache.get(groupChatName);
        GroupChat groupChat = null;
        if (ref != null) {
            groupChat = (GroupChat)ref.get();
        }
        boolean bl = create = groupChat == null || forceReconnect;
        if (forceReconnect && groupChat != null) {
            try {
                this.groupChatCache.remove(groupChatName);
                groupChat.leave();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (create) {
            groupChat = this.connection.createGroupChat(groupChatName);
            groupChat.join(this.groupChatNick);
            while (groupChat.pollMessage() != null) {
            }
            new Bot(new JabberMultiUserChat(groupChat), this.groupChatNick, this.hostname, this.botCommandPrefix);
            this.groupChatCache.put(groupChatName, new WeakReference<GroupChat>(groupChat));
        }
        return groupChat;
    }

    private Chat getChat(String chatPartner, Message msg) {
        Chat c;
        WeakReference<Chat> wr = this.chatCache.get(chatPartner);
        if (wr != null && (c = (Chat)wr.get()) != null) {
            return c;
        }
        Chat chat = this.connection.createChat(chatPartner);
        Bot bot = new Bot(new JabberChat(chat), this.groupChatNick, this.hostname, this.botCommandPrefix);
        if (msg != null) {
            bot.onMessage(new JabberMessage(msg));
        }
        this.chatCache.put(chatPartner, new WeakReference<Chat>(chat));
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull(target, "Parameter 'target' must not be null.");
        Assert.isNotNull(text, "Parameter 'text' must not be null.");
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                if (target instanceof GroupChatIMMessageTarget) {
                    this.createGroupChatConnection(target.toString(), false).sendMessage(text);
                } else {
                    Chat chat = this.getChat(target.toString(), null);
                    chat.sendMessage(text);
                }
            }
            catch (XMPPException dontCare) {
                LOGGER.warning(ExceptionHelper.dump(dontCare));
                this.tryReconnect();
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setPresence(IMPresence impresence, String statusMessage) throws IMException {
        Assert.isNotNull((Object)impresence, "Parameter 'impresence' must not be null.");
        if (this.desc.isExposePresence()) {
            this.impresence = impresence;
            this.imStatusMessage = statusMessage;
        } else {
            this.impresence = IMPresence.UNAVAILABLE;
            this.imStatusMessage = "";
        }
        this.sendPresence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                Presence presence;
                if (!this.isConnected()) {
                    return;
                }
                switch (this.impresence) {
                    case AVAILABLE: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.AVAILABLE);
                        break;
                    }
                    case OCCUPIED: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.AWAY);
                        break;
                    }
                    case DND: {
                        presence = new Presence(Presence.Type.AVAILABLE, this.imStatusMessage, 1, Presence.Mode.DO_NOT_DISTURB);
                        break;
                    }
                    case UNAVAILABLE: {
                        presence = new Presence(Presence.Type.UNAVAILABLE);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle " + (Object)((Object)this.impresence));
                    }
                }
                this.connection.sendPacket((Packet)presence);
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnected() {
        this.lock();
        try {
            boolean bl = this.connection != null && this.connection.isAuthenticated();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    private final class IMListener
    implements PacketListener {
        private IMListener() {
        }

        public void processPacket(Packet packet) {
            if (packet instanceof Message) {
                Message m = (Message)packet;
                boolean composing = false;
                boolean xhtmlMessage = false;
                Iterator extensions = m.getExtensions();
                while (extensions.hasNext()) {
                    MessageEvent me;
                    PacketExtension ext = (PacketExtension)extensions.next();
                    if (ext instanceof DelayInformation) {
                        return;
                    }
                    if (ext instanceof MessageEvent && (me = (MessageEvent)ext).isComposing()) {
                        composing = true;
                    }
                    if (!(ext instanceof XHTMLExtension)) continue;
                    xhtmlMessage = true;
                }
                if (composing && !xhtmlMessage) {
                    return;
                }
                if (m.getBody() != null) {
                    LOGGER.info("Message from " + m.getFrom() + " : " + m.getBody());
                    String chatPartner = m.getFrom();
                    JabberIMConnection.this.getChat(chatPartner, m);
                }
            }
        }
    }
}

