/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.DefaultIMMessageTarget;
import hudson.plugins.jabber.im.DefaultIMMessageTargetConverter;
import hudson.plugins.jabber.im.GroupChatIMMessageTarget;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.IMMessageTargetConverter;
import hudson.plugins.jabber.im.IMPublisher;
import hudson.plugins.jabber.im.transport.JabberIMConnectionProvider;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JabberPublisher
extends IMPublisher {
    public static final JabberPublisherDescriptor DESCRIPTOR = new JabberPublisherDescriptor();
    private static final IMMessageTargetConverter CONVERTER = new JabberIMMessageTargetConverter();

    public JabberPublisher(String targetsAsString, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers) throws IMMessageTargetConversionException {
        super(targetsAsString, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers);
    }

    @Override
    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected IMConnection getIMConnection() throws IMException {
        return JabberIMConnectionProvider.getInstance().currentConnection();
    }

    @Override
    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    @Override
    protected String getPluginName() {
        return "Jabber notifier plugin";
    }

    private static class JabberIMMessageTargetConverter
    extends DefaultIMMessageTargetConverter {
        private JabberIMMessageTargetConverter() {
        }

        private void checkValidity(String f) throws IMMessageTargetConversionException {
            int i = f.indexOf(64);
            if (f.indexOf(64, i + 1) > -1) {
                throw new IMMessageTargetConversionException("Invalid input for target: '" + f + "'");
            }
        }

        public IMMessageTarget fromString(String targetAsString) throws IMMessageTargetConversionException {
            String f = targetAsString.trim();
            if (f.length() > 0) {
                IMMessageTarget target;
                if (f.startsWith("*")) {
                    if (!(f = f.substring(1)).contains("@")) {
                        f = f + "@conference." + DESCRIPTOR.getHostname();
                    }
                    target = new GroupChatIMMessageTarget(f);
                } else if (f.contains("@conference.")) {
                    target = new GroupChatIMMessageTarget(f);
                } else {
                    if (!f.contains("@")) {
                        f = f + "@" + DESCRIPTOR.getHostname();
                    }
                    target = new DefaultIMMessageTarget(f);
                }
                this.checkValidity(f);
                return target;
            }
            return null;
        }
    }
}

