/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im;

import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.plugins.jabber.NotificationStrategy;
import hudson.plugins.jabber.im.DefaultIMMessageTargetConverter;
import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMMessageTargetConversionException;
import hudson.plugins.jabber.im.IMMessageTargetConverter;
import hudson.plugins.jabber.tools.Assert;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IMPublisher
extends Publisher {
    private static final IMMessageTargetConverter CONVERTER = new DefaultIMMessageTargetConverter();
    private final List<IMMessageTarget> targets = new LinkedList();

    protected IMPublisher(String targetsAsString) throws IMMessageTargetConversionException {
        Assert.isNotNull((Object)targetsAsString, (String)"Parameter 'targetsAsString' must not be null.");
        String[] split = targetsAsString.split("\\s");
        IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
        for (String fragment : split) {
            IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
            if (createIMMessageTarget == null) continue;
            this.targets.add(createIMMessageTarget);
        }
    }

    protected abstract IMConnection getIMConnection() throws IMException;

    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    protected NotificationStrategy getNotificationStrategy() {
        return NotificationStrategy.STATECHANGE_ONLY;
    }

    private List<IMMessageTarget> getNotificationTargets() {
        return this.targets;
    }

    public final String getTargets() {
        StringBuffer sb = new StringBuffer();
        for (IMMessageTarget t : this.targets) {
            sb.append(t.toString());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public boolean perform(Build build, Launcher arg1, BuildListener arg2) throws InterruptedException, IOException {
        Assert.isNotNull((Object)build, (String)"Parameter 'build' must not be null.");
        Assert.isNotNull((Object)arg2, (String)"Parameter 'arg2' must not be null.");
        if (this.getNotificationStrategy().notificationWanted(build)) {
            String msg = "Project " + ((Project)build.getProject()).getName() + " build (#" + build.getNumber() + "): " + build.getResult();
            for (IMMessageTarget target : this.getNotificationTargets()) {
                try {
                    arg2.getLogger().append("Sending notification to: " + target.toString() + "\n");
                    this.getIMConnection().send(target, msg);
                }
                catch (Throwable e) {
                    arg2.getLogger().append("There was an Error sending notification to: " + target.toString() + "\n");
                }
            }
        }
        return false;
    }
}

