/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMMessageTarget;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.tools.Assert;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

class JabberIMConnection
implements IMConnection {
    private static final String DND_MESSAGE = "I\uff74m busy building your software...";
    private XMPPConnection connection;
    private final int port;
    private final String nick;
    private final String passwd;
    private final String hostname;

    JabberIMConnection(JabberPublisherDescriptor desc) throws IMException {
        Assert.isNotNull((Object)desc, (String)"Parameter 'desc' must not be null.");
        this.hostname = desc.getHostname();
        this.port = desc.getPort();
        this.nick = desc.getHudsonNickname();
        this.passwd = desc.getHudsonPassword();
        try {
            this.createConnection();
        }
        catch (XMPPException dontCare) {
            dontCare.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.connection != null && this.connection.isConnected()) {
                this.connection.close();
            }
        }
        finally {
            this.connection = null;
        }
    }

    private void createConnection() throws XMPPException {
        if (this.connection == null || !this.connection.isConnected()) {
            this.connection = new XMPPConnection(this.hostname, this.port);
            this.connection.login(this.nick, this.passwd);
        }
    }

    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.isNotNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.isNotNull((Object)text, (String)"Parameter 'text' must not be null.");
        try {
            this.createConnection();
            Chat chat = this.connection.createChat(target.toString());
            chat.sendMessage(text);
        }
        catch (XMPPException dontCare) {
            dontCare.printStackTrace();
        }
    }

    public synchronized void setPresence(IMPresence impresence) throws IMException {
        Assert.isNotNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        try {
            this.createConnection();
            Presence presence = null;
            switch (1.$SwitchMap$hudson$plugins$jabber$im$IMPresence[impresence.ordinal()]) {
                case 1: {
                    presence = new Presence(Presence.Type.AVAILABLE, DND_MESSAGE, 1, Presence.Mode.DO_NOT_DISTURB);
                    break;
                }
                case 2: {
                    presence = new Presence(Presence.Type.UNAVAILABLE);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don\uff74t know how to handle " + impresence);
                }
            }
            this.connection.sendPacket((Packet)presence);
        }
        catch (XMPPException e) {
            throw new IMException((Exception)((Object)e));
        }
    }
}

