/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jabber.im.transport;

import hudson.plugins.jabber.im.IMConnection;
import hudson.plugins.jabber.im.IMException;
import hudson.plugins.jabber.im.IMPresence;
import hudson.plugins.jabber.im.transport.JabberIMConnection;
import hudson.plugins.jabber.im.transport.JabberPublisherDescriptor;
import hudson.plugins.jabber.tools.Assert;

final class JabberIMConnectionProvider {
    private static final JabberIMConnectionProvider INSTANCE = new JabberIMConnectionProvider();
    private IMConnection imConnection;
    private JabberPublisherDescriptor descriptor;

    static final JabberIMConnectionProvider getInstance() {
        return INSTANCE;
    }

    private JabberIMConnectionProvider() {
    }

    synchronized IMConnection createConnection(JabberPublisherDescriptor desc) throws IMException {
        Assert.isNotNull((Object)desc, (String)"Parameter 'desc' must not be null.");
        this.descriptor = desc;
        this.releaseConnection();
        if (desc.getHostname() != null) {
            this.imConnection = new JabberIMConnection(desc);
            this.imConnection.setPresence(desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE);
        }
        return this.imConnection;
    }

    synchronized IMConnection currentConnection() throws IMException {
        return this.imConnection != null ? this.imConnection : this.createConnection(this.descriptor);
    }

    synchronized void releaseConnection() {
        if (this.imConnection != null) {
            this.imConnection.close();
            this.imConnection = null;
        }
    }
}

